/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.AbstractRestorer;
import gov.nasa.jpf.jvm.CollapsePools;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.IncrementalChangeTracker;
import gov.nasa.jpf.jvm.Monitor;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadData;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.ThreadList;
import gov.nasa.jpf.util.ObjVector;
import java.util.Arrays;

public class CollapsingRestorer
extends AbstractRestorer<KState>
implements IncrementalChangeTracker {
    protected final CollapsePools.AllWeak pool = new CollapsePools.AllWeak();
    protected final ObjVector<TState> tCaches = new ObjVector();
    protected final ObjVector<DEIState> dCaches = new ObjVector();
    protected final ObjVector<SEIState> sCaches = new ObjVector();
    protected final transient ObjVector<StackFrame> tmpFrames = new ObjVector();

    @Override
    protected KState computeRestorableData() {
        this.updateThreadListCache(this.ks.tl);
        this.updateStaticAreaCache(this.ks.sa);
        this.updateDynamicAreaCache(this.ks.da);
        TState[] tstates = this.tCaches.toArray(new TState[this.tCaches.size()]);
        DEIState[] dstates = this.dCaches.toArray(new DEIState[this.dCaches.size()]);
        SEIState[] sstates = this.sCaches.toArray(new SEIState[this.sCaches.size()]);
        return new KState(tstates, dstates, sstates);
    }

    protected void updateThreadListCache(ThreadList tl) {
        int length = tl.length();
        this.tCaches.setSize(length);
        for (int i = 0; i < length; ++i) {
            ThreadInfo ti = tl.get(i);
            this.tCaches.set(i, this.updateThreadCache(ti, this.tCaches.get(i)));
        }
    }

    protected TState updateThreadCache(ThreadInfo ti, TState entry) {
        ThreadData td;
        int length = ti.stack.size();
        if (ti.tdChanged || entry == null || ti != entry.ti) {
            ti.threadData = td = this.pool.poolThreadData(ti.threadData);
        } else {
            td = entry.td;
        }
        int firstChanged = entry != null && ti == entry.ti ? (ti.hasChanged.isEmpty() ? length : ti.hasChanged.nextSetBit(0)) : 0;
        if (entry != null) {
            this.tmpFrames.append(entry.frames, 0, firstChanged);
        }
        for (int i = firstChanged; i < length; ++i) {
            this.tmpFrames.add(this.pool.poolStackFrame(ti.stack.get(i)));
        }
        ti.markUnchanged();
        StackFrame[] frames = this.tmpFrames.toArray(new StackFrame[this.tmpFrames.size()]);
        this.tmpFrames.clear();
        return new TState(ti, td, frames);
    }

    protected void updateDynamicAreaCache(DynamicArea area) {
        if (area.anyChanged()) {
            int length = area.getLength();
            this.dCaches.setSize(length);
            int i = 0;
            while ((i = area.getNextChanged(i)) >= 0) {
                DynamicElementInfo ei = (DynamicElementInfo)area.get(i);
                if (ei != null) {
                    Fields f = this.poolFields(ei);
                    Monitor m = this.poolMonitor(ei);
                    int a = ei.getAttributes();
                    this.dCaches.set(i, new DEIState(f, m, a));
                    ei.markUnchanged();
                } else {
                    this.dCaches.set(i, null);
                }
                ++i;
            }
            area.markUnchanged();
        }
    }

    protected Fields poolFields(ElementInfo ei) {
        return this.pool.poolFields(ei.fields);
    }

    protected Monitor poolMonitor(ElementInfo ei) {
        return this.pool.poolMonitor(ei.monitor);
    }

    protected void updateStaticAreaCache(StaticArea area) {
        if (area.anyChanged()) {
            int length = area.getLength();
            this.sCaches.setSize(length);
            int i = 0;
            while ((i = area.getNextChanged(i)) >= 0) {
                StaticElementInfo ei = (StaticElementInfo)area.get(i);
                if (ei != null) {
                    Fields f = this.poolFields(ei);
                    Monitor m = this.poolMonitor(ei);
                    int a = ei.getAttributes();
                    int c = ei.getClassObjectRef();
                    int s = ei.getStatus();
                    this.sCaches.set(i, new SEIState(f, m, a, c, s));
                    ei.markUnchanged();
                } else {
                    this.sCaches.set(i, null);
                }
                ++i;
            }
            area.markUnchanged();
        }
    }

    @Override
    protected void doRestore(KState state) {
        this.doRestore(this.ks.tl, state.tstates);
        this.doRestore(this.ks.sa, state.sstates);
        this.doRestore(this.ks.da, state.dstates);
    }

    protected void doRestore(ThreadList tl, TState[] tstates) {
        int newLength = tstates.length;
        ThreadInfo[] threads = new ThreadInfo[newLength];
        for (int i = 0; i < newLength; ++i) {
            threads[i] = this.restoreThreadInfo(tstates[i]);
        }
        tl.setAll(threads);
        this.tCaches.clear();
        this.tCaches.append(tstates);
    }

    protected ThreadInfo restoreThreadInfo(TState tstate) {
        ThreadData td = tstate.td;
        int objRef = td.objref;
        ThreadInfo ti = ThreadInfo.threadInfos.get(objRef);
        ti.resetVolatiles();
        ti.restoreThreadData(td);
        ti.replaceStackFrames(Arrays.asList(tstate.frames));
        ti.markUnchanged();
        return ti;
    }

    protected void restoreFields(ElementInfo ei, Fields fields) {
        ei.fields = fields;
    }

    protected void doRestore(DynamicArea area, DEIState[] dstates) {
        int length = dstates.length;
        area.resetVolatiles();
        area.removeAllFrom(length);
        for (int i = 0; i < length; ++i) {
            DEIState estate = dstates[i];
            if (estate != null) {
                DynamicElementInfo ei = (DynamicElementInfo)area.ensureAndGet(i);
                this.restoreFields(ei, estate.fields);
                ei.monitor = estate.monitor;
                ei.attributes = estate.attributes;
                ei.markUnchanged();
                ei.updateLockingInfo();
                continue;
            }
            area.remove(i, true);
        }
        area.restoreVolatiles();
        area.markUnchanged();
        this.dCaches.clear();
        this.dCaches.append(dstates);
    }

    protected void doRestore(StaticArea area, SEIState[] sstates) {
        int length = sstates.length;
        area.resetVolatiles();
        area.removeAllFrom(length);
        for (int i = 0; i < length; ++i) {
            SEIState estate = sstates[i];
            if (estate != null) {
                StaticElementInfo ei = (StaticElementInfo)area.ensureAndGet(i);
                this.restoreFields(ei, estate.fields);
                ei.monitor = estate.monitor;
                ei.attributes = estate.attributes;
                ei.classObjectRef = estate.classRef;
                ei.status = estate.status;
                ei.markUnchanged();
                ei.updateLockingInfo();
                continue;
            }
            area.remove(i, true);
        }
        area.restoreVolatiles();
        area.markUnchanged();
        this.sCaches.clear();
        this.sCaches.append(sstates);
    }

    protected static class SEIState
    extends DEIState {
        public final int classRef;
        public final int status;

        public SEIState(Fields fields, Monitor monitor, int attributes, int classRef, int status) {
            super(fields, monitor, attributes);
            this.classRef = classRef;
            this.status = status;
        }
    }

    protected static class DEIState {
        public final Fields fields;
        public final Monitor monitor;
        public final int attributes;

        public DEIState(Fields fields, Monitor monitor, int attributes) {
            this.fields = fields;
            this.monitor = monitor;
            this.attributes = attributes;
        }
    }

    protected static class TState {
        public final ThreadInfo ti;
        public final ThreadData td;
        public final StackFrame[] frames;

        public TState(ThreadInfo ti, ThreadData td, StackFrame[] frames) {
            this.ti = ti;
            this.td = td;
            this.frames = frames;
        }
    }

    protected static class KState {
        public final TState[] tstates;
        public final DEIState[] dstates;
        public final SEIState[] sstates;

        public KState(TState[] tstates, DEIState[] dstates, SEIState[] sstates) {
            this.tstates = tstates;
            this.dstates = dstates;
            this.sstates = sstates;
        }
    }
}

