/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import java.util.Random;

public abstract class ChoiceGenerator<T>
implements Cloneable {
    public static final char MARKER = '>';
    protected static Random random = new Random(42L);
    public String id;
    int idRef;
    protected boolean isDone;
    ChoiceGenerator<?> prev;
    Instruction insn;
    ThreadInfo ti;

    public static void init(Config config) {
        long seed = config.getLong("cg.seed", 42L);
        if (seed != 42L) {
            random = new Random(seed);
        }
    }

    protected ChoiceGenerator() {
        this.id = "-";
    }

    protected ChoiceGenerator(String id) {
        this.id = id;
    }

    public abstract T getNextChoice();

    public abstract Class<T> getChoiceType();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getId() {
        return this.id;
    }

    public int getIdRef() {
        return this.idRef;
    }

    public void setIdRef(int idRef) {
        this.idRef = idRef;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setThreadInfo(ThreadInfo ti) {
        this.ti = ti;
    }

    public ThreadInfo getThreadInfo() {
        return this.ti;
    }

    public void setInsn(Instruction insn) {
        this.insn = insn;
    }

    public Instruction getInsn() {
        return this.insn;
    }

    public void setPreviousChoiceGenerator(ChoiceGenerator<?> cg) {
        this.prev = cg;
    }

    public ChoiceGenerator<?> getPreviousChoiceGeneratorOfType(Class<?> cls) {
        ChoiceGenerator<?> cg = this.prev;
        while (cg != null) {
            if (cls.isInstance(cg)) {
                return cg;
            }
            cg = cg.prev;
        }
        return null;
    }

    public abstract boolean hasMoreChoices();

    public abstract void advance();

    public void advance(int nChoices) {
        while (nChoices-- > 0) {
            this.advance();
        }
    }

    public void select(int nChoice) {
        this.advance(nChoice);
        this.setDone();
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void setDone() {
        this.isDone = true;
    }

    public abstract void reset();

    public abstract int getTotalNumberOfChoices();

    public abstract int getProcessedNumberOfChoices();

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getName());
        b.append(" [id=\"");
        b.append(this.id);
        b.append("\" ,");
        b.append(this.getProcessedNumberOfChoices());
        b.append('/');
        b.append(this.getTotalNumberOfChoices());
        b.append(']');
        return b.toString();
    }

    public ChoiceGenerator<?> getPreviousChoiceGenerator() {
        return this.prev;
    }

    public abstract ChoiceGenerator<?> randomize();
}

