/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.AbstractSerializerDeserializer;
import gov.nasa.jpf.jvm.ArrayOffset;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.IncrementalChangeTracker;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.ThreadList;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.ObjVector;

public abstract class CachingSerializerDeserializer
extends AbstractSerializerDeserializer
implements IncrementalChangeTracker {
    protected final IntVector daCache = new IntVector();
    protected final IntVector saCache = new IntVector();
    protected final ObjVector<TCacheEntry> threadCaches = new ObjVector();

    protected TCacheEntry ensureAndGetThreadEntry(int i) {
        TCacheEntry entry = this.threadCaches.get(i);
        if (entry == null) {
            entry = new TCacheEntry();
            this.threadCaches.set(i, entry);
        }
        return entry;
    }

    @Override
    protected int[] computeStoringData() {
        this.updateThreadListCache(this.ks.tl);
        this.updateStaticAreaCache(this.ks.sa);
        this.updateDynamicAreaCache(this.ks.da);
        int totalLen = 1;
        int nThreads = this.threadCaches.size();
        for (int i = 0; i < nThreads; ++i) {
            totalLen += this.threadCaches.get((int)i).cache.size();
        }
        int[] data = new int[totalLen += this.saCache.size() + this.daCache.size()];
        data[0] = nThreads;
        int pos = 1;
        for (int i = 0; i < nThreads; ++i) {
            pos = this.threadCaches.get((int)i).cache.dumpTo(data, pos);
        }
        pos = this.saCache.dumpTo(data, pos);
        pos = this.daCache.dumpTo(data, pos);
        assert (pos == totalLen);
        return data;
    }

    protected void updateThreadListCache(ThreadList tl) {
        int length = tl.length();
        for (int i = 0; i < length; ++i) {
            ThreadInfo ti = tl.get(i);
            TCacheEntry cache = this.ensureAndGetThreadEntry(i);
            this.updateThreadCache(ti, cache);
        }
        this.threadCaches.setSize(length);
    }

    protected abstract void updateThreadCache(ThreadInfo var1, TCacheEntry var2);

    protected abstract void updateDynamicAreaCache(DynamicArea var1);

    protected abstract void updateStaticAreaCache(StaticArea var1);

    @Override
    protected void doRestore(int[] data) {
        ArrayOffset storing = new ArrayOffset(data);
        this.doRestore(this.ks.tl, storing);
        this.doRestore(this.ks.sa, storing);
        this.doRestore(this.ks.da, storing);
    }

    protected void doRestore(ThreadList tl, ArrayOffset storing) {
        int newLength = storing.get();
        ThreadInfo[] threads = new ThreadInfo[newLength];
        for (int i = 0; i < newLength; ++i) {
            threads[i] = this.restoreThreadInfo(storing, this.ensureAndGetThreadEntry(i));
        }
        tl.setAll(threads);
    }

    protected abstract ThreadInfo restoreThreadInfo(ArrayOffset var1, TCacheEntry var2);

    protected abstract void doRestore(DynamicArea var1, ArrayOffset var2);

    protected abstract void doRestore(StaticArea var1, ArrayOffset var2);

    static final class TCacheEntry {
        final IntVector cache = new IntVector();
        ThreadInfo ti;

        TCacheEntry() {
        }
    }
}

