/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.Types;

public class ArrayFields
extends Fields {
    private int elementStorageSize;
    private int length;
    private String elementType;
    private boolean isReference;

    public ArrayFields(String type, ClassInfo ci, int storageSize, int length, boolean isReference) {
        super(type, ci, storageSize);
        this.length = length;
        this.isReference = isReference;
        this.elementType = type.substring(1);
        this.elementStorageSize = Types.getTypeSize(type);
        if (isReference) {
            for (int i = 0; i < length; ++i) {
                this.values[i] = -1;
            }
        }
    }

    @Override
    int getNumberOfFieldsOrElements() {
        return this.length;
    }

    @Override
    public int arrayLength() {
        return this.length;
    }

    @Override
    public int getHeapSize() {
        return Types.getTypeSizeInBytes(this.elementType) * this.length;
    }

    public FieldInfo getFieldInfo(String clsBase, String fname) {
        return null;
    }

    @Override
    public int getNumberOfFields() {
        return 0;
    }

    @Override
    public FieldInfo getFieldInfo(int fieldIndex) {
        return null;
    }

    public int getFieldIndex(String name, String referenceType) {
        throw new NoSuchFieldError("array does not have any fields!" + this.getClassInfo().getName() + "." + name);
    }

    public String getFieldName(int index) {
        return Integer.toString(index / this.elementStorageSize);
    }

    public String getFieldType(String name, String referenceType) {
        throw new NoSuchFieldError("array does not have any fields!" + this.getClassInfo().getName() + "." + name);
    }

    public String getFieldType(int findex) {
        if (this.elementType == null) {
            this.elementType = this.getType().substring(1);
        }
        return this.elementType;
    }

    @Override
    public String getLogChar() {
        return "*";
    }

    public void setLongField(String name, String referenceType, long value) {
        throw new NoSuchFieldError("array does not have any fields!" + this.getClassInfo().getName() + "." + name);
    }

    public long getLongField(String name, String referenceType) {
        throw new NoSuchFieldError("array does not have any fields!" + this.getClassInfo().getName() + "." + name);
    }

    @Override
    public boolean isReferenceArray() {
        return this.isReference;
    }

    public boolean isRef(String name, String referenceType) {
        throw new NoSuchFieldError("array does not have any fields!" + this.getClassInfo().getName() + "." + name);
    }

    @Override
    public boolean[] asBooleanArray() {
        int length = this.values.length;
        boolean[] result = new boolean[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Types.intToBoolean(this.values[i]);
        }
        return result;
    }

    @Override
    public byte[] asByteArray() {
        int length = this.values.length;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)this.values[i];
        }
        return result;
    }

    @Override
    public char[] asCharArray() {
        int length = this.values.length;
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)this.values[i];
        }
        return result;
    }

    public char[] asCharArray(int offset, int length) {
        char[] result = new char[length];
        int max = offset + length;
        int i = offset;
        int j = 0;
        while (i < max) {
            result[j] = (char)this.values[i];
            ++i;
            ++j;
        }
        return result;
    }

    public boolean equals(int offset, int length, String s) {
        if (offset + length > this.values.length) {
            return false;
        }
        int i = offset;
        for (int j = 0; j < length; ++j) {
            if ((char)this.values[i] != s.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public short[] asShortArray() {
        int length = this.values.length;
        short[] result = new short[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (short)this.values[i];
        }
        return result;
    }

    @Override
    public int[] asIntArray() {
        return (int[])this.values.clone();
    }

    @Override
    public long[] asLongArray() {
        int length = this.values.length / 2;
        long[] result = new long[length];
        int i = 0;
        int j = 0;
        while (i < length) {
            result[i] = Types.intsToLong(this.values[j + 1], this.values[j]);
            ++i;
            j += 2;
        }
        return result;
    }

    @Override
    public float[] asFloatArray() {
        int length = this.values.length;
        float[] result = new float[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Types.intToFloat(this.values[i]);
        }
        return result;
    }

    @Override
    public double[] asDoubleArray() {
        int length = this.values.length / 2;
        double[] result = new double[length];
        int i = 0;
        int j = 0;
        while (i < length) {
            result[i] = Types.intsToDouble(this.values[j + 1], this.values[j]);
            ++i;
            j += 2;
        }
        return result;
    }
}

