/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.util.HashData;
import gov.nasa.jpf.util.ObjVector;
import java.util.BitSet;
import java.util.NoSuchElementException;

public abstract class Area<EI extends ElementInfo>
implements Iterable<EI> {
    protected ObjVector<EI> elements;
    protected int nElements;
    public final KernelState ks;
    protected final BitSet hasChanged;

    public Area(KernelState ks) {
        this.ks = ks;
        this.elements = new ObjVector(1024);
        this.nElements = 0;
        this.hasChanged = new BitSet();
    }

    public Iterator iterator() {
        return new Iterator();
    }

    void resetVolatiles() {
    }

    void restoreVolatiles() {
    }

    void cleanUpDanglingReferences() {
        for (ElementInfo e : this) {
            if (e == null) continue;
            e.cleanUp();
        }
    }

    public int count() {
        return this.nElements;
    }

    public int getNextChanged(int startIdx) {
        return this.hasChanged.nextSetBit(startIdx);
    }

    public EI get(int index) {
        if (index < 0) {
            return null;
        }
        return (EI)((ElementInfo)this.elements.get(index));
    }

    public EI ensureAndGet(int index) {
        ElementInfo ei = (ElementInfo)this.elements.get(index);
        if (ei == null) {
            ei = this.createElementInfo();
            ei.setArea(this);
            ei.setIndex(index);
            this.elements.set(index, ei);
            ++this.nElements;
        }
        return (EI)ei;
    }

    public int getLength() {
        return this.elements.size();
    }

    public void hash(HashData hd) {
        int length = this.elements.size();
        for (int i = 0; i < length; ++i) {
            ElementInfo ei = (ElementInfo)this.elements.get(i);
            if (ei == null) continue;
            ei.hash(hd);
        }
    }

    public int hashCode() {
        HashData hd = new HashData();
        this.hash(hd);
        return hd.getValue();
    }

    public void removeAll() {
        this.removeAllFrom(0);
    }

    public void removeAllFrom(int idx) {
        int l = this.elements.size();
        for (int i = idx; i < l; ++i) {
            this.remove(i, true);
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + super.hashCode();
    }

    protected void add(int index, EI e) {
        ((ElementInfo)e).setArea(this);
        ((ElementInfo)e).setIndex(index);
        assert (this.elements.get(index) == null) : "trying to overwrite non-null object: " + this.elements.get(index) + " with: " + e;
        ++this.nElements;
        this.elements.set(index, e);
        this.markChanged(index);
    }

    protected void markChanged(int index) {
        this.hasChanged.set(index);
        this.ks.changed();
    }

    public void markUnchanged() {
        this.hasChanged.clear();
    }

    public boolean anyChanged() {
        return !this.hasChanged.isEmpty();
    }

    protected void remove(int index, boolean nullOk) {
        ElementInfo ei = (ElementInfo)this.elements.get(index);
        if (nullOk && ei == null) {
            return;
        }
        assert (ei != null) : "trying to remove null object at index: " + index;
        ei.setArea(null);
        ei.setIndex(-1);
        this.elements.set(index, null);
        this.elements.squeeze();
        --this.nElements;
        this.markChanged(index);
    }

    abstract EI createElementInfo();

    public class Iterator
    implements java.util.Iterator<EI> {
        int i;
        int visited;

        @Override
        public void remove() {
            throw new UnsupportedOperationException("illegal operation, only GC can remove objects");
        }

        @Override
        public boolean hasNext() {
            return this.i < Area.this.elements.size() && this.visited < Area.this.nElements;
        }

        @Override
        public EI next() {
            while (this.i < Area.this.elements.size()) {
                ElementInfo ei = (ElementInfo)Area.this.elements.get(this.i);
                if (ei != null) {
                    ++this.i;
                    ++this.visited;
                    return ei;
                }
                ++this.i;
            }
            throw new NoSuchElementException();
        }
    }
}

