/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.ConfigChangeListener;
import gov.nasa.jpf.Error;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.JPFListener;
import gov.nasa.jpf.Property;
import gov.nasa.jpf.PropertyListenerAdapter;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.VMListener;
import gov.nasa.jpf.report.Publisher;
import gov.nasa.jpf.report.PublisherExtension;
import gov.nasa.jpf.report.Reporter;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.search.SearchListener;
import gov.nasa.jpf.util.LogManager;
import gov.nasa.jpf.util.Misc;
import gov.nasa.jpf.util.ObjArray;
import gov.nasa.jpf.util.RunRegistry;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Logger;

public class JPF
implements Runnable {
    public static String VERSION = "4.?";
    static Logger logger = null;
    Config config;
    Search search;
    JVM vm;
    Reporter reporter;
    Status status = Status.NEW;
    byte[] memoryReserve;

    private static Logger initLogging(Config conf) {
        LogManager.init(conf);
        return JPF.getLogger("gov.nasa.jpf");
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogger(name);
    }

    public static void main(String[] args) {
        block9: {
            String[] origArgs = (String[])args.clone();
            Config conf = JPF.createConfig(args);
            if (logger == null) {
                logger = JPF.initLogging(conf);
            }
            try {
                Class<?> shellCls = conf.getClass("jpf.shell.class");
                if (shellCls != null) {
                    Method m = shellCls.getMethod("main", String[].class);
                    if (m != null) {
                        m.invoke(null, new Object[]{origArgs});
                        return;
                    }
                    logger.severe("shell class has no main() method: " + shellCls.getName());
                }
            }
            catch (Throwable t) {
                logger.severe("exception during shell initialization: " + t);
                t.printStackTrace();
                return;
            }
            LogManager.printStatus(logger);
            conf.printStatus(logger);
            if (JPF.isHelpRequest(args)) {
                JPF.showUsage();
                return;
            }
            if (JPF.isPrintConfigRequest(args)) {
                conf.print(new PrintWriter(System.out));
            }
            JPF.checkUnknownArgs(args);
            try {
                JPF jpf = new JPF(conf);
                jpf.run();
            }
            catch (ExitException x) {
                if (!x.shouldReport()) break block9;
                x.printStackTrace();
            }
        }
    }

    public JPF(Config conf) {
        String tgt;
        this.config = conf;
        if (logger == null) {
            logger = JPF.initLogging(this.config);
        }
        if ((tgt = this.config.getTargetArg()) == null || tgt.length() == 0) {
            logger.severe("no target class specified, terminating");
        } else {
            this.initialize();
        }
    }

    public JPF(String[] args) {
        this(JPF.createConfig(args));
    }

    private void initialize() {
        VERSION = this.config.getString("jpf.version", VERSION);
        this.memoryReserve = new byte[this.config.getInt("jpf.memory_reserve", 10000)];
        try {
            ClassLoader loader = this.config.getClassLoader("jpf.native_classpath");
            this.config.setCurrentClassLoader(loader);
            Class[] vmArgTypes = new Class[]{JPF.class, Config.class};
            Object[] vmArgs = new Object[]{this, this.config};
            this.vm = this.config.getEssentialInstance("vm.class", JVM.class, vmArgTypes, vmArgs);
            Class[] searchArgTypes = new Class[]{Config.class, JVM.class};
            Object[] searchArgs = new Object[]{this.config, this.vm};
            this.search = this.config.getEssentialInstance("search.class", Search.class, searchArgTypes, searchArgs);
            this.addListeners();
            this.config.addChangeListener(new ConfigListener());
        }
        catch (Config.Exception cx) {
            logger.severe(cx.toString());
            throw new ExitException(false);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isRunnable() {
        return this.vm != null && this.search != null;
    }

    public void addPropertyListener(PropertyListenerAdapter pl) {
        if (this.vm != null) {
            this.vm.addListener(pl);
        }
        if (this.search != null) {
            this.search.addListener(pl);
            this.search.addProperty(pl);
        }
    }

    public void addSearchListener(SearchListener l) {
        if (this.search != null) {
            this.search.addListener(l);
        }
    }

    public void addListener(JPFListener l) {
        if (l instanceof VMListener && this.vm != null) {
            this.vm.addListener((VMListener)l);
        }
        if (l instanceof SearchListener && this.search != null) {
            this.search.addListener((SearchListener)l);
        }
    }

    public void addUniqueTypeListener(JPFListener l) {
        Class<?> cls = l.getClass();
        if (l instanceof VMListener && this.vm != null && !this.vm.hasListenerOfType(cls)) {
            this.vm.addListener((VMListener)l);
        }
        if (l instanceof SearchListener && this.search != null && !this.search.hasListenerOfType(cls)) {
            this.search.addListener((SearchListener)l);
        }
    }

    public void removeListener(JPFListener l) {
        if (l instanceof VMListener && this.vm != null) {
            this.vm.removeListener((VMListener)l);
        }
        if (l instanceof SearchListener && this.search != null) {
            this.search.removeListener((SearchListener)l);
        }
    }

    public void addVMListener(VMListener l) {
        if (this.vm != null) {
            this.vm.addListener(l);
        }
    }

    public void addSearchProperty(Property p) {
        if (this.search != null) {
            this.search.addProperty(p);
        }
    }

    void addListeners() throws Config.Exception {
        ObjArray<JPFListener> listeners;
        Class[] argTypes = new Class[]{Config.class, JPF.class};
        Object[] args = new Object[]{this.config, this};
        this.reporter = this.config.getInstance("jpf.report.class", Reporter.class, argTypes, args);
        if (this.reporter != null) {
            this.addListener(this.reporter);
        }
        if ((listeners = this.config.getInstances("jpf.listener", JPFListener.class, argTypes, args)) != null) {
            for (JPFListener l : listeners) {
                this.addListener(l);
            }
        }
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public <T extends Publisher> boolean addPublisherExtension(Class<T> pCls, PublisherExtension e) {
        if (this.reporter != null) {
            return this.reporter.addPublisherExtension(pCls, e);
        }
        return false;
    }

    public <T extends Publisher> void setPublisherTopics(Class<T> pCls, int category, String[] topics) {
        if (this.reporter != null) {
            this.reporter.setPublisherTopics(pCls, category, topics);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public Search getSearch() {
        return this.search;
    }

    public JVM getVM() {
        return this.vm;
    }

    public static void exit() {
        throw new ExitException();
    }

    public boolean foundErrors() {
        return !this.search.getErrors().isEmpty();
    }

    public static boolean isHelpRequest(String[] args) {
        if (args == null) {
            return true;
        }
        if (args.length == 0) {
            return true;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!"-help".equals(args[i])) continue;
            args[i] = null;
            return true;
        }
        return false;
    }

    public static boolean isPrintConfigRequest(String[] args) {
        if (args == null) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!"-show".equals(args[i])) continue;
            args[i] = null;
            return true;
        }
        return false;
    }

    static void checkUnknownArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (args[i].charAt(0) != '-') break;
            logger.warning("unknown command line option: " + args[i]);
        }
    }

    public static void printBanner(Config config) {
        System.out.println("Java Pathfinder Model Checker v" + config.getString("jpf.version", "4") + " - (C) 1999-2008 RIACS/NASA Ames Research Center");
    }

    static String getArg(String[] args, String pattern, String defValue, boolean consume) {
        String s = defValue;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg == null || !arg.matches(pattern)) continue;
                int idx = arg.indexOf(61);
                if (idx > 0) {
                    s = arg.substring(idx + 1);
                    if (!consume) break;
                    args[i] = null;
                    break;
                }
                if (i >= args.length - 1) break;
                s = args[i + 1];
                if (!consume) break;
                args[i] = null;
                args[i + 1] = null;
                break;
            }
        }
        return s;
    }

    static String getConfigFileName(String[] args) {
        int idx;
        String lastArg;
        if (args.length > 0 && ((lastArg = args[idx = args.length - 1]).endsWith(".jpf") || lastArg.endsWith(".JPF"))) {
            int i;
            if (lastArg.startsWith("-c") && (i = lastArg.indexOf(61)) > 0) {
                lastArg = lastArg.substring(i + 1);
            }
            args[idx] = null;
            return lastArg;
        }
        return JPF.getArg(args, "-c(onfig)?(=.+)?", "jpf.properties", true);
    }

    static String getRootDirName(String[] args) {
        return JPF.getArg(args, "[+]jpf[.]basedir(=.+)?", null, false);
    }

    public static Config createConfig(String[] args) {
        String pf = JPF.getConfigFileName(args);
        String rd = JPF.getRootDirName(args);
        return new Config(args, pf, rd, JPF.class);
    }

    public static Config createConfig(String configFileName, String[] args) {
        String rd = JPF.getRootDirName(args);
        return new Config(args, configFileName, rd, JPF.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Runtime rt = Runtime.getRuntime();
        RunRegistry.getDefaultRegistry().reset();
        if (this.isRunnable()) {
            try {
                if (this.vm.initialize()) {
                    this.status = Status.RUNNING;
                    this.search.search();
                }
            }
            catch (ExitException ex) {
                logger.severe("JPF terminated");
            }
            catch (JPFException jx) {
                logger.severe("JPF exception, terminating: " + jx.getMessage());
                if (this.config.getBoolean("jpf.print_exception_stack")) {
                    jx.printStackTrace();
                }
            }
            catch (OutOfMemoryError oom) {
                this.memoryReserve = null;
                long m0 = rt.freeMemory();
                long d = 10000L;
                while (true) {
                    rt.gc();
                    long m1 = rt.freeMemory();
                    if (m1 <= m0 || m1 - m0 < d) break;
                    m0 = m1;
                }
                logger.severe("JPF out of memory");
                this.reporter.searchFinished(this.search);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.status = Status.DONE;
            }
        }
    }

    public List<Error> getSearchErrors() {
        if (this.search != null) {
            return this.search.getErrors();
        }
        return null;
    }

    static void showUsage() {
        System.out.println("Usage: \"java [<vm-option>..] gov.nasa.jpf.JPF [<jpf-option>..] [<app> [<app-arg>..]]");
        System.out.println("  <jpf-option> : -c <config-file>  : name of config properties file (default \"jpf.properties\")");
        System.out.println("               | -help  : print usage information");
        System.out.println("               | -show  : print configuration dictionary contents");
        System.out.println("               | +<key>=<value>  : add or override key/value pair to config dictionary");
        System.out.println("  <app>        : application class or *.xml error trace file");
        System.out.println("  <app-arg>    : arguments passed into main(String[]) if application class");
    }

    public static void handleException(JPFException e) {
        logger.severe(e.getMessage());
        JPF.exit();
    }

    static class ExitException
    extends RuntimeException {
        boolean report = true;

        ExitException() {
        }

        ExitException(boolean report) {
            this.report = report;
        }

        ExitException(String msg) {
            super(msg);
        }

        public boolean shouldReport() {
            return this.report;
        }
    }

    class ConfigListener
    implements ConfigChangeListener {
        ConfigListener() {
        }

        @Override
        public void propertyChanged(Config config, String key, String oldValue, String newValue) {
            if ("jpf.listener".equals(key)) {
                String[] nv = config.asExpandedStringArray(newValue);
                String[] ov = config.asExpandedStringArray(oldValue);
                String[] newListeners = Misc.getAddedElements(ov, nv);
                if (newListeners != null) {
                    for (String clsName : newListeners) {
                        try {
                            JPFListener newListener = config.getInstance("jpf.listener", clsName, JPFListener.class);
                            JPF.this.addListener(newListener);
                            logger.info("config changed, added jpf.listener " + clsName);
                        }
                        catch (Config.Exception cfx) {
                            logger.warning("jpf.listener change failed: " + cfx.getMessage());
                        }
                    }
                }
            }
        }
    }

    public static enum Status {
        NEW,
        RUNNING,
        DONE;

    }
}

