/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.transport.TransportServerSupport;
import org.apache.activemq.transport.http.HttpTunnelServlet;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.transport.xstream.XStreamWireFormat;
import org.apache.activemq.util.ServiceStopper;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.servlet.SessionHandler;

public class HttpTransportServer
extends TransportServerSupport {
    private URI bindAddress;
    private TextWireFormat wireFormat;
    private Server server;
    private Connector connector;

    public HttpTransportServer(URI uri) {
        super(uri);
        this.bindAddress = uri;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public TextWireFormat getWireFormat() {
        if (this.wireFormat == null) {
            this.wireFormat = this.createWireFormat();
        }
        return this.wireFormat;
    }

    public void setWireFormat(TextWireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    protected TextWireFormat createWireFormat() {
        return new XStreamWireFormat();
    }

    protected void setConnector(Connector connector) {
        this.connector = connector;
    }

    protected void doStart() throws Exception {
        this.server = new Server();
        if (this.connector == null) {
            this.connector = new SocketConnector();
        }
        this.connector.setHost(this.bindAddress.getHost());
        this.connector.setPort(this.bindAddress.getPort());
        this.connector.setServer(this.server);
        this.server.setConnectors(new Connector[]{this.connector});
        ContextHandler context_handler = new ContextHandler();
        context_handler.setContextPath("/");
        context_handler.setServer(this.server);
        this.server.setHandler((Handler)context_handler);
        SessionHandler session_handler = new SessionHandler();
        context_handler.setHandler((Handler)session_handler);
        ServletHandler servlet_handler = new ServletHandler();
        session_handler.setHandler((Handler)servlet_handler);
        ServletHolder holder = new ServletHolder();
        holder.setName("httpTunnel");
        holder.setClassName(HttpTunnelServlet.class.getName());
        servlet_handler.setServlets(new ServletHolder[]{holder});
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("httpTunnel");
        mapping.setPathSpec("/*");
        servlet_handler.setServletMappings(new ServletMapping[]{mapping});
        context_handler.setAttribute("acceptListener", (Object)this.getAcceptListener());
        context_handler.setAttribute("wireFormat", (Object)this.getWireFormat());
        this.server.start();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        Server temp = this.server;
        this.server = null;
        if (temp != null) {
            temp.stop();
        }
    }

    public InetSocketAddress getSocketAddress() {
        return null;
    }
}

