/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.ResponseCorrelator;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.util.FactoryFinder;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.activemq.wireformat.WireFormatFactory;

public abstract class TransportFactory {
    private static final FactoryFinder transportFactoryFinder = new FactoryFinder("META-INF/services/org/apache/activemq/transport/");
    private static final FactoryFinder wireFormatFactoryFinder = new FactoryFinder("META-INF/services/org/apache/activemq/wireformat/");
    private static final ConcurrentHashMap transportFactorys = new ConcurrentHashMap();

    public abstract TransportServer doBind(String var1, URI var2) throws IOException;

    public Transport doConnect(URI location, Executor ex) throws Exception {
        return this.doConnect(location);
    }

    public Transport doCompositeConnect(URI location, Executor ex) throws Exception {
        return this.doCompositeConnect(location);
    }

    public static Transport connect(URI location) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doConnect(location);
    }

    public static Transport connect(URI location, Executor ex) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doConnect(location, ex);
    }

    public static Transport compositeConnect(URI location) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doCompositeConnect(location);
    }

    public static Transport compositeConnect(URI location, Executor ex) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doCompositeConnect(location, ex);
    }

    public static TransportServer bind(String brokerId, URI location) throws IOException {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doBind(brokerId, location);
    }

    public Transport doConnect(URI location) throws Exception {
        try {
            HashMap options = new HashMap(URISupport.parseParamters(location));
            WireFormat wf = this.createWireFormat(options);
            Transport transport = this.createTransport(location, wf);
            Transport rc = this.configure(transport, wf, options);
            if (!options.isEmpty()) {
                throw new IllegalArgumentException("Invalid connect parameters: " + options);
            }
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public Transport doCompositeConnect(URI location) throws Exception {
        try {
            HashMap options = new HashMap(URISupport.parseParamters(location));
            WireFormat wf = this.createWireFormat(options);
            Transport transport = this.createTransport(location, wf);
            Transport rc = this.compositeConfigure(transport, wf, options);
            if (!options.isEmpty()) {
                throw new IllegalArgumentException("Invalid connect parameters: " + options);
            }
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    protected Transport createTransport(URI location, WireFormat wf) throws MalformedURLException, UnknownHostException, IOException {
        throw new IOException("createTransport() method not implemented!");
    }

    private static TransportFactory findTransportFactory(URI location) throws IOException {
        String scheme = location.getScheme();
        if (scheme == null) {
            throw new IOException("Transport not scheme specified: [" + location + "]");
        }
        TransportFactory tf = (TransportFactory)transportFactorys.get(scheme);
        if (tf == null) {
            try {
                tf = (TransportFactory)transportFactoryFinder.newInstance(scheme);
                transportFactorys.put(scheme, tf);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("Transport scheme NOT recognized: [" + scheme + "]", e);
            }
        }
        return tf;
    }

    protected WireFormat createWireFormat(Map options) throws IOException {
        WireFormatFactory factory = this.createWireFormatFactory(options);
        WireFormat format = factory.createWireFormat();
        return format;
    }

    protected WireFormatFactory createWireFormatFactory(Map options) throws IOException {
        String wireFormat = (String)options.get("wireFormat");
        if (wireFormat == null) {
            wireFormat = this.getDefaultWireFormatType();
        }
        try {
            WireFormatFactory wff = (WireFormatFactory)wireFormatFactoryFinder.newInstance(wireFormat);
            IntrospectionSupport.setProperties(wff, options, "wireFormat.");
            return wff;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Could not create wire format factory for: " + wireFormat + ", reason: " + e, e);
        }
    }

    protected String getDefaultWireFormatType() {
        return "default";
    }

    public Transport configure(Transport transport, WireFormat wf, Map options) throws Exception {
        transport = this.compositeConfigure(transport, wf, options);
        transport = new MutexTransport(transport);
        transport = new ResponseCorrelator(transport);
        return transport;
    }

    public Transport serverConfigure(Transport transport, WireFormat format, HashMap options) throws Exception {
        transport = this.compositeConfigure(transport, format, options);
        transport = new MutexTransport(transport);
        return transport;
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        IntrospectionSupport.setProperties(transport, options);
        return transport;
    }
}

