/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.state;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.state.SessionState;
import org.apache.activemq.state.TransactionState;

public class ConnectionState {
    final ConnectionInfo info;
    private final ConcurrentHashMap transactions = new ConcurrentHashMap();
    private final ConcurrentHashMap sessions = new ConcurrentHashMap();
    private final List tempDestinations = Collections.synchronizedList(new ArrayList());
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public ConnectionState(ConnectionInfo info) {
        this.info = info;
        this.addSession(new SessionInfo(info, -1L));
    }

    public String toString() {
        return this.info.toString();
    }

    public void addTempDestination(DestinationInfo info) {
        this.checkShutdown();
        this.tempDestinations.add(info);
    }

    public void removeTempDestination(ActiveMQDestination destination) {
        Iterator iter = this.tempDestinations.iterator();
        while (iter.hasNext()) {
            DestinationInfo di = (DestinationInfo)iter.next();
            if (!di.getDestination().equals(destination)) continue;
            iter.remove();
        }
    }

    public void addTransactionState(TransactionId id) {
        this.checkShutdown();
        this.transactions.put(id, new TransactionState(id));
    }

    public TransactionState getTransactionState(TransactionId id) {
        return (TransactionState)this.transactions.get(id);
    }

    public Collection getTransactionStates() {
        return this.transactions.values();
    }

    public TransactionState removeTransactionState(TransactionId id) {
        return (TransactionState)this.transactions.remove(id);
    }

    public void addSession(SessionInfo info) {
        this.checkShutdown();
        this.sessions.put(info.getSessionId(), new SessionState(info));
    }

    public SessionState removeSession(SessionId id) {
        return (SessionState)this.sessions.remove(id);
    }

    public SessionState getSessionState(SessionId id) {
        return (SessionState)this.sessions.get(id);
    }

    public ConnectionInfo getInfo() {
        return this.info;
    }

    public Set getSessionIds() {
        return this.sessions.keySet();
    }

    public List getTempDesinations() {
        return this.tempDestinations;
    }

    public Collection getSessionStates() {
        return this.sessions.values();
    }

    private void checkShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("Disposed");
        }
    }

    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            Iterator iter = this.sessions.values().iterator();
            while (iter.hasNext()) {
                SessionState ss = (SessionState)iter.next();
                ss.shutdown();
            }
        }
    }
}

