/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.CertificateCallback;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.UserPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CertificateLoginModule
implements LoginModule {
    private CallbackHandler callbackHandler;
    private Subject subject;
    private X509Certificate[] certificates;
    private String username = null;
    private Set groups = null;
    private Set principals = new HashSet();
    private static final Log log = LogFactory.getLog(CertificateLoginModule.class);
    private boolean debug;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (this.debug) {
            log.debug("Initialized debug");
        }
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CertificateCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " Unable to obtain client certificates.");
        }
        this.certificates = ((CertificateCallback)callbacks[0]).getCertificates();
        this.username = this.getUserNameForCertificates(this.certificates);
        if (this.username == null) {
            throw new FailedLoginException("No user for client certificate: " + this.getDistinguishedName(this.certificates));
        }
        this.groups = this.getUserGroups(this.username);
        if (this.debug) {
            log.debug("Certificate for user: " + this.username);
        }
        return true;
    }

    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.username));
        String currentGroup = null;
        Iterator iter = this.groups.iterator();
        while (iter.hasNext()) {
            currentGroup = (String)iter.next();
            this.principals.add(new GroupPrincipal(currentGroup));
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        if (this.debug) {
            log.debug("commit");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            log.debug("abort");
        }
        return true;
    }

    public boolean logout() {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            log.debug("logout");
        }
        return true;
    }

    private void clear() {
        this.groups.clear();
        this.certificates = null;
    }

    protected abstract String getUserNameForCertificates(X509Certificate[] var1) throws LoginException;

    protected abstract Set getUserGroups(String var1) throws LoginException;

    protected String getDistinguishedName(X509Certificate[] certs) {
        if (certs != null && certs.length > 0 && certs[0] != null) {
            return certs[0].getSubjectDN().getName();
        }
        return null;
    }
}

