/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.AnnotationElementValue;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.EnumElementValue;
import org.apache.bcel.classfile.SimpleElementValue;
import org.apache.bcel.generic.AnnotationElementValueGen;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.ArrayElementValueGen;
import org.apache.bcel.generic.ClassElementValueGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.EnumElementValueGen;
import org.apache.bcel.generic.SimpleElementValueGen;

public abstract class ElementValueGen {
    protected int type;
    protected ConstantPoolGen cpGen;
    public static final int STRING = 115;
    public static final int ENUM_CONSTANT = 101;
    public static final int CLASS = 99;
    public static final int ANNOTATION = 64;
    public static final int ARRAY = 91;
    public static final int PRIMITIVE_INT = 73;
    public static final int PRIMITIVE_BYTE = 66;
    public static final int PRIMITIVE_CHAR = 67;
    public static final int PRIMITIVE_DOUBLE = 68;
    public static final int PRIMITIVE_FLOAT = 70;
    public static final int PRIMITIVE_LONG = 74;
    public static final int PRIMITIVE_SHORT = 83;
    public static final int PRIMITIVE_BOOLEAN = 90;

    protected ElementValueGen(int n, ConstantPoolGen constantPoolGen) {
        this.type = n;
        this.cpGen = constantPoolGen;
    }

    public abstract ElementValue getElementValue();

    public int getElementValueType() {
        return this.type;
    }

    public abstract String stringifyValue();

    public abstract void dump(DataOutputStream var1) throws IOException;

    public static ElementValueGen readElementValue(DataInputStream dataInputStream, ConstantPoolGen constantPoolGen) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        switch (n) {
            case 66: {
                return new SimpleElementValueGen(66, dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 67: {
                return new SimpleElementValueGen(67, dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 68: {
                return new SimpleElementValueGen(68, dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 70: {
                return new SimpleElementValueGen(70, dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 73: {
                return new SimpleElementValueGen(73, dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 74: {
                return new SimpleElementValueGen(74, dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 83: {
                return new SimpleElementValueGen(83, dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 90: {
                return new SimpleElementValueGen(90, dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 115: {
                return new SimpleElementValueGen(115, dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 101: {
                return new EnumElementValueGen(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 99: {
                return new ClassElementValueGen(dataInputStream.readUnsignedShort(), constantPoolGen);
            }
            case 64: {
                return new AnnotationElementValueGen(64, new AnnotationEntryGen(AnnotationEntry.read(dataInputStream, constantPoolGen.getConstantPool(), true), constantPoolGen, false), constantPoolGen);
            }
            case 91: {
                int n2 = dataInputStream.readUnsignedShort();
                ElementValue[] elementValueArray = new ElementValue[n2];
                for (int i = 0; i < n2; ++i) {
                    elementValueArray[i] = ElementValue.readElementValue(dataInputStream, constantPoolGen.getConstantPool());
                }
                return new ArrayElementValueGen(91, elementValueArray, constantPoolGen);
            }
        }
        throw new RuntimeException("Unexpected element value kind in annotation: " + n);
    }

    protected ConstantPoolGen getConstantPool() {
        return this.cpGen;
    }

    public static ElementValueGen copy(ElementValue elementValue, ConstantPoolGen constantPoolGen, boolean bl) {
        switch (elementValue.getElementValueType()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new SimpleElementValueGen((SimpleElementValue)elementValue, constantPoolGen, bl);
            }
            case 101: {
                return new EnumElementValueGen((EnumElementValue)elementValue, constantPoolGen, bl);
            }
            case 64: {
                return new AnnotationElementValueGen((AnnotationElementValue)elementValue, constantPoolGen, bl);
            }
            case 91: {
                return new ArrayElementValueGen((ArrayElementValue)elementValue, constantPoolGen, bl);
            }
            case 99: {
                return new ClassElementValueGen((ClassElementValue)elementValue, constantPoolGen, bl);
            }
        }
        throw new RuntimeException("Not implemented yet! (" + elementValue.getElementValueType() + ")");
    }
}

