/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public class AnnotationEntry
implements Node,
Constants {
    private int type_index;
    private int num_element_value_pairs;
    private List element_value_pairs;
    private ConstantPool constant_pool;
    private boolean isRuntimeVisible;

    public AnnotationEntry(int n, ConstantPool constantPool, boolean bl) {
        this.type_index = n;
        this.constant_pool = constantPool;
        this.isRuntimeVisible = bl;
    }

    public static AnnotationEntry read(DataInputStream dataInputStream, ConstantPool constantPool, boolean bl) throws IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(dataInputStream.readUnsignedShort(), constantPool, bl);
        annotationEntry.num_element_value_pairs = dataInputStream.readUnsignedShort();
        annotationEntry.element_value_pairs = new ArrayList();
        for (int i = 0; i < annotationEntry.num_element_value_pairs; ++i) {
            annotationEntry.element_value_pairs.add(new ElementValuePair(dataInputStream.readUnsignedShort(), ElementValue.readElementValue(dataInputStream, constantPool), constantPool));
        }
        return annotationEntry;
    }

    public void accept(Visitor visitor) {
    }

    public String getAnnotationType() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.type_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public int getAnnotationTypeIndex() {
        return this.type_index;
    }

    public final int getNumElementValuePairs() {
        return this.num_element_value_pairs;
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.element_value_pairs.toArray(new ElementValuePair[this.element_value_pairs.size()]);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.type_index);
        dataOutputStream.writeShort(this.element_value_pairs.size());
        for (int i = 0; i < this.element_value_pairs.size(); ++i) {
            ElementValuePair elementValuePair = (ElementValuePair)this.element_value_pairs.get(i);
            elementValuePair.dump(dataOutputStream);
        }
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public void addElementNameValuePair(ElementValuePair elementValuePair) {
        this.element_value_pairs.add(elementValuePair);
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@");
        stringBuffer.append(this.getAnnotationType());
        if (this.getElementValuePairs().length > 0) {
            stringBuffer.append("(");
            for (int i = 0; i < this.getElementValuePairs().length; ++i) {
                ElementValuePair elementValuePair = this.getElementValuePairs()[i];
                stringBuffer.append(elementValuePair.toShortString());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

