/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.MJIEnv;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JPF_java_util_regex_Matcher {
    static HashMap<Integer, Matcher> matchers;

    public static void init(Config conf) {
        matchers = new HashMap();
    }

    static void putInstance(MJIEnv env, int objref, Matcher matcher) {
        int id = env.getIntField(objref, "id");
        matchers.put(id, matcher);
    }

    static Matcher getInstance(MJIEnv env, int objref) {
        int id = env.getIntField(objref, "id");
        return matchers.get(id);
    }

    public static void register____V(MJIEnv env, int objref) {
        int patRef = env.getReferenceField(objref, "pattern");
        int regexRef = env.getReferenceField(patRef, "regex");
        String regex = env.getStringObject(regexRef);
        int flags = env.getIntField(patRef, "flags");
        Pattern pat = Pattern.compile(regex, flags);
        int inputRef = env.getReferenceField(objref, "input");
        String input = env.getStringObject(inputRef);
        Matcher matcher = pat.matcher(input);
        JPF_java_util_regex_Matcher.putInstance(env, objref, matcher);
    }

    public static boolean matches____Z(MJIEnv env, int objref) {
        Matcher matcher = JPF_java_util_regex_Matcher.getInstance(env, objref);
        return matcher.matches();
    }

    public static int reset____Ljava_util_regex_Matcher_2(MJIEnv env, int objref) {
        Matcher matcher = JPF_java_util_regex_Matcher.getInstance(env, objref);
        int inputRef = env.getReferenceField(objref, "input");
        String input = env.getStringObject(inputRef);
        matcher = matcher.reset(input);
        JPF_java_util_regex_Matcher.putInstance(env, objref, matcher);
        return objref;
    }

    public static int group__I__Ljava_lang_String_2(MJIEnv env, int objref, int i) {
        Matcher matcher = JPF_java_util_regex_Matcher.getInstance(env, objref);
        String grp = matcher.group(i);
        return env.newString(grp);
    }
}

