/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.ConfigChangeListener;
import gov.nasa.jpf.jvm.JPF_gov_nasa_jpf_jvm_Verify;
import gov.nasa.jpf.jvm.MJIEnv;

public class JPF_java_util_Random {
    static final long multiplier = 25214903917L;
    static final long addend = 11L;
    static final long mask = 0xFFFFFFFFFFFFL;
    static boolean enumerateRandom;

    public static void init(Config conf) {
        JPF_java_util_Random.setEnumerateRandom(conf);
        conf.addChangeListener((ConfigChangeListener)new ConfigListener());
    }

    static void setEnumerateRandom(Config conf) {
        enumerateRandom = conf.getBoolean("cg.enumerate_random", false);
        if (enumerateRandom) {
            JPF_gov_nasa_jpf_jvm_Verify.init((Config)conf);
        }
    }

    public static void $clinit____V(MJIEnv env, int rcls) {
    }

    static long nextSeed(long seed) {
        return seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
    }

    static int next(long seed, int bits) {
        return (int)(seed >>> 48 - bits);
    }

    static int next(MJIEnv env, int objref, int bits) {
        int atomicLongRef = env.getReferenceField(objref, "seed");
        long old = env.getLongField(atomicLongRef, "value");
        long next = old * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        env.setLongField(atomicLongRef, "value", next);
        return (int)(next >>> 48 - bits);
    }

    static long getSeed(MJIEnv env, int objref) {
        int atomicLongRef = env.getReferenceField(objref, "seed");
        return env.getLongField(atomicLongRef, "value");
    }

    static void setSeed(MJIEnv env, int objref, long seed) {
        int atomicLongRef = env.getReferenceField(objref, "seed");
        env.setLongField(atomicLongRef, "value", seed);
    }

    public static int nextInt____I(MJIEnv env, int objref) {
        int r = 0;
        if (!enumerateRandom) {
            r = JPF_java_util_Random.next(env, objref, 32);
        }
        return r;
    }

    public static double nextDouble____D(MJIEnv env, int objref) {
        double r = 0.0;
        if (!enumerateRandom) {
            r = (double)(((long)JPF_java_util_Random.next(env, objref, 26) << 27) + (long)JPF_java_util_Random.next(env, objref, 27)) / 9.007199254740992E15;
        }
        return r;
    }

    public static double nextGaussian____D(MJIEnv env, int objref) {
        double r = 0.0;
        if (!enumerateRandom) {
            if (env.getBooleanField(objref, "haveNextNextGaussian")) {
                env.setBooleanField(objref, "haveNextNextGaussian", false);
                r = env.getDoubleField(objref, "nextNextGaussian");
            } else {
                double b;
                double c;
                double a;
                do {
                    a = 2.0 * JPF_java_util_Random.nextDouble____D(env, objref) - 1.0;
                    b = 2.0 * JPF_java_util_Random.nextDouble____D(env, objref) - 1.0;
                    c = a * a + b * b;
                } while (a >= 1.0 || c == 0.0);
                r = StrictMath.sqrt(-2.0 * StrictMath.log(c) / c);
                env.setDoubleField(objref, "nextNextGaussian", r * b);
                env.setBooleanField(objref, "haveNextNextGaussian", true);
                r *= a;
            }
        }
        return r;
    }

    public static int nextInt__I__I(MJIEnv env, int objref, int n) {
        int v;
        int bits;
        if (enumerateRandom) {
            return JPF_gov_nasa_jpf_jvm_Verify.getInt__II__I((MJIEnv)env, (int)-1, (int)0, (int)(n - 1));
        }
        long seed = JPF_java_util_Random.getSeed(env, objref);
        if ((n & -n) == n) {
            seed = JPF_java_util_Random.nextSeed(seed);
            JPF_java_util_Random.setSeed(env, objref, seed);
            return (int)((long)n * (long)JPF_java_util_Random.next(seed, 31) >> 31);
        }
        while ((bits = JPF_java_util_Random.next(seed = JPF_java_util_Random.nextSeed(seed), 31)) - (v = bits % n) + (n - 1) < 0) {
        }
        JPF_java_util_Random.setSeed(env, objref, seed);
        return v;
    }

    public static boolean nextBoolean____Z(MJIEnv env, int objref) {
        if (enumerateRandom) {
            return JPF_gov_nasa_jpf_jvm_Verify.getBoolean____Z((MJIEnv)env, (int)-1);
        }
        long seed = JPF_java_util_Random.getSeed(env, objref);
        seed = JPF_java_util_Random.nextSeed(seed);
        JPF_java_util_Random.setSeed(env, objref, seed);
        return JPF_java_util_Random.next(seed, 1) != 0;
    }

    static class ConfigListener
    implements ConfigChangeListener {
        ConfigListener() {
        }

        public void propertyChanged(Config conf, String key, String oldValue, String newValue) {
            if ("cg.enumerate_random".equals(key)) {
                JPF_java_util_Random.setEnumerateRandom(conf);
            }
        }
    }
}

