/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.AnnotationInfo;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ClinitRequired;
import gov.nasa.jpf.jvm.DoubleFieldInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.FloatFieldInfo;
import gov.nasa.jpf.jvm.IntegerFieldInfo;
import gov.nasa.jpf.jvm.JPF_java_lang_Class;
import gov.nasa.jpf.jvm.LongFieldInfo;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.ReferenceFieldInfo;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import java.lang.reflect.Modifier;

public class JPF_java_lang_reflect_Field {
    static final int NREG = 64;
    static FieldInfo[] registered;
    static int nRegistered;

    public static void init(Config conf) {
        registered = new FieldInfo[64];
        nRegistered = 0;
    }

    static int registerFieldInfo(FieldInfo fi) {
        int idx;
        for (idx = 0; idx < nRegistered; ++idx) {
            if (registered[idx] != fi) continue;
            return idx;
        }
        if (idx == registered.length) {
            FieldInfo[] newReg = new FieldInfo[registered.length + 64];
            System.arraycopy(registered, 0, newReg, 0, registered.length);
            registered = newReg;
        }
        JPF_java_lang_reflect_Field.registered[idx] = fi;
        ++nRegistered;
        return idx;
    }

    static FieldInfo getRegisteredFieldInfo(int idx) {
        return registered[idx];
    }

    public static int getType____Ljava_lang_Class_2(MJIEnv env, int objRef) {
        ThreadInfo ti = env.getThreadInfo();
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        ClassInfo ci = fi.getTypeClassInfo();
        if (!ci.isInitialized() && ci.loadAndInitialize(ti, ti.getPC()) > 0) {
            env.repeatInvocation();
        }
        return ci.getClassObjectRef();
    }

    public static int getModifiers____I(MJIEnv env, int objRef) {
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        return fi.getModifiers();
    }

    static int getIntField(MJIEnv env, int objRef, int fobjRef, Class<?> fiType, String type) {
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        Object ei = fobjRef == -1 ? fi.getClassInfo().getStaticElementInfo() : env.getElementInfo(fobjRef);
        if (ei == null) {
            env.throwException("java.lang.NullPointerException");
            return 0;
        }
        if (!fiType.isInstance(fi)) {
            env.throwException("java.lang.IllegalArgumentException", "field type incompatible with " + type);
            return 0;
        }
        int val = ei.getIntField(fi);
        return val;
    }

    static long getLongField(MJIEnv env, int objRef, int fobjRef, Class<?> fiType, String type) {
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        Object ei = fobjRef == -1 ? fi.getClassInfo().getStaticElementInfo() : env.getElementInfo(fobjRef);
        if (ei == null) {
            env.throwException("java.lang.NullPointerException");
            return 0L;
        }
        if (!fiType.isInstance(fi)) {
            env.throwException("java.lang.IllegalArgumentException", "field type incompatible with " + type);
            return 0L;
        }
        long val = ei.getLongField(fi);
        return val;
    }

    static void setIntField(MJIEnv env, int objRef, int fobjRef, Class<?> fiType, String type, int val) {
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        Object ei = fobjRef == -1 ? fi.getClassInfo().getStaticElementInfo() : env.getElementInfo(fobjRef);
        if (ei == null) {
            env.throwException("java.lang.NullPointerException");
            return;
        }
        if (!fiType.isInstance(fi)) {
            env.throwException("java.lang.IllegalArgumentException", "field type incompatible with " + type);
            return;
        }
        ei.setIntField(fi, val);
    }

    static void setLongField(MJIEnv env, int objRef, int fobjRef, Class<?> fiType, String type, long val) {
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        Object ei = fobjRef == -1 ? fi.getClassInfo().getStaticElementInfo() : env.getElementInfo(fobjRef);
        if (ei == null) {
            env.throwException("java.lang.NullPointerException");
            return;
        }
        if (!fiType.isInstance(fi)) {
            env.throwException("java.lang.IllegalArgumentException", "field type incompatible with " + type);
            return;
        }
        ei.setLongField(fi, val);
    }

    public static boolean getBoolean__Ljava_lang_Object_2__Z(MJIEnv env, int objRef, int fobjRef) {
        int v = JPF_java_lang_reflect_Field.getIntField(env, objRef, fobjRef, IntegerFieldInfo.class, "boolean");
        return v != 0;
    }

    public static byte getByte__Ljava_lang_Object_2__B(MJIEnv env, int objRef, int fobjRef) {
        int v = JPF_java_lang_reflect_Field.getIntField(env, objRef, fobjRef, IntegerFieldInfo.class, "byte");
        return (byte)v;
    }

    public static char getChar__Ljava_lang_Object_2__C(MJIEnv env, int objRef, int fobjRef) {
        int v = JPF_java_lang_reflect_Field.getIntField(env, objRef, fobjRef, IntegerFieldInfo.class, "char");
        return (char)v;
    }

    public static short getShort__Ljava_lang_Object_2__S(MJIEnv env, int objRef, int fobjRef) {
        int v = JPF_java_lang_reflect_Field.getIntField(env, objRef, fobjRef, IntegerFieldInfo.class, "short");
        return (short)v;
    }

    public static int getInt__Ljava_lang_Object_2__I(MJIEnv env, int objRef, int fobjRef) {
        return JPF_java_lang_reflect_Field.getIntField(env, objRef, fobjRef, IntegerFieldInfo.class, "int");
    }

    public static long getLong__Ljava_lang_Object_2__J(MJIEnv env, int objRef, int fobjRef) {
        return JPF_java_lang_reflect_Field.getLongField(env, objRef, fobjRef, LongFieldInfo.class, "long");
    }

    public static float getFloat__Ljava_lang_Object_2__F(MJIEnv env, int objRef, int fobjRef) {
        int v = JPF_java_lang_reflect_Field.getIntField(env, objRef, fobjRef, FloatFieldInfo.class, "float");
        return Types.intToFloat((int)v);
    }

    public static double getDouble__Ljava_lang_Object_2__D(MJIEnv env, int objRef, int fobjRef) {
        long v = JPF_java_lang_reflect_Field.getLongField(env, objRef, fobjRef, DoubleFieldInfo.class, "double");
        return Types.longToDouble((long)v);
    }

    public static int getAnnotation__Ljava_lang_Class_2__Ljava_lang_annotation_Annotation_2(MJIEnv env, int objRef, int annotationClsRef) {
        ClassInfo aci;
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        AnnotationInfo ai = fi.getAnnotation((aci = JPF_java_lang_Class.getReferredClassInfo(env, annotationClsRef)).getName());
        if (ai != null) {
            ClassInfo aciProxy = ClassInfo.getAnnotationProxy((ClassInfo)aci);
            aciProxy.loadAndInitialize(env.getThreadInfo());
            try {
                return env.newAnnotationProxy(aciProxy, ai);
            }
            catch (ClinitRequired x) {
                env.handleClinitRequest(x.getRequiredClassInfo());
                return -1;
            }
        }
        return -1;
    }

    public static int getAnnotations_____3Ljava_lang_annotation_Annotation_2(MJIEnv env, int objRef) {
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        AnnotationInfo[] ai = fi.getAnnotations();
        try {
            return env.newAnnotationProxies(ai);
        }
        catch (ClinitRequired x) {
            env.handleClinitRequest(x.getRequiredClassInfo());
            return -1;
        }
    }

    public static void setBoolean__Ljava_lang_Object_2Z__V(MJIEnv env, int objRef, int fobjRef, boolean val) {
        JPF_java_lang_reflect_Field.setIntField(env, objRef, fobjRef, IntegerFieldInfo.class, "boolean", val ? 1 : 0);
    }

    public static void setByte__Ljava_lang_Object_2B__V(MJIEnv env, int objRef, int fobjRef, byte val) {
        JPF_java_lang_reflect_Field.setIntField(env, objRef, fobjRef, IntegerFieldInfo.class, "byte", val);
    }

    public static void setChar__Ljava_lang_Object_2C__V(MJIEnv env, int objRef, int fobjRef, char val) {
        JPF_java_lang_reflect_Field.setIntField(env, objRef, fobjRef, IntegerFieldInfo.class, "char", val);
    }

    public static void setShort__Ljava_lang_Object_2S__V(MJIEnv env, int objRef, int fobjRef, short val) {
        JPF_java_lang_reflect_Field.setIntField(env, objRef, fobjRef, IntegerFieldInfo.class, "short", val);
    }

    public static void setInt__Ljava_lang_Object_2I__V(MJIEnv env, int objRef, int fobjRef, int val) {
        JPF_java_lang_reflect_Field.setIntField(env, objRef, fobjRef, IntegerFieldInfo.class, "int", val);
    }

    public static void setLong__Ljava_lang_Object_2J__V(MJIEnv env, int objRef, int fobjRef, long val) {
        JPF_java_lang_reflect_Field.setLongField(env, objRef, fobjRef, LongFieldInfo.class, "long", val);
    }

    public static void setFloat__Ljava_lang_Object_2F__V(MJIEnv env, int objRef, int fobjRef, float val) {
        JPF_java_lang_reflect_Field.setIntField(env, objRef, fobjRef, FloatFieldInfo.class, "float", Types.floatToInt((float)val));
    }

    public static void setDouble__Ljava_lang_Object_2D__V(MJIEnv env, int objRef, int fobjRef, double val) {
        JPF_java_lang_reflect_Field.setLongField(env, objRef, fobjRef, DoubleFieldInfo.class, "double", Types.doubleToLong((double)val));
    }

    public static int get__Ljava_lang_Object_2__Ljava_lang_Object_2(MJIEnv env, int objRef, int fobjRef) {
        ElementInfo ei;
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        if (fi.isStatic()) {
            ClassInfo ci = fi.getClassInfo();
            ei = ci.getStaticElementInfo();
        } else {
            ei = env.getElementInfo(fobjRef);
        }
        if (ei == null) {
            env.throwException("java.lang.NullPointerException");
            return 0;
        }
        if (!(fi instanceof ReferenceFieldInfo)) {
            if (fi instanceof DoubleFieldInfo) {
                double d = ei.getDoubleField(fi);
                return env.newDouble(d);
            }
            if (fi instanceof FloatFieldInfo) {
                float f = ei.getFloatField(fi);
                return env.newFloat(f);
            }
            if (fi instanceof LongFieldInfo) {
                long l = ei.getLongField(fi);
                return env.newLong(l);
            }
            if (fi instanceof IntegerFieldInfo) {
                int i = ei.getIntField(fi);
                String cls = fi.getType();
                if (cls.equals("int")) {
                    return env.newInteger(i);
                }
                if (cls.equals("boolean")) {
                    return env.newBoolean(i != 0);
                }
                if (cls.equals("byte")) {
                    return env.newByte((byte)i);
                }
                if (cls.equals("short")) {
                    return env.newShort((short)i);
                }
                if (cls.equals("char")) {
                    return env.newCharacter((char)i);
                }
            }
        } else {
            int ref = ei.getIntField(fi);
            return ref;
        }
        env.throwException("java.lang.IllegalArgumentException", "unknown field type");
        return -1;
    }

    public static int getDeclaringClass____Ljava_lang_Class_2(MJIEnv env, int objref) {
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objref);
        ClassInfo ci = fi.getClassInfo();
        return ci.getClassObjectRef();
    }

    public static boolean isSynthetic____Z(MJIEnv env, int objref) {
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objref);
        String fn = fi.getName();
        return fn.startsWith("this$") || fn.startsWith("val$");
    }

    public static int getName____Ljava_lang_String_2(MJIEnv env, int objRef) {
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        int nameRef = env.getReferenceField(objRef, "name");
        if (nameRef == -1) {
            nameRef = env.newString(fi.getName());
            env.setReferenceField(objRef, "name", nameRef);
        }
        return nameRef;
    }

    static FieldInfo getFieldInfo(MJIEnv env, int objRef) {
        int fidx = env.getIntField(objRef, "regIdx");
        assert (fidx >= 0 || fidx < nRegistered) : "illegal FieldInfo request: " + fidx + ", " + nRegistered;
        return registered[fidx];
    }

    public static void set__Ljava_lang_Object_2Ljava_lang_Object_2__V(MJIEnv env, int objRef, int fobjRef, int val) {
        FieldInfo fi = JPF_java_lang_reflect_Field.getFieldInfo(env, objRef);
        int modifiers = fi.getModifiers();
        if (fobjRef == -1 && !Modifier.isStatic(modifiers)) {
            env.throwException("java.lang.NullPointerException");
            return;
        }
        if (Modifier.isFinal(modifiers)) {
            env.throwException("java.lang.IllegalAccessException", "field " + fi.getName() + " is final");
            return;
        }
        ClassInfo ci = fi.getClassInfo();
        ClassInfo cio = env.getClassInfo(fobjRef);
        if (!fi.isStatic() && !cio.isInstanceOf(ci)) {
            env.throwException("java.lang.IllegalArgumentException", fi.getType() + "field " + fi.getName() + " does not belong to this object");
            return;
        }
        if (!JPF_java_lang_reflect_Field.setValue(env, fi, fobjRef, val)) {
            env.throwException("java.lang.IllegalArgumentException", "Can not set " + fi.getType() + " field " + fi.getFullName() + " to " + (-1 != val ? env.getClassInfo(val).getName() + " object " : "null"));
        }
    }

    private static boolean setValue(MJIEnv env, FieldInfo fi, int obj, int value) {
        String type;
        ClassInfo valueCI;
        ClassInfo fieldClassInfo = fi.getClassInfo();
        String className = fieldClassInfo.getName();
        String fieldType = fi.getType();
        ClassInfo ti = fi.getTypeClassInfo();
        if (ti.isPrimitive()) {
            if (value == -1) {
                return false;
            }
            String fieldName = "value";
            FieldInfo finfo = env.getElementInfo(value).getFieldInfo("value");
            if (finfo == null) {
                return false;
            }
            if (fieldType.equals("boolean") || fieldType.equals("byte") || fieldType.equals("short") || fieldType.equals("char") || fieldType.equals("int") || fieldType.equals("float")) {
                int val = env.getIntField(value, "value");
                if (fi.isStatic()) {
                    StaticElementInfo ei = fi.getClassInfo().getStaticElementInfo();
                    ei.setIntField(fi, val);
                } else {
                    env.setIntField(obj, fi.getName(), val);
                }
                return true;
            }
            if (fieldType.equals("long") || fieldType.equals("double")) {
                long val = env.getLongField(value, "value");
                if (fi.isStatic()) {
                    StaticElementInfo ei = fi.getClassInfo().getStaticElementInfo();
                    ei.setLongField(fi, val);
                } else {
                    env.setLongField(obj, fi.getName(), val);
                }
                return true;
            }
            return false;
        }
        if (value != -1 && !(valueCI = ClassInfo.getClassInfo((String)Types.getTypeName((String)(type = env.getTypeName(value))))).isInstanceOf(ti)) {
            return false;
        }
        if (fi.isStatic()) {
            env.setStaticReferenceField(className, fi.getName(), value);
        } else {
            env.setReferenceField(obj, fi.getName(), value);
        }
        return true;
    }
}

