/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.ThreadInfo;
import java.io.PrintWriter;
import java.io.StringWriter;

public class JPF_java_lang_Throwable {
    public static int createStackTrace_____3Ljava_lang_StackTraceElement_2(MJIEnv env, int objref) {
        int aref = env.getReferenceField(objref, "snapshot");
        int[] snap = env.getIntArrayObject(aref);
        return env.getThreadInfo().createStackTraceElements(snap);
    }

    public static int fillInStackTrace____Ljava_lang_Throwable_2(MJIEnv env, int objref) {
        ThreadInfo ti = env.getThreadInfo();
        int[] snap = ti.getSnapshot(objref);
        int aref = env.newIntArray(snap);
        env.setReferenceField(objref, "snapshot", aref);
        return objref;
    }

    public static void printStackTrace____V(MJIEnv env, int objRef) {
        env.getThreadInfo().printStackTrace(objRef);
    }

    public static int getStackTraceAsString____Ljava_lang_String_2(MJIEnv env, int objRef) {
        ThreadInfo ti = env.getThreadInfo();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ti.printStackTrace(pw, objRef);
        String stackTrace = sw.toString();
        pw.close();
        return env.newString(stackTrace);
    }

    public static int toString____Ljava_lang_String_2(MJIEnv env, int objRef) {
        ClassInfo ci = env.getClassInfo(objRef);
        int msgRef = env.getReferenceField(objRef, "detailMessage");
        String s = ci.getName();
        if (msgRef != -1) {
            s = s + ": " + env.getStringObject(msgRef);
        }
        return env.newString(s);
    }
}

