/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.MJIEnv;

public class JPF_java_lang_String {
    public static int intern____Ljava_lang_String_2(MJIEnv env, int robj) {
        DynamicArea da = env.getDynamicArea();
        ElementInfo sei = da.get(robj);
        for (int i = 0; i < robj; ++i) {
            ElementInfo ei = da.get(i);
            if (ei == null || !ei.equals((Object)sei)) continue;
            return i;
        }
        return robj;
    }

    public static boolean equals__Ljava_lang_Object_2__Z(MJIEnv env, int objRef, int argRef) {
        if (argRef == -1) {
            return false;
        }
        DynamicArea da = env.getDynamicArea();
        ElementInfo s1 = da.get(objRef);
        ElementInfo s2 = da.get(argRef);
        if (!env.isInstanceOf(argRef, "java.lang.String")) {
            return false;
        }
        Fields f1 = ((DynamicElementInfo)da.get(s1.getReferenceField("value"))).getFields();
        int o1 = s1.getIntField("offset");
        int l1 = s1.getIntField("count");
        Fields f2 = ((DynamicElementInfo)da.get(s2.getReferenceField("value"))).getFields();
        int o2 = s2.getIntField("offset");
        int l2 = s2.getIntField("count");
        if (l1 != l2) {
            return false;
        }
        return f1.isEqual(f2, o1, l1, o2);
    }

    public static int toCharArray_____3C(MJIEnv env, int objref) {
        int vref = env.getReferenceField(objref, "value");
        int off = env.getIntField(objref, "offset");
        int len = env.getIntField(objref, "count");
        int cref = env.newCharArray(len);
        int i = 0;
        int j = off;
        while (i < len) {
            env.setCharArrayElement(cref, i, env.getCharArrayElement(vref, j));
            ++i;
            ++j;
        }
        return cref;
    }

    public static int indexOf__I__I(MJIEnv env, int objref, int c) {
        int vref = env.getReferenceField(objref, "value");
        int off = env.getIntField(objref, "offset");
        int len = env.getIntField(objref, "count");
        int i = 0;
        int j = off;
        while (i < len) {
            if (env.getCharArrayElement(vref, j) == c) {
                return i;
            }
            ++i;
            ++j;
        }
        return -1;
    }

    public static int hashCode____I(MJIEnv env, int objref) {
        int h = env.getIntField(objref, "hash");
        if (h == 0) {
            int vref = env.getReferenceField(objref, "value");
            int off = env.getIntField(objref, "offset");
            int len = env.getIntField(objref, "count");
            ElementInfo ei = env.getElementInfo(vref);
            int[] values = ei.getFields().getValues();
            for (int i = 0; i < len; ++i) {
                h = 31 * h + (char)values[off++];
            }
            env.setIntField(objref, "hash", h);
        }
        return h;
    }

    public static boolean matches__Ljava_lang_String_2__Z(MJIEnv env, int objRef, int regexRef) {
        String s = env.getStringObject(objRef);
        String r = env.getStringObject(regexRef);
        return s.matches(r);
    }

    public static int format__Ljava_lang_String_2_3Ljava_lang_Object_2__Ljava_lang_String_2(MJIEnv env, int clsObjRef, int fmtRef, int argRef) {
        return env.newString(env.format(fmtRef, argRef));
    }

    public static int getBytes__Ljava_lang_String_2___3B(MJIEnv env, int ObjRef, int str) {
        String string = env.getStringObject(str);
        byte[] b = string.getBytes();
        return env.newByteArray(b);
    }

    public static int split__Ljava_lang_String_2___3Ljava_lang_String_2(MJIEnv env, int clsObjRef, int strRef) {
        String s = env.getStringObject(strRef);
        String obj = env.getStringObject(clsObjRef);
        String[] result = obj.split(s);
        return env.newStringArray(result);
    }
}

