/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.AnnotationInfo;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ClinitRequired;
import gov.nasa.jpf.jvm.DirectCallStackFrame;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.JPF_java_lang_reflect_Constructor;
import gov.nasa.jpf.jvm.JPF_java_lang_reflect_Field;
import gov.nasa.jpf.jvm.JPF_java_lang_reflect_Method;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import java.util.ArrayList;
import java.util.Set;

public class JPF_java_lang_Class {
    public static void init(Config conf) {
        JPF_java_lang_reflect_Method.init(conf);
        JPF_java_lang_reflect_Constructor.init(conf);
    }

    public static boolean isArray____Z(MJIEnv env, int robj) {
        return JPF_java_lang_Class.getReferredClassInfo(env, robj).isArray();
    }

    public static int getComponentType____Ljava_lang_Class_2(MJIEnv env, int robj) {
        if (JPF_java_lang_Class.isArray____Z(env, robj)) {
            ClassInfo ci;
            ThreadInfo ti = env.getThreadInfo();
            Instruction insn = ti.getPC();
            if (insn.requiresClinitCalls(ti, ci = JPF_java_lang_Class.getReferredClassInfo(env, robj).getComponentClassInfo())) {
                env.repeatInvocation();
                return -1;
            }
            return ci.getClassObjectRef();
        }
        return -1;
    }

    public static boolean isInstance__Ljava_lang_Object_2__Z(MJIEnv env, int robj, int r1) {
        ElementInfo sei = env.getClassElementInfo(robj);
        ClassInfo ci = sei.getClassInfo();
        ClassInfo ciOther = env.getClassInfo(r1);
        return ciOther.isInstanceOf(ci.getName());
    }

    public static boolean isInterface____Z(MJIEnv env, int robj) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, robj);
        return ci.isInterface();
    }

    public static boolean isAssignableFrom__Ljava_lang_Class_2__Z(MJIEnv env, int rcls, int r1) {
        ElementInfo sei1 = env.getClassElementInfo(rcls);
        ClassInfo ci1 = sei1.getClassInfo();
        ElementInfo sei2 = env.getClassElementInfo(r1);
        ClassInfo ci2 = sei2.getClassInfo();
        return ci2.isInstanceOf(ci1.getName());
    }

    public static int getAnnotations_____3Ljava_lang_annotation_Annotation_2(MJIEnv env, int robj) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, robj);
        AnnotationInfo[] ai = ci.getAnnotations();
        try {
            return env.newAnnotationProxies(ai);
        }
        catch (ClinitRequired x) {
            env.handleClinitRequest(x.getRequiredClassInfo());
            return -1;
        }
    }

    public static int getAnnotation__Ljava_lang_Class_2__Ljava_lang_annotation_Annotation_2(MJIEnv env, int robj, int annoClsRef) {
        ClassInfo aci;
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, robj);
        AnnotationInfo ai = ci.getAnnotation((aci = JPF_java_lang_Class.getReferredClassInfo(env, annoClsRef)).getName());
        if (ai != null) {
            ClassInfo aciProxy = ClassInfo.getAnnotationProxy((ClassInfo)aci);
            aciProxy.loadAndInitialize(env.getThreadInfo());
            try {
                return env.newAnnotationProxy(aciProxy, ai);
            }
            catch (ClinitRequired x) {
                env.handleClinitRequest(x.getRequiredClassInfo());
                return -1;
            }
        }
        return -1;
    }

    public static int getPrimitiveClass__Ljava_lang_String_2__Ljava_lang_Class_2(MJIEnv env, int rcls, int stringRef) {
        String clsName = env.getStringObject(stringRef);
        StaticArea sa = env.getStaticArea();
        StaticElementInfo ei = sa.get(clsName);
        int cref = ei.getClassObjectRef();
        env.setBooleanField(cref, "isPrimitive", true);
        return cref;
    }

    public static boolean desiredAssertionStatus____Z(MJIEnv env, int robj) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, robj);
        return ci.areAssertionsEnabled();
    }

    public static int forName__Ljava_lang_String_2__Ljava_lang_Class_2(MJIEnv env, int rcls, int stringRef) {
        ThreadInfo ti = env.getThreadInfo();
        Instruction insn = ti.getPC();
        String clsName = env.getStringObject(stringRef);
        ClassInfo ci = ClassInfo.getClassInfo((String)clsName);
        if (ci == null) {
            env.throwException("java.lang.ClassNotFoundException", clsName);
            return -1;
        }
        if (insn.requiresClinitCalls(ti, ci)) {
            env.repeatInvocation();
            return -1;
        }
        StaticElementInfo ei = env.getStaticArea().get(clsName);
        int ref = ei.getClassObjectRef();
        return ref;
    }

    public static int newInstance____Ljava_lang_Object_2(MJIEnv env, int robj) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, robj);
        ThreadInfo ti = env.getThreadInfo();
        Instruction insn = ti.getPC();
        int objRef = -1;
        if (!ti.isResumedInstruction(insn)) {
            objRef = env.getDynamicArea().newObject(ci, ti);
            MethodInfo mi = ci.getMethod("<init>()V", true);
            if (mi != null) {
                MethodInfo stub = mi.createDirectCallStub("[init]");
                DirectCallStackFrame frame = new DirectCallStackFrame(stub, insn);
                frame.push(objRef, true);
                frame.dup();
                ti.pushFrame((StackFrame)frame);
                env.repeatInvocation();
                return -1;
            }
        } else {
            objRef = ti.getReturnedDirectCall().pop();
        }
        return objRef;
    }

    public static int getSuperclass____Ljava_lang_Class_2(MJIEnv env, int robj) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, robj);
        ClassInfo sci = ci.getSuperClass();
        if (sci != null) {
            return sci.getClassObjectRef();
        }
        return -1;
    }

    public static int getClassLoader____Ljava_lang_ClassLoader_2(MJIEnv env, int objref) {
        int clRef = env.getStaticReferenceField("java.lang.ClassLoader", "systemClassLoader");
        return clRef;
    }

    static int getMethod(MJIEnv env, int clsRef, String mname, int argTypesRef, boolean isRecursiveLookup) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, clsRef);
        StringBuffer sb = new StringBuffer(mname);
        sb.append('(');
        int nParams = argTypesRef != -1 ? env.getArrayLength(argTypesRef) : 0;
        for (int i = 0; i < nParams; ++i) {
            String tname;
            int cRef = env.getReferenceArrayElement(argTypesRef, i);
            ClassInfo cit = JPF_java_lang_Class.getReferredClassInfo(env, cRef);
            String tcode = tname = cit.getName();
            tcode = Types.getTypeCode((String)tcode, (boolean)false);
            sb.append(tcode);
        }
        sb.append(')');
        String fullMthName = sb.toString();
        MethodInfo mi = ci.getReflectionMethod(fullMthName, isRecursiveLookup);
        if (mi == null) {
            env.throwException("java.lang.NoSuchMethodException", ci.getName() + '.' + fullMthName);
            return -1;
        }
        return JPF_java_lang_Class.createMethodObject(env, mi);
    }

    static int createMethodObject(MJIEnv env, MethodInfo mi) {
        if (mi.isCtor()) {
            return JPF_java_lang_reflect_Constructor.createConstructorObject(env, mi);
        }
        return JPF_java_lang_reflect_Method.createMethodObject(env, mi);
    }

    public static int getDeclaredMethod__Ljava_lang_String_2_3Ljava_lang_Class_2__Ljava_lang_reflect_Method_2(MJIEnv env, int clsRef, int nameRef, int argTypesRef) {
        String mname = env.getStringObject(nameRef);
        return JPF_java_lang_Class.getMethod(env, clsRef, mname, argTypesRef, false);
    }

    public static int getDeclaredConstructor___3Ljava_lang_Class_2__Ljava_lang_reflect_Constructor_2(MJIEnv env, int clsRef, int argTypesRef) {
        int ctorRef = JPF_java_lang_Class.getMethod(env, clsRef, "<init>", argTypesRef, false);
        return ctorRef;
    }

    public static int getMethod__Ljava_lang_String_2_3Ljava_lang_Class_2__Ljava_lang_reflect_Method_2(MJIEnv env, int clsRef, int nameRef, int argTypesRef) {
        try {
            String mname = env.getStringObject(nameRef);
            return JPF_java_lang_Class.getMethod(env, clsRef, mname, argTypesRef, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(0);
            return -1;
        }
    }

    public static int getMethods_____3Ljava_lang_reflect_Method_2(MJIEnv env, int objref) {
        ClassInfo ciMdc = JPF_java_lang_Class.getReferredClassInfo(env, objref);
        if (!ciMdc.isPrimitive()) {
            ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
            for (ClassInfo ci = ciMdc; ci != null; ci = ci.getSuperClass()) {
                for (MethodInfo mi : ci.getDeclaredMethodInfos()) {
                    if (!mi.isPublic() || mi.getName().charAt(0) == '<') continue;
                    methodInfos.add(mi);
                }
            }
            if (ciMdc.isAbstract()) {
                for (String ifcName : ciMdc.getAllInterfaces()) {
                    ClassInfo ifc = ClassInfo.getClassInfo((String)ifcName);
                    for (MethodInfo mi : ifc.getDeclaredMethodInfos()) {
                        MethodInfo match = null;
                        String mname = mi.getUniqueName();
                        for (int i = 0; i < methodInfos.size(); ++i) {
                            MethodInfo m = (MethodInfo)methodInfos.get(i);
                            if (!m.getUniqueName().equals(mname)) continue;
                            match = m;
                            break;
                        }
                        if (match != null) continue;
                        methodInfos.add(mi);
                    }
                }
            }
            int n = methodInfos.size();
            int aref = env.newObjectArray("Ljava/lang/reflect/Method;", n);
            for (int i = 0; i < n; ++i) {
                int mref = JPF_java_lang_Class.createMethodObject(env, (MethodInfo)methodInfos.get(i));
                env.setReferenceArrayElement(aref, i, mref);
            }
            return aref;
        }
        return env.newObjectArray("Ljava/lang/reflect/Method;", 0);
    }

    public static int getDeclaredMethods_____3Ljava_lang_reflect_Method_2(MJIEnv env, int objref) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, objref);
        MethodInfo[] methodInfos = ci.getDeclaredMethodInfos();
        int nMth = methodInfos.length;
        for (int i = 0; i < methodInfos.length; ++i) {
            if (methodInfos[i].getName().charAt(0) != '<') continue;
            methodInfos[i] = null;
            --nMth;
        }
        int aref = env.newObjectArray("Ljava/lang/reflect/Method;", nMth);
        int j = 0;
        for (int i = 0; i < methodInfos.length; ++i) {
            if (methodInfos[i] == null) continue;
            int mref = JPF_java_lang_Class.createMethodObject(env, methodInfos[i]);
            env.setReferenceArrayElement(aref, j++, mref);
        }
        return aref;
    }

    static int getConstructors(MJIEnv env, int objref, boolean publicOnly) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, objref);
        ArrayList<MethodInfo> ctors = new ArrayList<MethodInfo>();
        for (MethodInfo mi : ci.getDeclaredMethodInfos()) {
            if (!mi.getName().equals("<init>") || publicOnly && !mi.isPublic()) continue;
            ctors.add(mi);
        }
        int nCtors = ctors.size();
        int aref = env.newObjectArray("Ljava/lang/reflect/Constructor;", nCtors);
        for (int i = 0; i < nCtors; ++i) {
            env.setReferenceArrayElement(aref, i, JPF_java_lang_Class.createMethodObject(env, (MethodInfo)ctors.get(i)));
        }
        return aref;
    }

    public static int getConstructors_____3Ljava_lang_reflect_Constructor_2(MJIEnv env, int objref) {
        return JPF_java_lang_Class.getConstructors(env, objref, true);
    }

    public static int getDeclaredConstructors_____3Ljava_lang_reflect_Constructor_2(MJIEnv env, int objref) {
        return JPF_java_lang_Class.getConstructors(env, objref, false);
    }

    public static int getConstructor___3Ljava_lang_Class_2__Ljava_lang_reflect_Constructor_2(MJIEnv env, int clsRef, int argTypesRef) {
        return JPF_java_lang_Class.getMethod(env, clsRef, "<init>", argTypesRef, false);
    }

    public static int getDeclaredFields_____3Ljava_lang_reflect_Field_2(MJIEnv env, int objRef) {
        ElementInfo ei;
        int eidx;
        int regIdx;
        FieldInfo fi;
        int i;
        ClassInfo fci;
        ThreadInfo ti = env.getThreadInfo();
        Instruction insn = ti.getPC();
        if (insn.requiresClinitCalls(ti, fci = ClassInfo.getClassInfo((String)"java.lang.reflect.Field"))) {
            env.repeatInvocation();
            return -1;
        }
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, objRef);
        int nInstance = ci.getNumberOfDeclaredInstanceFields();
        int nStatic = ci.getNumberOfStaticFields();
        int aref = env.newObjectArray("Ljava/lang/reflect/Field;", nInstance + nStatic);
        int j = 0;
        for (i = 0; i < nStatic; ++i) {
            fi = ci.getStaticField(i);
            regIdx = JPF_java_lang_reflect_Field.registerFieldInfo(fi);
            eidx = env.newObject(fci);
            ei = env.getElementInfo(eidx);
            ei.setIntField("regIdx", regIdx);
            env.setReferenceArrayElement(aref, j++, eidx);
        }
        for (i = 0; i < nInstance; ++i) {
            fi = ci.getDeclaredInstanceField(i);
            regIdx = JPF_java_lang_reflect_Field.registerFieldInfo(fi);
            eidx = env.newObject(fci);
            ei = env.getElementInfo(eidx);
            ei.setIntField("regIdx", regIdx);
            env.setReferenceArrayElement(aref, j++, eidx);
        }
        return aref;
    }

    static int getField(MJIEnv env, int clsRef, int nameRef, boolean isRecursiveLookup) {
        ClassInfo fci;
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, clsRef);
        String fname = env.getStringObject(nameRef);
        FieldInfo fi = null;
        if (isRecursiveLookup) {
            fi = ci.getInstanceField(fname);
            if (fi == null) {
                fi = ci.getStaticField(fname);
            }
        } else {
            fi = ci.getDeclaredInstanceField(fname);
            if (fi == null) {
                fi = ci.getDeclaredStaticField(fname);
            }
        }
        if (fi == null) {
            env.throwException("java.lang.NoSuchFieldException", ci.getName() + '.' + fname);
            return -1;
        }
        ThreadInfo ti = env.getThreadInfo();
        Instruction insn = ti.getPC();
        if (insn.requiresClinitCalls(ti, fci = ClassInfo.getClassInfo((String)"java.lang.reflect.Field"))) {
            env.repeatInvocation();
            return -1;
        }
        int regIdx = JPF_java_lang_reflect_Field.registerFieldInfo(fi);
        int eidx = env.newObject(fci);
        ElementInfo ei = env.getElementInfo(eidx);
        ei.setIntField("regIdx", regIdx);
        return eidx;
    }

    public static int getDeclaredField__Ljava_lang_String_2__Ljava_lang_reflect_Field_2(MJIEnv env, int clsRef, int nameRef) {
        return JPF_java_lang_Class.getField(env, clsRef, nameRef, false);
    }

    public static int getField__Ljava_lang_String_2__Ljava_lang_reflect_Field_2(MJIEnv env, int clsRef, int nameRef) {
        return JPF_java_lang_Class.getField(env, clsRef, nameRef, true);
    }

    public static int getModifiers____I(MJIEnv env, int clsRef) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, clsRef);
        return ci.getModifiers();
    }

    public static int getEnumConstants(MJIEnv env, int clsRef) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, clsRef);
        if (ci.getSuperClass().getName().equals("java.lang.Enum")) {
            ArrayList<FieldInfo> list = new ArrayList<FieldInfo>();
            String cName = ci.getName();
            for (FieldInfo fi : ci.getDeclaredStaticFields()) {
                if (!fi.isFinal() || !cName.equals(fi.getType())) continue;
                list.add(fi);
            }
            int aRef = env.newObjectArray(cName, list.size());
            StaticElementInfo sei = ci.getStaticElementInfo();
            int i = 0;
            for (FieldInfo fi : list) {
                env.setReferenceArrayElement(aRef, i++, sei.getReferenceField(fi));
            }
            return aRef;
        }
        return -1;
    }

    static ClassInfo getReferredClassInfo(MJIEnv env, int robj) {
        return env.getReferredClassInfo(robj);
    }

    public static int getInterfaces_____3Ljava_lang_Class_2(MJIEnv env, int clsRef) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, clsRef);
        int aref = -1;
        ThreadInfo ti = env.getThreadInfo();
        Set ifcNames = ci.getInterfaces();
        aref = env.newObjectArray("Ljava/lang/Class;", ifcNames.size());
        int i = 0;
        for (String ifc : ifcNames) {
            ClassInfo ici = ClassInfo.getClassInfo((String)ifc);
            if (!ici.isInitialized() && ici.loadAndInitialize(ti, ti.getPC()) > 0) {
                env.repeatInvocation();
                return -1;
            }
            env.setReferenceArrayElement(aref, i++, ici.getClassObjectRef());
        }
        return aref;
    }
}

