/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import java.util.HashMap;

public class JPF_java_io_RandomAccessFile {
    static HashMap<Integer, Integer> File2DataMap = new HashMap();
    private static final int INT_SIZE = 4;
    private static final String data_root = "data_root";
    private static final String current_position = "currentPosition";
    private static final String current_length = "currentLength";
    private static final String CHUNK_SIZE = "CHUNK_SIZE";
    private static final String chunk_index = "chunk_index";
    private static final String next = "next";
    private static final String data = "data";
    private static final String EOFException = "java.io.EOFException";
    private static final String RandomAccessFile = "java.io.RandomAccessFile";
    private static final String DataRepresentation = "java.io.RandomAccessFile$DataRepresentation";

    private static int getMapping(MJIEnv env, int this_ptr) {
        int fn_ptr = env.getReferenceField(this_ptr, "filename");
        Integer o = File2DataMap.get(new Integer(fn_ptr));
        if (o == null) {
            return this_ptr;
        }
        return o;
    }

    public static void setDataMap(MJIEnv env, int this_ptr) {
        int fn_ptr = env.getReferenceField(this_ptr, "filename");
        if (!File2DataMap.containsKey(new Integer(fn_ptr))) {
            File2DataMap.put(new Integer(fn_ptr), new Integer(this_ptr));
        }
    }

    static ClassInfo getDataRepresentationClassInfo(MJIEnv env) {
        ClassInfo ci;
        ThreadInfo ti = env.getThreadInfo();
        Instruction insn = ti.getPC();
        if (insn.requiresClinitCalls(ti, ci = ClassInfo.getClassInfo((String)DataRepresentation))) {
            return null;
        }
        return ci;
    }

    public static void writeByte__I__V(MJIEnv env, int this_ptr, int data) {
        long current_posn = env.getLongField(this_ptr, current_position);
        long current_len = env.getLongField(this_ptr, current_length);
        int chunk_size = env.getStaticIntField(RandomAccessFile, CHUNK_SIZE);
        int chunk = JPF_java_io_RandomAccessFile.findDataChunk(env, this_ptr, current_posn, chunk_size);
        JPF_java_io_RandomAccessFile.setDataValue(env, chunk, current_posn, (byte)data, chunk_size);
        env.setLongField(this_ptr, current_position, ++current_posn);
        if (current_posn >= current_len) {
            env.setLongField(this_ptr, current_length, current_posn + 1L);
            env.setLongField(JPF_java_io_RandomAccessFile.getMapping(env, this_ptr), current_length, current_posn + 1L);
        }
    }

    public static void write___3BII__V(MJIEnv env, int this_ptr, int data_array, int start, int len) {
        byte[] data_values = env.getByteArrayObject(data_array);
        for (int i = start; i < len; ++i) {
            JPF_java_io_RandomAccessFile.writeByte__I__V(env, this_ptr, data_values[i]);
        }
    }

    public static void setLength__J__V(MJIEnv env, int this_ptr, long len) {
        long current_posn = env.getLongField(this_ptr, current_position);
        long current_len = env.getLongField(this_ptr, current_length);
        if (current_posn >= len && len < current_len) {
            env.setLongField(this_ptr, current_position, len);
        }
        env.setLongField(this_ptr, current_length, len);
        env.setLongField(JPF_java_io_RandomAccessFile.getMapping(env, this_ptr), current_length, current_posn + 1L);
    }

    public static int read___3BII__I(MJIEnv env, int this_ptr, int data_array, int start, int len) {
        int i = 0;
        long current_len = env.getLongField(this_ptr, current_length);
        for (long current_posn = env.getLongField(this_ptr, current_position); i < len && current_posn < current_len; ++i, ++current_posn) {
            env.setByteArrayElement(data_array, start + i, JPF_java_io_RandomAccessFile.readByte____B(env, this_ptr));
        }
        if (i == 0) {
            return -1;
        }
        return i;
    }

    public static byte readByte____B(MJIEnv env, int this_ptr) {
        long current_posn = env.getLongField(this_ptr, current_position);
        long current_len = env.getLongField(this_ptr, current_length);
        int chunk_size = env.getStaticIntField(RandomAccessFile, CHUNK_SIZE);
        if (current_posn >= current_len) {
            env.throwException(EOFException);
        }
        int chunk = JPF_java_io_RandomAccessFile.findDataChunk(env, this_ptr, current_posn, chunk_size);
        byte result = JPF_java_io_RandomAccessFile.getDataValue(env, chunk, current_posn, chunk_size);
        env.setLongField(this_ptr, current_position, current_posn + 1L);
        return result;
    }

    private static int findDataChunk(MJIEnv env, int this_ptr, long position, int chunk_size) {
        ClassInfo dataRep = JPF_java_io_RandomAccessFile.getDataRepresentationClassInfo(env);
        if (dataRep == null) {
            env.repeatInvocation();
            return 0;
        }
        this_ptr = JPF_java_io_RandomAccessFile.getMapping(env, this_ptr);
        int prev_obj = -1;
        int cur_obj = env.getReferenceField(this_ptr, data_root);
        long chunk_idx = position / (long)chunk_size;
        while (cur_obj != -1 && env.getLongField(cur_obj, chunk_index) < chunk_idx) {
            prev_obj = cur_obj;
            cur_obj = env.getReferenceField(cur_obj, next);
        }
        if (cur_obj != -1 && env.getLongField(cur_obj, chunk_index) == chunk_idx) {
            return cur_obj;
        }
        int result = env.newObject(dataRep);
        int int_array = env.newIntArray(chunk_size / 4);
        env.setReferenceField(result, data, int_array);
        env.setLongField(result, chunk_index, chunk_idx);
        env.setReferenceField(result, next, cur_obj);
        if (prev_obj == -1) {
            env.setReferenceField(this_ptr, data_root, result);
        } else {
            env.setReferenceField(prev_obj, next, result);
        }
        return result;
    }

    private static void setDataValue(MJIEnv env, int chunk_obj, long position, byte data_value, int chunk_size) {
        int offset = (int)(position % (long)chunk_size);
        int index = offset / 4;
        int bit_shift = 8 * (offset % 4);
        int int_array = env.getReferenceField(chunk_obj, data);
        int old_value = env.getIntArrayElement(int_array, index);
        env.setIntArrayElement(int_array, index, old_value & ~(255 << bit_shift) | data_value << bit_shift);
    }

    private static byte getDataValue(MJIEnv env, int chunk_obj, long position, int chunk_size) {
        int offset = (int)(position % (long)chunk_size);
        int index = offset / 4;
        int bit_shift = 8 * (offset % 4);
        int int_array = env.getReferenceField(chunk_obj, data);
        return (byte)(env.getIntArrayElement(int_array, index) >> bit_shift);
    }
}

