/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFListener;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JPF_java_lang_reflect_Method;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;

public class JPF_gov_nasa_jpf_test_MemoryGoal {
    static Listener listener;

    public static boolean preCheck__Lgov_nasa_jpf_test_TestContext_2Ljava_lang_reflect_Method_2__Z(MJIEnv env, int objRef, int testContextRef, int methodRef) {
        MethodInfo mi = JPF_java_lang_reflect_Method.getMethodInfo(env, methodRef);
        listener = new Listener(mi);
        env.addListener((JPFListener)listener);
        return true;
    }

    public static boolean postCheck__Lgov_nasa_jpf_test_TestContext_2Ljava_lang_reflect_Method_2Ljava_lang_Object_2Ljava_lang_Throwable_2__Z(MJIEnv env, int objRef, int testContextRef, int methdRef, int resultRef, int exRef) {
        long nMax = env.getLongField(objRef, "maxGrowth");
        Listener l = listener;
        env.removeListener((JPFListener)l);
        listener = null;
        return l.totalAllocBytes() <= nMax;
    }

    static class Listener
    extends ListenerAdapter {
        MethodInfo mi;
        boolean active;
        long nAllocBytes;
        long nFreeBytes;
        long nAlloc;
        long nFree;

        Listener(MethodInfo mi) {
            this.mi = mi;
        }

        public void objectCreated(JVM vm) {
            if (this.active) {
                ElementInfo ei = vm.getLastElementInfo();
                ++this.nAlloc;
                this.nAllocBytes += (long)ei.getHeapSize();
            }
        }

        public void objectReleased(JVM vm) {
            if (this.active) {
                ElementInfo ei = vm.getLastElementInfo();
                ++this.nFree;
                this.nFreeBytes += (long)ei.getHeapSize();
            }
        }

        public void instructionExecuted(JVM vm) {
            Instruction insn = vm.getLastInstruction();
            if (!this.active) {
                if (insn.getMethodInfo() == this.mi) {
                    this.active = true;
                }
            } else if (insn instanceof ReturnInstruction && insn.getMethodInfo() == this.mi) {
                this.active = false;
            }
        }

        long totalAllocBytes() {
            return this.nAllocBytes - this.nFreeBytes;
        }
    }
}

