/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.MJIEnv;

public class JPF_gov_nasa_jpf_AnnotationProxyBase {
    public static int annotationType____Ljava_lang_Class_2(MJIEnv env, int objref) {
        ClassInfo ciProxy = env.getClassInfo(objref);
        String proxyName = ciProxy.getName();
        String annotation = proxyName.substring(0, proxyName.length() - 6);
        ClassInfo ci = ClassInfo.getClassInfo((String)annotation);
        return ci.getClassObjectRef();
    }

    public static int toString____Ljava_lang_String_2(MJIEnv env, int objref) {
        StringBuffer sb = new StringBuffer();
        ClassInfo ci = env.getClassInfo(objref);
        String cname = ci.getName();
        int idx = cname.lastIndexOf(36);
        sb.append('@');
        sb.append(cname.substring(0, idx));
        FieldInfo[] fields = ci.getDeclaredInstanceFields();
        if (fields.length > 0) {
            sb.append('(');
            for (int i = 0; i < fields.length; ++i) {
                ClassInfo eci;
                String fn = fields[i].getName();
                String ft = fields[i].getType();
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(fn);
                sb.append('=');
                if (ft.equals("int")) {
                    sb.append(env.getIntField(objref, fn));
                    continue;
                }
                if (ft.equals("long")) {
                    sb.append(env.getLongField(objref, fn));
                    continue;
                }
                if (ft.equals("double")) {
                    sb.append(env.getDoubleField(objref, fn));
                    continue;
                }
                if (ft.equals("boolean")) {
                    sb.append(env.getBooleanField(objref, fn));
                    continue;
                }
                if (ft.equals("java.lang.String")) {
                    sb.append(env.getStringObject(env.getReferenceField(objref, fn)));
                    continue;
                }
                if (ft.equals("java.lang.Class")) {
                    int cref = env.getReferenceField(objref, fn);
                    if (cref != -1) {
                        int nref = env.getReferenceField(cref, "name");
                        String cn = env.getStringObject(nref);
                        sb.append("class ");
                        sb.append(cn);
                        continue;
                    }
                    sb.append("class ?");
                    continue;
                }
                if (ft.endsWith("[]")) {
                    int ar = env.getReferenceField(objref, fn);
                    int n = env.getArrayLength(ar);
                    sb.append('[');
                    if (ft.equals("java.lang.String[]")) {
                        for (int j = 0; j < n; ++j) {
                            if (j > 0) {
                                sb.append(',');
                            }
                            sb.append(env.getStringObject(env.getReferenceArrayElement(ar, j)));
                        }
                    } else if (ft.equals("int[]")) {
                        for (int j = 0; j < n; ++j) {
                            if (j > 0) {
                                sb.append(',');
                            }
                            sb.append(env.getIntArrayElement(ar, j));
                        }
                    } else if (ft.equals("long[]")) {
                        for (int j = 0; j < n; ++j) {
                            if (j > 0) {
                                sb.append(',');
                            }
                            sb.append(env.getLongArrayElement(ar, j));
                        }
                    } else if (ft.equals("double[]")) {
                        for (int j = 0; j < n; ++j) {
                            if (j > 0) {
                                sb.append(',');
                            }
                            sb.append(env.getDoubleArrayElement(ar, j));
                        }
                    } else if (ft.equals("boolean[]")) {
                        for (int j = 0; j < n; ++j) {
                            if (j > 0) {
                                sb.append(',');
                            }
                            sb.append(env.getBooleanArrayElement(ar, j));
                        }
                    } else if (ft.equals("java.lang.Class[]")) {
                        for (int j = 0; j < n; ++j) {
                            int cref;
                            if (j > 0) {
                                sb.append(',');
                            }
                            if ((cref = env.getReferenceArrayElement(ar, j)) != -1) {
                                int nref = env.getReferenceField(cref, "name");
                                String cn = env.getStringObject(nref);
                                sb.append("class ");
                                sb.append(cn);
                                continue;
                            }
                            sb.append("class ?");
                        }
                    }
                    sb.append(']');
                    continue;
                }
                int eref = env.getReferenceField(objref, fn);
                if (eref == -1 || !(eci = env.getClassInfo(eref)).isEnum()) continue;
                int nref = env.getReferenceField(eref, "name");
                String en = env.getStringObject(nref);
                sb.append(eci.getName());
                sb.append('.');
                sb.append(en);
            }
            sb.append(')');
        }
        return env.newString(sb.toString());
    }
}

