/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.utils;

import java.util.HashMap;
import java.util.Map;
import org.ow2.dsrg.fm.tbpjava.checker.VariablesEvaluation;

public final class HashMapWithHashCode<Key extends Integer, Value>
extends HashMap<Key, Value>
implements Comparable<HashMapWithHashCode<? extends Key, ? extends Value>> {
    private static final boolean INTERNAL_CHECKS = false;
    private static final long serialVersionUID = 20100607001L;
    private static final int INITIAL_HASH_VALUE = -1442796886;
    private static final int KEY_OFFSET = 2;
    private int hashCode = -1442796886;
    private final VariablesEvaluation varEval;

    public HashMapWithHashCode(VariablesEvaluation varEval) {
        this.varEval = varEval;
        this.hashCode = this.calculateHashCode();
    }

    public HashMapWithHashCode(HashMapWithHashCode<? extends Key, ? extends Value> source) {
        super(source);
        assert (source != null);
        this.varEval = source.varEval;
        this.hashCode = source.hashCode;
    }

    public HashMapWithHashCode(VariablesEvaluation varEval, HashMapWithHashCode<? extends Key, ? extends Value> m) {
        super(m);
        this.varEval = varEval;
        this.hashCode = this.calculateHashCode();
    }

    public VariablesEvaluation getAssociatedVariablesEvaluation() {
        return this.varEval;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public int calculateHashCode() {
        int result = -1442796886;
        result ^= this.varEval.getChecherHashCode();
        for (Map.Entry entry : this.entrySet()) {
            result ^= ((Integer)entry.getKey() + 2) * entry.getValue().hashCode();
        }
        return result;
    }

    @Override
    public Value put(Key key, Value value) {
        Value oldValue = super.put(key, value);
        if (oldValue != null) {
            this.hashCode ^= ((Integer)key + 2) * oldValue.hashCode();
        }
        this.hashCode ^= ((Integer)key + 2) * value.hashCode();
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> map) {
        throw new RuntimeException("Unsupported operation");
    }

    @Override
    public Value remove(Object key) {
        throw new RuntimeException("Unsupported operation - use typed remove operator instead");
    }

    @Override
    public Value remove(Key key) {
        Object removed = super.remove(key);
        if (removed != null) {
            this.hashCode ^= ((Integer)key + 2) * removed.hashCode();
        }
        return (Value)removed;
    }

    @Override
    public void clear() {
        super.clear();
        this.hashCode = this.calculateHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashMapWithHashCode other = (HashMapWithHashCode)obj;
        if (this.getHashCode() != other.getHashCode()) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        if (this.varEval == null ? other.varEval != null : !this.varEval.equalsValues(other.varEval)) {
            return false;
        }
        for (Map.Entry entry : this.entrySet()) {
            Object otherVal = other.get(entry.getKey());
            if (!(entry.getValue() == null ? otherVal != null : !entry.getValue().equals(otherVal))) continue;
            return false;
        }
        return true;
    }

    public void DEBUG_checkConsistency() {
        int caclHashCode = this.calculateHashCode();
        if (caclHashCode != this.hashCode) {
            System.err.println(HashMapWithHashCode.class.getName() + " - Internal CHECK failed !!!!");
            throw new RuntimeException(HashMapWithHashCode.class.getName() + " - Internal CHECK failed !!!!");
        }
    }

    @Override
    public int compareTo(HashMapWithHashCode<? extends Key, ? extends Value> o) {
        if (o == null) {
            return 1;
        }
        if (this.hashCode() > o.hashCode()) {
            return 1;
        }
        if (this.hashCode() < o.hashCode()) {
            return -1;
        }
        return 0;
    }
}

