/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Configuration {
    private static final boolean DEBUG = false;
    private String ComponentName = null;
    private List<String> ComponentImplementationClasses = null;
    private Map<String, String> ComponentProvidedInterfaces = new HashMap<String, String>();
    private Map<String, String> ComponentRequiredInterfaces = new HashMap<String, String>();
    private int ComponentReentrancyLimit = 2;
    private String EnvValueSets = null;
    private String EnvTargetDir = "." + File.separator;
    private String EnvProtocol = null;
    private boolean EnvGenerate = true;
    private RequiredInterfaceSettingMethod EnvRequierdItfcSettingMethod = RequiredInterfaceSettingMethod.SETTERS;
    private ProvidedInterfaceAccessMethod EnvProvidedItfsAccesMethod = ProvidedInterfaceAccessMethod.COMPONENT_CLASSES;
    private boolean ConfigurationError = false;
    private boolean setFlagComponentName = false;
    private boolean setFlagComponentImplementationClass = false;
    private boolean setFlagComponentProvidedInterfaces = false;
    private boolean setFlagComponentRequiredInterfaces = false;
    private boolean setFlagComponentReentrancyLimit = false;
    private boolean setFlagEnvValueSets = false;
    private boolean setFlagEnvTargetDir = false;
    private boolean setFlagEnvProtocol = false;
    private boolean setFlagEnvRequierdItfcSettingMethod = false;
    private boolean setFlagEnvProvidedItfsAccesMethod = false;
    private boolean setFlagEnvGenerate = false;
    private static final String SeparatorIDValue = "=";
    private static final String SeparatorMultipleValues = ";";
    private static final String SeparatorPairValue = "-";
    private static final String SeparatorComment = "#";
    private static final String IDComponentName = "component.name";
    private static final String IDComponentImplementationClass = "component.implclass";
    private static final String IDComponentProvidedInterfaces = "component.provitfs";
    private static final String IDComponentRequiredInterfaces = "component.reqitfs";
    private static final String IDComponentReentrancyLimit = "component.reentrancylimit";
    private static final String IDEnvValueSets = "env.valuesets";
    private static final String IDEnvTargetDir = "env.targetdir";
    private static final String IDEnvProtocol = "env.protocol";
    private static final String IDEnvRequierdItfcSettingMethod = "env.reqitfs_setmethod";
    private static final String IDEnvProvidedItfsAccesMethod = "env.provitfs_acces_method";
    private static final String IDEnvGenerate = "env.generate";
    private static final String RISM_SETTERS = "setters";
    private static final String RISM_SOFA2_CLIENT = "sofa2";
    private static final String RISM_FRACTAL = "fractal";
    private static final String RISM_FIELDS = "fields";
    private static final String PIAM_COMPONENT_CLASS = "commponnent";
    private static final String PIAM_SEPARATE_CLASSES = "separate";
    private static final String PIAM_SEPARATE_IMPLEMENTATION_CLASSES = "impl_separate";
    private static final String[] BOOLEAN_VALUES_TRUE = new String[]{"true", "yes", "ano"};
    private static final String[] BOOLEAN_VALUES_FALSE = new String[]{"false", "no", "ne"};
    private PrintStream out = System.out;

    public Configuration(String[] argv, String fileName, PrintStream out) {
        this.out = out;
        if (fileName != null) {
            try {
                String str;
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                int line = 1;
                while ((str = in.readLine()) != null) {
                    this.processConfigurationLine(line, str);
                    ++line;
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("Configuration file not found.");
            }
            catch (IOException e) {
                out.println("Error reading configuration file.");
                out.println(e.getMessage());
                e.printStackTrace(out);
            }
        }
        int line = -1;
        for (String str : argv) {
            this.processConfigurationLine(line, str);
            --line;
        }
        this.checkMandatoryOptions();
    }

    private void processConfigurationLine(int line, String str) {
        StringBuffer lineBuff = new StringBuffer(str);
        while (lineBuff.length() > 0 && this.isWhiteSpace(lineBuff.charAt(0))) {
            lineBuff.deleteCharAt(0);
        }
        if (lineBuff.length() == 0 || lineBuff.indexOf(SeparatorComment) == 0) {
            return;
        }
        int positionIDValSeparator = lineBuff.indexOf(SeparatorIDValue);
        if (positionIDValSeparator == -1) {
            if (line > 0) {
                this.out.println("Invalid configuration file format at line " + Integer.toString(line));
            } else {
                this.out.println("Invalid configuration format at command line parameter" + Integer.toString(-line));
            }
            this.ConfigurationError = true;
            return;
        }
        String identifierPart = lineBuff.substring(0, positionIDValSeparator);
        String valuePart = lineBuff.substring(positionIDValSeparator + 1);
        if (identifierPart.equals(IDComponentName)) {
            this.ComponentName = valuePart;
            this.setFlagComponentName = true;
        } else if (identifierPart.equals(IDComponentImplementationClass)) {
            String[] separatedPairs = valuePart.split(SeparatorMultipleValues);
            this.ComponentImplementationClasses = Arrays.asList(separatedPairs);
            this.setFlagComponentImplementationClass = true;
        } else if (identifierPart.equals(IDComponentProvidedInterfaces)) {
            if (!valuePart.isEmpty()) {
                String[] separatedPairs;
                for (String pairValue : separatedPairs = valuePart.split(SeparatorMultipleValues)) {
                    if (this.parsePairValue(line, pairValue, this.ComponentProvidedInterfaces)) break;
                }
            }
            this.setFlagComponentProvidedInterfaces = true;
        } else if (identifierPart.equals(IDComponentRequiredInterfaces)) {
            if (!valuePart.isEmpty()) {
                String[] separatedPairs;
                for (String pairValue : separatedPairs = valuePart.split(SeparatorMultipleValues)) {
                    if (this.parsePairValue(line, pairValue, this.ComponentRequiredInterfaces)) break;
                }
            }
            this.setFlagComponentRequiredInterfaces = true;
        } else if (identifierPart.equals(IDComponentReentrancyLimit)) {
            int parsedValue = -1;
            try {
                parsedValue = Integer.parseInt(valuePart);
            }
            catch (NumberFormatException e) {
                this.ConfigurationError = true;
                this.out.println("Error number expected as parameter for entry component.reentrancylimit");
                return;
            }
            if (parsedValue <= 0) {
                this.ConfigurationError = true;
                this.out.println("Error invalid range of value (component.reentrancylimit). Use positive number.");
                return;
            }
            this.ComponentReentrancyLimit = parsedValue;
            this.setFlagComponentReentrancyLimit = true;
        } else if (identifierPart.equals(IDEnvValueSets)) {
            this.EnvValueSets = valuePart;
            this.setFlagEnvValueSets = true;
        } else if (identifierPart.equals(IDEnvTargetDir)) {
            File targetDir;
            String tmpEnvTargetDir = valuePart;
            if (tmpEnvTargetDir.lastIndexOf(File.separator) != tmpEnvTargetDir.length() - 1) {
                tmpEnvTargetDir = tmpEnvTargetDir + File.separator;
            }
            if ((targetDir = new File(tmpEnvTargetDir)).isFile()) {
                this.out.println("Error can't create target directory : " + targetDir);
                this.ConfigurationError = true;
                return;
            }
            try {
                targetDir.mkdirs();
            }
            catch (Exception e) {
                this.out.println("Error while creating target dir : " + this.EnvTargetDir + "..." + targetDir.getAbsolutePath());
                this.out.println(e);
                this.ConfigurationError = true;
                return;
            }
            this.EnvTargetDir = tmpEnvTargetDir;
            this.setFlagEnvTargetDir = true;
        } else if (identifierPart.equals(IDEnvProtocol)) {
            String tmpEnvProcol = valuePart;
            if (!Configuration.checkFileExists(tmpEnvProcol)) {
                this.out.println("Error - not existing protocol file : " + tmpEnvProcol);
                this.ConfigurationError = true;
                return;
            }
            this.EnvProtocol = tmpEnvProcol;
            this.setFlagEnvProtocol = true;
        } else if (identifierPart.equals(IDEnvRequierdItfcSettingMethod)) {
            this.EnvRequierdItfcSettingMethod = this.parseEnumRequiertItfsSettingMethod(valuePart);
            this.setFlagEnvRequierdItfcSettingMethod = true;
        } else if (identifierPart.equals(IDEnvProvidedItfsAccesMethod)) {
            this.EnvProvidedItfsAccesMethod = Configuration.parseEnumProvidedInterfaceAccessMethod(valuePart);
            this.setFlagEnvProvidedItfsAccesMethod = true;
        } else if (identifierPart.equals(IDEnvGenerate)) {
            this.EnvGenerate = Configuration.parseBoolean(valuePart, this.EnvGenerate);
            this.setFlagEnvGenerate = true;
        }
    }

    private static boolean checkFileExists(String fileName) {
        File testedFile = new File(fileName);
        return testedFile.isFile() && testedFile.canRead();
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    private boolean parsePairValue(int line, String pair, Map<String, String> resultMap) {
        int positionPairValueSeparator = pair.indexOf(SeparatorPairValue);
        if (positionPairValueSeparator == -1) {
            if (line > 0) {
                this.out.println("Error at line " + Integer.toString(line) + " -  invalid value part format (pair: " + pair + ") ");
            } else {
                this.out.println("Error at " + Integer.toString(-line) + " command line parameter - invalid value part format (pair: " + pair + ") ");
            }
            this.ConfigurationError = true;
            return true;
        }
        String firstPairEntry = pair.substring(0, positionPairValueSeparator);
        String secondPairEntry = pair.substring(positionPairValueSeparator + 1);
        resultMap.put(firstPairEntry, secondPairEntry);
        return false;
    }

    private RequiredInterfaceSettingMethod parseEnumRequiertItfsSettingMethod(String value) {
        if (value.equalsIgnoreCase(RISM_SETTERS)) {
            return RequiredInterfaceSettingMethod.SETTERS;
        }
        if (value.equalsIgnoreCase(RISM_SOFA2_CLIENT)) {
            return RequiredInterfaceSettingMethod.SOFA2_CLIENT;
        }
        if (value.equalsIgnoreCase(RISM_FRACTAL)) {
            return RequiredInterfaceSettingMethod.FRACTAL;
        }
        if (value.equalsIgnoreCase(RISM_FIELDS)) {
            return RequiredInterfaceSettingMethod.FIELDS;
        }
        return RequiredInterfaceSettingMethod.SETTERS;
    }

    private static String stringRequiertItfsSettingMethod(RequiredInterfaceSettingMethod value) {
        switch (value) {
            case SETTERS: {
                return RISM_SETTERS;
            }
            case SOFA2_CLIENT: {
                return RISM_SOFA2_CLIENT;
            }
            case FRACTAL: {
                return RISM_FRACTAL;
            }
            case FIELDS: {
                return RISM_FIELDS;
            }
        }
        return "Unknown RequiredInterfaceSettingMethod value";
    }

    private static ProvidedInterfaceAccessMethod parseEnumProvidedInterfaceAccessMethod(String value) {
        if (value.equalsIgnoreCase(PIAM_COMPONENT_CLASS)) {
            return ProvidedInterfaceAccessMethod.COMPONENT_CLASSES;
        }
        if (value.equalsIgnoreCase(PIAM_SEPARATE_CLASSES)) {
            return ProvidedInterfaceAccessMethod.SEPARATE_CLASSES;
        }
        if (value.equalsIgnoreCase(PIAM_SEPARATE_IMPLEMENTATION_CLASSES)) {
            return ProvidedInterfaceAccessMethod.SEPARATE_IMPLEMENTATION_CLASSES;
        }
        return ProvidedInterfaceAccessMethod.COMPONENT_CLASSES;
    }

    private static boolean parseBoolean(String value, boolean defaulValue) {
        for (String truePossitive : BOOLEAN_VALUES_TRUE) {
            if (!truePossitive.equals(value)) continue;
            return true;
        }
        for (String truePossitive : BOOLEAN_VALUES_FALSE) {
            if (!truePossitive.equals(value)) continue;
            return false;
        }
        return defaulValue;
    }

    private static String stringProvidedInterfaceAccessMethod(ProvidedInterfaceAccessMethod value) {
        switch (value) {
            case COMPONENT_CLASSES: {
                return PIAM_COMPONENT_CLASS;
            }
            case SEPARATE_CLASSES: {
                return PIAM_SEPARATE_CLASSES;
            }
            case SEPARATE_IMPLEMENTATION_CLASSES: {
                return PIAM_SEPARATE_IMPLEMENTATION_CLASSES;
            }
        }
        return "Unknown ProvidedInterfaceAccessMethod value";
    }

    private void checkMandatoryOptions() {
        if (!this.setFlagComponentName) {
            this.out.println("Error - Mandatory option \"component.name\" not specified by given configuration (both file and command line parameters).");
            this.ConfigurationError = true;
        }
        if (!this.setFlagComponentImplementationClass) {
            this.out.println("Error - Mandatory option \"component.implclass\" not specified by given configuration (both file and command line parameters).");
            this.ConfigurationError = true;
        }
        if (!this.setFlagEnvValueSets) {
            this.out.println("Error - Mandatory option \"env.valuesets\" not specified by given configuration (both file and command line parameters).");
            this.ConfigurationError = true;
        }
        if (!this.setFlagEnvProtocol) {
            this.out.println("Error - Mandatory option \"env.protocol\" not specified by given configuration (both file and command line parameters).");
            this.ConfigurationError = true;
        }
    }

    public String getComponentName() {
        return this.ComponentName;
    }

    public List<String> getComponentImplementationClasses() {
        return this.ComponentImplementationClasses;
    }

    public Map<String, String> getComponentProvidedInterfaces() {
        return this.ComponentProvidedInterfaces;
    }

    public Map<String, String> getComponentRequiredInterfaces() {
        return this.ComponentRequiredInterfaces;
    }

    public int getComponentReentrancyLimit() {
        return this.ComponentReentrancyLimit;
    }

    public String getEnvValueSets() {
        return this.EnvValueSets;
    }

    public String getEnvTargetDir() {
        return this.EnvTargetDir;
    }

    public String getEnvProtocol() {
        return this.EnvProtocol;
    }

    public boolean getEnvGenerate() {
        return this.EnvGenerate;
    }

    public RequiredInterfaceSettingMethod getEnvRequierdItfcSettingMethod() {
        return this.EnvRequierdItfcSettingMethod;
    }

    public ProvidedInterfaceAccessMethod getEnvProvidedItfsAccesMethod() {
        return this.EnvProvidedItfsAccesMethod;
    }

    public boolean isConfigurationError() {
        return this.ConfigurationError;
    }

    public void printConfiguration() {
        this.out.println("component.name=" + this.ComponentName);
        this.out.print("component.implclass=");
        this.printConfigurationEntriesList(this.ComponentImplementationClasses);
        this.out.print("component.provitfs=");
        this.printConfigurationPairs(this.ComponentProvidedInterfaces);
        this.out.print("component.reqitfs=");
        this.printConfigurationPairs(this.ComponentRequiredInterfaces);
        this.out.println("component.reentrancylimit=" + this.ComponentReentrancyLimit);
        this.out.println("env.valuesets=" + this.EnvValueSets);
        this.out.println("env.targetdir=" + this.EnvTargetDir);
        this.out.println("env.protocol=" + this.EnvProtocol);
        this.out.println("env.reqitfs_setmethod=" + Configuration.stringRequiertItfsSettingMethod(this.EnvRequierdItfcSettingMethod));
        this.out.println("env.provitfs_acces_method=" + Configuration.stringProvidedInterfaceAccessMethod(this.EnvProvidedItfsAccesMethod));
        this.out.println("env.generate=" + this.EnvGenerate);
        if (this.ConfigurationError) {
            this.out.println("# Configuration contains errors");
        } else {
            this.out.println("# Configuration doen't contain errors");
        }
    }

    private void printConfigurationEntriesList(List<String> entryList) {
        boolean first = true;
        for (String key : entryList) {
            if (!first) {
                this.out.print(SeparatorMultipleValues);
                first = false;
            }
            this.out.print(key);
        }
        this.out.println();
    }

    private void printConfigurationPairs(Map<String, String> pairMap) {
        Set<String> pairKeySet = pairMap.keySet();
        boolean first = true;
        for (String key : pairKeySet) {
            if (!first) {
                this.out.print(SeparatorMultipleValues);
                first = false;
            }
            this.out.print(key + SeparatorPairValue + pairMap.get(key));
        }
        this.out.println();
    }

    public static void main(String[] args) {
        String configurationFile = args[0];
        String[] overwritingsParameters = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            overwritingsParameters[i - 1] = args[i];
        }
        Configuration envGenConfig = new Configuration(overwritingsParameters, configurationFile, System.out);
        System.out.println("ParsedConfiguration");
        envGenConfig.printConfiguration();
    }

    public static enum ProvidedInterfaceAccessMethod {
        COMPONENT_CLASSES,
        SEPARATE_CLASSES,
        SEPARATE_IMPLEMENTATION_CLASSES;

    }

    public static enum RequiredInterfaceSettingMethod {
        SETTERS,
        SOFA2_CLIENT,
        FRACTAL,
        FIELDS;

    }
}

