/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.utils;

public class CheckerResult {
    public static final String NO_ERROR_FOUND = "No error was found";
    private final String message;
    private final StackTraceElement[] stackTrace;
    private final boolean error;

    protected CheckerResult() {
        this.error = false;
        this.message = NO_ERROR_FOUND;
        this.stackTrace = null;
    }

    protected CheckerResult(boolean error, String message, StackTraceElement[] stackTrace) {
        this.error = error;
        this.message = message;
        this.stackTrace = stackTrace;
    }

    public static CheckerResult createResultNoError() {
        return new CheckerResult();
    }

    public static CheckerResult creaResultErrorMessage(String errorMessage) {
        return new CheckerResult(true, errorMessage, null);
    }

    public static CheckerResult createResultCounterExample(String errorMessage, StackTraceElement[] stackTrace) {
        return new CheckerResult(true, errorMessage, stackTrace);
    }

    public String getMessage() {
        return this.message;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public boolean isError() {
        return this.error;
    }
}

