/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.envgen;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ow2.dsrg.fm.tbpjava.utils.Configuration;
import org.ow2.dsrg.fm.tbpjava.utils.Type2String;
import org.ow2.dsrg.fm.tbplib.TBPNode;
import org.ow2.dsrg.fm.tbplib.parsed.MethodCall;
import org.ow2.dsrg.fm.tbplib.parsed.ParsedComponentSpecification;
import org.ow2.dsrg.fm.tbplib.parsed.TBPLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAccept;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAlternative;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAssignment;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedEmit;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedIf;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeBinaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeLeafNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeNaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeNull;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeSequence;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedImperativeUnaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedMethodDeclaration;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallel;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallelOr;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionBinaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionLeafNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionNaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionNull;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionUnaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedRepetition;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedReturn;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSequence;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSwitch;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSync;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedThreadContainerNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedValue;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedWhile;
import org.ow2.dsrg.fm.tbplib.parsed.TBPUnlimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.parsed.visitor.TBPParsedVisitor;

public class VisitorTypeCheck
implements TBPParsedVisitor<Boolean> {
    private Configuration config;
    private PrintStream out;
    private Set<String> processedProvisionMethods = new HashSet<String>();
    private Set<String> declaredProvidedMethods = new HashSet<String>();
    private Map<String, Class<?>> providedInterface2Class = new HashMap();
    private Map<String, Class<?>> requiredInterface2Class = new HashMap();
    private Set<String> invalidInterfaceNames = new HashSet<String>();
    private Set<String> invalidInterfaceClassNames = new HashSet<String>();
    private Set<String> invalidInterfaceMethodName = new HashSet<String>();
    private Set<String> duplicateInterfaceMethodName = new HashSet<String>();

    public VisitorTypeCheck(Configuration config, PrintStream out) {
        assert (config != null);
        this.config = config;
        this.out = out;
    }

    public boolean completeCheck(ParsedComponentSpecification spec) {
        boolean result = false;
        result |= this.checkInterfaces();
        result |= this.checkSpecification(spec);
        return result |= this.checkCompleteness();
    }

    public boolean checkInterfaces() {
        boolean result = false;
        for (Map.Entry<String, String> iface : this.config.getComponentProvidedInterfaces().entrySet()) {
            result |= this.checkInterface(iface.getKey(), iface.getValue());
        }
        for (Map.Entry<String, String> iface : this.config.getComponentRequiredInterfaces().entrySet()) {
            result |= this.checkInterface(iface.getKey(), iface.getValue());
        }
        return result;
    }

    private boolean checkInterface(String interfaceName, String interfaceClassName) {
        boolean result = false;
        Class<?> interfaceClass = null;
        try {
            interfaceClass = Thread.currentThread().getContextClassLoader().loadClass(Type2String.removeGenerics(interfaceClassName));
            if (interfaceClass == null) {
                throw new ClassNotFoundException();
            }
        }
        catch (ClassNotFoundException e) {
            if (!this.invalidInterfaceClassNames.contains(interfaceClassName)) {
                this.invalidInterfaceClassNames.add(interfaceClassName);
                this.out.println("Error - cannot load class (" + Type2String.removeGenerics(interfaceClassName) + ") where the " + interfaceName + " interface is defined.");
            }
            return true;
        }
        for (Method testedMethod : interfaceClass.getMethods()) {
            String id = interfaceClassName + '.' + testedMethod.getName();
            for (Method otherMethod : interfaceClass.getMethods()) {
                if (!testedMethod.getName().equals(otherMethod.getName()) || testedMethod.equals(otherMethod)) continue;
                if (!this.duplicateInterfaceMethodName.contains(id)) {
                    this.duplicateInterfaceMethodName.add(id);
                    this.out.println("Error - Interface " + interfaceName + " that is defined in class (" + Type2String.removeGenerics(interfaceClassName) + ") contains more methods with same name " + testedMethod.getName() + ". Such interfaces are not supported by TBP.");
                }
                result = true;
            }
        }
        return result;
    }

    public boolean checkCompleteness() {
        return false;
    }

    public boolean checkSpecification(ParsedComponentSpecification spec) {
        assert (spec != null);
        boolean result = false;
        for (TBPParsedProvisionContainerNode node : spec.getProvisions()) {
            result |= ((Boolean)node.visit((TBPParsedVisitor)this)).booleanValue();
        }
        for (TBPParsedProvisionContainerNode node : spec.getReactions()) {
            result |= ((Boolean)node.visit((TBPParsedVisitor)this)).booleanValue();
        }
        for (TBPParsedProvisionContainerNode node : spec.getThreads()) {
            result |= ((Boolean)node.visit((TBPParsedVisitor)this)).booleanValue();
        }
        return result;
    }

    private boolean processChilds(TBPNode node) {
        assert (node != null);
        boolean result = false;
        for (TBPNode child : node.getChildren()) {
            assert (child != null);
            TBPParsedNode parsedChild = (TBPParsedNode)child;
            result |= ((Boolean)parsedChild.visit((TBPParsedVisitor)this)).booleanValue();
        }
        return result;
    }

    private boolean testAccept(String interfaceName, String methodName, providedEvenTypes event, boolean reportError) {
        String interfaceClassName = this.config.getComponentProvidedInterfaces().get(interfaceName);
        if (interfaceClassName == null) {
            if (reportError && !this.invalidInterfaceNames.contains(interfaceName)) {
                this.out.println("Error - unknown provided interface name " + interfaceName);
                this.invalidInterfaceNames.add(interfaceName);
            }
            return true;
        }
        Class<?> interfaceClass = this.providedInterface2Class.get(interfaceClassName);
        if (interfaceClass == null) {
            try {
                interfaceClass = Thread.currentThread().getContextClassLoader().loadClass(Type2String.removeGenerics(interfaceClassName));
            }
            catch (ClassNotFoundException e) {
                if (reportError && !this.invalidInterfaceClassNames.contains(interfaceClassName)) {
                    this.invalidInterfaceClassNames.add(interfaceClassName);
                    this.out.println("Error - cannot load class (" + Type2String.removeGenerics(interfaceClassName) + ") where " + interfaceName + " interface is defined.");
                    this.providedInterface2Class.put(interfaceClassName, null);
                }
                return true;
            }
            this.providedInterface2Class.put(interfaceClassName, interfaceClass);
        }
        Method calledMethod = null;
        for (Method m : interfaceClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            calledMethod = m;
            break;
        }
        if (calledMethod == null) {
            if (reportError && !this.invalidInterfaceMethodName.contains(interfaceClassName + '.' + methodName)) {
                this.invalidInterfaceMethodName.add(interfaceClassName + '.' + methodName);
                this.out.println("Error - provided intergace " + interfaceName + " (" + interfaceClassName + ")  doesn't contain method with name " + methodName + ".");
            }
            return true;
        }
        if (reportError) {
            if (event == providedEvenTypes.PROVIDED_CALL) {
                this.processedProvisionMethods.add(interfaceName + '.' + methodName);
            } else if (event == providedEvenTypes.PROVIDED_DECLARATION) {
                this.declaredProvidedMethods.add(interfaceName + '.' + methodName);
            } else {
                throw new RuntimeException("Unknown enum " + providedEvenTypes.class.getName() + " entry " + (Object)((Object)event));
            }
        }
        return false;
    }

    private boolean testEmit(String interfaceName, String methodName, boolean reportErrors) {
        String interfaceClassName = this.config.getComponentRequiredInterfaces().get(interfaceName);
        if (interfaceClassName == null) {
            if (reportErrors && !this.invalidInterfaceNames.contains(interfaceName)) {
                this.out.println("Error - unknown required interface name " + interfaceName);
                this.invalidInterfaceNames.add(interfaceName);
            }
            return true;
        }
        Class<?> interfaceClass = this.requiredInterface2Class.get(interfaceClassName);
        if (interfaceClass == null) {
            try {
                interfaceClass = Thread.currentThread().getContextClassLoader().loadClass(Type2String.removeGenerics(interfaceClassName));
            }
            catch (ClassNotFoundException e) {
                if (reportErrors && !this.invalidInterfaceClassNames.contains(interfaceClassName)) {
                    this.invalidInterfaceClassNames.add(interfaceClassName);
                    this.out.println("Error - cannot load class (" + Type2String.removeGenerics(interfaceClassName) + ") where required interface " + interfaceName + " is defined.");
                    this.requiredInterface2Class.put(interfaceClassName, null);
                }
                return true;
            }
            this.requiredInterface2Class.put(interfaceClassName, interfaceClass);
        }
        Method calledMethod = null;
        for (Method m : interfaceClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            calledMethod = m;
            break;
        }
        if (calledMethod == null) {
            if (reportErrors && !this.invalidInterfaceMethodName.contains(interfaceClassName + '.' + methodName)) {
                this.invalidInterfaceMethodName.add(interfaceClassName + '.' + methodName);
                this.out.println("Error - provided intergace " + interfaceName + " (" + interfaceClassName + ")  doesn't contain method with name " + methodName + ".");
            }
            return true;
        }
        return false;
    }

    public Boolean visitLimitedReentrancy(TBPLimitedReentrancy node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedAccept(TBPParsedAccept node) {
        return this.testAccept(node.getInterface(), node.getMethod(), providedEvenTypes.PROVIDED_CALL, true);
    }

    public Boolean visitParsedAlternative(TBPParsedAlternative node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedAssignment(TBPParsedAssignment node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedEmit(TBPParsedEmit node) {
        return this.testEmit(node.getInterface(), node.getMethod(), true);
    }

    public Boolean visitParsedIf(TBPParsedIf node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedImperativeBinaryNode(TBPParsedImperativeBinaryNode node) {
        throw new RuntimeException(this.getClass().getSimpleName() + ":visitParsedImperativeBinaryNode(...) - Unexpected behavior: visitor of abstract class called -> some child doesn't override visit method\n\tProblematic child : " + node.getClass().getName());
    }

    public Boolean visitParsedImperativeLeafNode(TBPParsedImperativeLeafNode node) {
        throw new RuntimeException(this.getClass().getSimpleName() + ":visitParsedImperativeLeafNode(...) - Unexpected behavior: this class shoudn't be dirrectly in parse tree, only descendants -> maybe some child doesn't override visit method\n\tProblematic child : " + node.getClass().getName());
    }

    public Boolean visitParsedImperativeNaryNode(TBPParsedImperativeNaryNode node) {
        throw new RuntimeException(this.getClass().getSimpleName() + ":visitParsedImperativeNaryNode(...) - Unexpected behavior: visitor of abstract class called -> some child doesn't override visit method\n\tProblematic child : " + node.getClass().getName());
    }

    public Boolean visitParsedImperativeNull(TBPParsedImperativeNull node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedImperativeSequence(TBPParsedImperativeSequence node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedImperativeUnaryNode(TBPParsedImperativeUnaryNode node) {
        throw new RuntimeException(this.getClass().getSimpleName() + ":visitParsedImperativeUnaryNode(...) - Unexpected behavior: visitor of abstract class called -> some child doesn't override visit method\n\tProblematic child : " + node.getClass().getName());
    }

    public Boolean visitParsedMethodDeclaration(TBPParsedMethodDeclaration node) {
        boolean result = this.processChilds((TBPNode)node);
        if (this.testAccept(node.getInterface(), node.getMethod(), providedEvenTypes.PROVIDED_DECLARATION, false) && !this.testEmit(node.getInterface(), node.getMethod(), false)) {
            return result;
        }
        return result |= this.testAccept(node.getInterface(), node.getMethod(), providedEvenTypes.PROVIDED_DECLARATION, true);
    }

    public Boolean visitParsedNull(TBPParsedProvisionNull node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedParallel(TBPParsedParallel node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedParallelOr(TBPParsedParallelOr node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedProvisionBinaryNode(TBPParsedProvisionBinaryNode node) {
        throw new RuntimeException(this.getClass().getSimpleName() + ":visitParsedProvisionBinaryNode(...) - Unexpected behavior: visitor of abstract class called -> some child doesn't override visit method\n\tProblematic child : " + node.getClass().getName());
    }

    public Boolean visitParsedProvisionContainerNode(TBPParsedProvisionContainerNode node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedProvisionLeafNode(TBPParsedProvisionLeafNode node) {
        throw new RuntimeException(this.getClass().getSimpleName() + ":visitParsedProvisionLeafNode(...) - Unexpected behavior: visitor of abstract class called -> some child doesn't override visit method\n\tProblematic child : " + node.getClass().getName());
    }

    public Boolean visitParsedProvisionNaryNode(TBPParsedProvisionNaryNode node) {
        throw new RuntimeException(this.getClass().getSimpleName() + ":visitParsedProvisionNaryNode(...) - Unexpected behavior: visitor of abstract class called -> some child doesn't override visit method\n\tProblematic child : " + node.getClass().getName());
    }

    public Boolean visitParsedProvisionUnaryNode(TBPParsedProvisionUnaryNode parsedProvisionUnaryNode) {
        throw new RuntimeException(this.getClass().getSimpleName() + ":visitParsedProvisionNaryNode(...) - Unexpected behavior: visitor of abstract class called -> some child doesn't override visit method\n\tProblematic child : " + parsedProvisionUnaryNode.getClass().getName());
    }

    public Boolean visitParsedRepetition(TBPParsedRepetition node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedReturn(TBPParsedReturn node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedSequence(TBPParsedSequence node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedSwitch(TBPParsedSwitch node) {
        boolean result = this.processChilds((TBPNode)node);
        if (node.getValue() != null) {
            result |= ((Boolean)node.getValue().visit((TBPParsedVisitor)this)).booleanValue();
        }
        return result;
    }

    public Boolean visitParsedSync(TBPParsedSync node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedThreadContainerNode(TBPParsedThreadContainerNode node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitParsedValue(TBPParsedValue node) {
        MethodCall mc = node.getMethodCall();
        if (mc != null) {
            return this.testEmit(mc.getInterface(), mc.getMethod(), true);
        }
        return false;
    }

    public Boolean visitParsedWhile(TBPParsedWhile node) {
        return this.processChilds((TBPNode)node);
    }

    public Boolean visitUnlimitedReentrancy(TBPUnlimitedReentrancy node) {
        return this.processChilds((TBPNode)node);
    }

    private static enum providedEvenTypes {
        PROVIDED_CALL,
        PROVIDED_DECLARATION;

    }
}

