/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.envgen;

import gov.nasa.jpf.jvm.Verify;
import java.util.HashMap;
import java.util.Map;

public abstract class EnvValueSets {
    static final boolean USE_GENERIC_TYPE = false;
    private final Map<String, Object> valueSets = new HashMap<String, Object>();
    public static final String TYPE_NAME_BOOLEAN = "Boolean";
    public static final String TYPE_NAME_BYTE = "Byte";
    public static final String TYPE_NAME_SHORT = "Short";
    public static final String TYPE_NAME_INT = "Int";
    public static final String TYPE_NAME_LONG = "Long";
    public static final String TYPE_NAME_CHAR = "Char";
    public static final String TYPE_NAME_FLOAT = "Float";
    public static final String TYPE_NAME_DOUBLE = "Double";
    public static final String TYPE_NAME_STRING = "String";
    public static final boolean IMPLICIT_RETURN_VALUE_BOOLEAN = false;
    public static final byte IMPLICIT_RETURN_VALUE_BYTE = 0;
    public static final short IMPLICIT_RETURN_VALUE_SHORT = 0;
    public static final int IMPLICIT_RETURN_VALUE_INT = 0;
    public static final long IMPLICIT_RETURN_VALUE_LONG = 0L;
    public static final char IMPLICIT_RETURN_VALUE_CHAR = ' ';
    public static final float IMPLICIT_RETURN_VALUE_FLOAT = 0.0f;
    public static final double IMPLICIT_RETURN_VALUE_DOUBLE = 0.0;
    public static final String IMPLICIT_RETURN_VALUE_STRING = "";
    public static final Object IMPLICIT_RETURN_VALUE_OBJECT = null;
    public static final String COMPONENT_CONSTRUCTOR_PARAMETER = "__CONSTRUCTOR__";

    private final Object[] getValueSet(String typeName, String componentName, String javaItfName, String methodName) {
        Object[] objs = (Object[])this.valueSets.get(typeName + ":" + componentName + ":" + javaItfName + ":" + methodName);
        if (objs == null && (objs = (Object[])this.valueSets.get(typeName + ":" + componentName + ":" + javaItfName + ":")) == null && (objs = (Object[])this.valueSets.get(typeName + ":" + componentName + "::")) == null) {
            objs = (Object[])this.valueSets.get(typeName + ":::");
        }
        return objs;
    }

    private final void addValueSet(String typeName, String componentName, String javaItfName, String methodName, Object[] objs) {
        this.valueSets.put(typeName + ":" + componentName + ":" + javaItfName + ":" + methodName, objs);
        this.valueSets.put(typeName + ":" + componentName + ":" + javaItfName + ":", objs);
        this.valueSets.put(typeName + ":" + componentName + "::", objs);
        this.valueSets.put(typeName + ":::", objs);
    }

    public final synchronized boolean getBoolean(String componentName, String javaItfName, String methodName) {
        Object[] objs = this.getValueSet(TYPE_NAME_BOOLEAN, componentName, javaItfName, methodName);
        if (objs == null || objs.length == 0) {
            return false;
        }
        Boolean obj = (Boolean)objs[Verify.random((int)(objs.length - 1))];
        boolean b = obj;
        return b;
    }

    public final synchronized void putBooleanSet(String componentName, String javaItfName, String methodName, boolean[] vals) {
        if (vals == null) {
            return;
        }
        Object[] objs = new Boolean[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            objs[i] = new Boolean(vals[i]);
        }
        this.addValueSet(TYPE_NAME_BOOLEAN, componentName, javaItfName, methodName, objs);
    }

    public final synchronized byte getByte(String componentName, String javaItfName, String methodName) {
        Object[] objs = this.getValueSet(TYPE_NAME_BYTE, componentName, javaItfName, methodName);
        if (objs == null || objs.length == 0) {
            return 0;
        }
        Byte obj = (Byte)objs[Verify.random((int)(objs.length - 1))];
        byte b = obj;
        return b;
    }

    public final synchronized void putByteSet(String componentName, String javaItfName, String methodName, byte[] vals) {
        if (vals == null) {
            return;
        }
        Object[] objs = new Byte[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            objs[i] = new Byte(vals[i]);
        }
        this.addValueSet(TYPE_NAME_BYTE, componentName, javaItfName, methodName, objs);
    }

    public final synchronized short getShort(String componentName, String javaItfName, String methodName) {
        Object[] objs = this.getValueSet(TYPE_NAME_SHORT, componentName, javaItfName, methodName);
        if (objs == null || objs.length == 0) {
            return 0;
        }
        Short obj = (Short)objs[Verify.random((int)(objs.length - 1))];
        short s = obj;
        return s;
    }

    public final synchronized void putShortSet(String componentName, String javaItfName, String methodName, short[] vals) {
        if (vals == null) {
            return;
        }
        Object[] objs = new Short[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            objs[i] = new Short(vals[i]);
        }
        this.addValueSet(TYPE_NAME_SHORT, componentName, javaItfName, methodName, objs);
    }

    public final synchronized int getInt(String componentName, String javaItfName, String methodName) {
        Object[] objs = this.getValueSet(TYPE_NAME_INT, componentName, javaItfName, methodName);
        if (objs == null || objs.length == 0) {
            return 0;
        }
        Integer obj = (Integer)objs[Verify.random((int)(objs.length - 1))];
        int i = obj;
        return i;
    }

    public final synchronized void putIntSet(String componentName, String javaItfName, String methodName, int[] vals) {
        if (vals == null) {
            return;
        }
        Object[] objs = new Integer[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            objs[i] = new Integer(vals[i]);
        }
        this.addValueSet(TYPE_NAME_INT, componentName, javaItfName, methodName, objs);
    }

    public final synchronized long getLong(String componentName, String javaItfName, String methodName) {
        Object[] objs = this.getValueSet(TYPE_NAME_LONG, componentName, javaItfName, methodName);
        if (objs == null || objs.length == 0) {
            return 0L;
        }
        Long obj = (Long)objs[Verify.random((int)(objs.length - 1))];
        long l = obj;
        return l;
    }

    public final synchronized void putLongSet(String componentName, String javaItfName, String methodName, long[] vals) {
        if (vals == null) {
            return;
        }
        Object[] objs = new Long[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            objs[i] = new Long(vals[i]);
        }
        this.addValueSet(TYPE_NAME_LONG, componentName, javaItfName, methodName, objs);
    }

    public final synchronized char getChar(String componentName, String javaItfName, String methodName) {
        Object[] objs = this.getValueSet(TYPE_NAME_CHAR, componentName, javaItfName, methodName);
        if (objs == null || objs.length == 0) {
            return ' ';
        }
        Character obj = (Character)objs[Verify.random((int)(objs.length - 1))];
        char c = obj.charValue();
        return c;
    }

    public final synchronized void putCharSet(String componentName, String javaItfName, String methodName, char[] vals) {
        if (vals == null) {
            return;
        }
        Object[] objs = new Character[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            objs[i] = new Character(vals[i]);
        }
        this.addValueSet(TYPE_NAME_CHAR, componentName, javaItfName, methodName, objs);
    }

    public final synchronized float getFloat(String componentName, String javaItfName, String methodName) {
        Object[] objs = this.getValueSet(TYPE_NAME_FLOAT, componentName, javaItfName, methodName);
        if (objs == null || objs.length == 0) {
            return 0.0f;
        }
        Float obj = (Float)objs[Verify.random((int)(objs.length - 1))];
        float f = obj.floatValue();
        return f;
    }

    public final synchronized void putFloatSet(String componentName, String javaItfName, String methodName, float[] vals) {
        if (vals == null) {
            return;
        }
        Object[] objs = new Float[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            objs[i] = new Float(vals[i]);
        }
        this.addValueSet(TYPE_NAME_FLOAT, componentName, javaItfName, methodName, objs);
    }

    public final synchronized double getDouble(String componentName, String javaItfName, String methodName) {
        Object[] objs = this.getValueSet(TYPE_NAME_DOUBLE, componentName, javaItfName, methodName);
        if (objs == null || objs.length == 0) {
            return 0.0;
        }
        Double obj = (Double)objs[Verify.random((int)(objs.length - 1))];
        double d = obj;
        return d;
    }

    public final synchronized void putDoubleSet(String componentName, String javaItfName, String methodName, double[] vals) {
        if (vals == null) {
            return;
        }
        Object[] objs = new Double[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            objs[i] = new Double(vals[i]);
        }
        this.addValueSet(TYPE_NAME_DOUBLE, componentName, javaItfName, methodName, objs);
    }

    public final synchronized String getString(String componentName, String javaItfName, String methodName) {
        Object[] objs = this.getValueSet(TYPE_NAME_STRING, componentName, javaItfName, methodName);
        if (objs == null || objs.length == 0) {
            return IMPLICIT_RETURN_VALUE_STRING;
        }
        String s = (String)objs[Verify.random((int)(objs.length - 1))];
        return s;
    }

    public final synchronized void putStringSet(String componentName, String javaItfName, String methodName, String[] vals) {
        if (vals == null) {
            return;
        }
        this.addValueSet(TYPE_NAME_STRING, componentName, javaItfName, methodName, vals);
    }

    public final synchronized Object getObject(String typeName, String componentName, String javaItfName, String methodName) {
        Object[] objs = this.getValueSet(typeName, componentName, javaItfName, methodName);
        if (objs == null || objs.length == 0) {
            return IMPLICIT_RETURN_VALUE_OBJECT;
        }
        Object o = objs[Verify.random((int)(objs.length - 1))];
        return o;
    }

    public final synchronized void putObjectSet(String componentName, String javaItfName, String methodName, Object[] vals) {
        if (vals == null || vals.length == 0) {
            return;
        }
        this.putObjectSet(vals[0].getClass().getSimpleName(), componentName, javaItfName, methodName, vals);
    }

    public final synchronized void putObjectSet(String typeName, String componentName, String javaItfName, String methodName, Object[] vals) {
        if (vals == null) {
            return;
        }
        this.addValueSet(typeName, componentName, javaItfName, methodName, vals);
    }
}

