/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.dsrg.fm.tbpjava.checker.TypeDef;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAComponentSpecification;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedVardef;
import org.ow2.dsrg.fm.tbplib.util.Typedef;

public class VariablesMapper {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_CONSTRUCTOR = false;
    private static final boolean DEBUG_SET_VALUE = false;
    private static Integer variableMapperIDsCounter = 0;
    public static final int STATE_ARRAY_OFSET_MAPPER_ID = 0;
    public static final int STATE_ARRAY_OFSET_HASH_CODE = 1;
    public static final int STATE_ARRAY_OFSET_STATE_ID = 2;
    public static final int STATE_ARRAY_OFSET_VARIABLE_START = 3;
    private int variableMapperID;
    private Map<Typedef, TypeDef> type2CheckerType;
    private Map<String, VariableRecord> variables;
    private List<String> variablesIndexes;
    private int stateArraySize;
    private final int[] initialArray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariablesMapper(LTSAComponentSpecification component) {
        assert (component != null);
        Integer n = variableMapperIDsCounter;
        synchronized (n) {
            this.variableMapperID = variableMapperIDsCounter;
            Integer n2 = variableMapperIDsCounter;
            Integer n3 = variableMapperIDsCounter = Integer.valueOf(variableMapperIDsCounter + 1);
        }
        Map varDefs = component.getVardefs();
        int variablesCount = varDefs.size();
        this.stateArraySize = variablesCount + 3;
        this.type2CheckerType = new HashMap<Typedef, TypeDef>(variablesCount + variablesCount / 2);
        for (Typedef type : component.getTypes()) {
            this.type2CheckerType.put(type, new TypeDef(type));
        }
        this.variables = new HashMap<String, VariableRecord>(variablesCount + variablesCount / 2);
        this.variablesIndexes = new ArrayList<String>(variablesCount + 3);
        int firstEmptyArrayIndex = 3;
        for (int i = 0; i < 3; ++i) {
            this.variablesIndexes.add(null);
        }
        for (String variableName : varDefs.keySet()) {
            VariableRecord newVarRecord = new VariableRecord();
            newVarRecord.variableIndex = firstEmptyArrayIndex++;
            Typedef type = ((TBPResolvedVardef)varDefs.get(variableName)).getType();
            newVarRecord.variableType = this.type2CheckerType.get(type);
            this.variables.put(variableName, newVarRecord);
            this.variablesIndexes.add(variableName);
        }
        assert (firstEmptyArrayIndex == this.stateArraySize);
        this.initialArray = this.stateArrayInitalize();
        for (String varName : varDefs.keySet()) {
            String varInitialValue = ((TBPResolvedVardef)varDefs.get(varName)).getInitialValue();
            this.stateArrayInitializeSetValue(this.initialArray, varName, varInitialValue);
        }
    }

    private int[] stateArrayInitalize() {
        int[] result = new int[this.stateArraySize];
        result[0] = this.variableMapperID;
        return result;
    }

    private void stateArrayInitializeSetValue(int[] stateArray, String varName, String varInitialValue) {
        VariableRecord vr = this.variables.get(varName);
        assert (vr != null);
        TypeDef.TypeEntryRecord ter = vr.variableType.getValueRecord(varInitialValue);
        assert (ter != null);
        stateArray[vr.variableIndex] = ter.value;
        stateArray[1] = stateArray[1] ^ ter.xorValue;
    }

    public boolean stateArraySetValue(int[] stateArray, String varName, String varValue) {
        assert (stateArray[0] == this.variableMapperID);
        VariableRecord vr = this.variables.get(varName);
        if (vr == null) {
            return false;
        }
        TypeDef.TypeEntryRecord ter = vr.variableType.getValueRecord(varValue);
        if (ter == null) {
            return false;
        }
        int usedXOR = vr.variableType.getXorValue(stateArray[vr.variableIndex]);
        stateArray[vr.variableIndex] = ter.value;
        stateArray[1] = stateArray[1] ^ usedXOR;
        stateArray[1] = stateArray[1] ^ ter.xorValue;
        return true;
    }

    public String stateArrayGetValue(int[] stateArray, String varName) {
        assert (stateArray[0] == this.variableMapperID);
        VariableRecord vr = this.variables.get(varName);
        if (vr == null) {
            return null;
        }
        return vr.variableType.getEnumName(stateArray[vr.variableIndex]);
    }

    public static boolean stateEquals(int[] state1, int[] state2) {
        if (state1[1] != state2[1]) {
            return false;
        }
        if (state1[0] != state2[0]) {
            return false;
        }
        if (state1 == state2) {
            return true;
        }
        boolean result = true;
        for (int i = 3; i < state1.length; ++i) {
            result &= state1[i] == state2[i];
        }
        return result;
    }

    public int[] getInitialState() {
        return this.initialArray;
    }

    public static final int getStateArrayKey(int[] stateArray) {
        return stateArray[2];
    }

    public static final void setStateArrayNewKey(int[] stateArray, int newID) {
        stateArray[2] = newID;
    }

    public String DEBUG_stateArrayToString(int[] state) {
        if (state == null) {
            return "[null]";
        }
        if (state[0] != this.variableMapperID) {
            return "[invalid state owner]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("hash=" + state[1]);
        sb.append(", stateID=" + state[2]);
        for (String varName : this.variablesIndexes) {
            if (varName == null) continue;
            sb.append(", ");
            sb.append(varName);
            sb.append('=');
            String value = this.stateArrayGetValue(state, varName);
            if (value == null) {
                value = "!!INVALID!!";
            }
            sb.append(value);
        }
        sb.append("]");
        return sb.toString();
    }

    private class VariableRecord {
        public int variableIndex;
        public TypeDef variableType;

        private VariableRecord() {
        }
    }
}

