/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapper;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAComponentSpecification;
import org.ow2.dsrg.fm.tbplib.resolved.ConstantRef;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedVardef;
import org.ow2.dsrg.fm.tbplib.util.Typedef;

public final class VariablesEvaluation
implements Serializable {
    private static final long serialVersionUID = 7526438036848650079L;
    private static final double CONST_MAP_GROWING = 1.5;
    private static final int INITIAL_XOR_VALUE = -252645136;
    private static final Random rnd = new Random();
    private final LTSAComponentSpecification comp;
    private final StatesMapper stateMapper;
    private final Map<String, String> var2value;
    private int xorValuesHash = -252645136;
    private int DEBUG_variableEvaluationID;
    private static int DEBUG_variablesEvaluationIDCounter = 0;
    private final int javaHashCode = rnd.nextInt();

    public VariablesEvaluation(LTSAComponentSpecification comp, StatesMapper stateMapper) {
        assert (comp != null);
        this.comp = comp;
        this.stateMapper = stateMapper;
        this.DEBUG_variableEvaluationID = DEBUG_variablesEvaluationIDCounter++;
        Map initialVars = comp.getVardefs();
        assert (initialVars != null);
        this.var2value = new HashMap<String, String>((int)((double)initialVars.size() * 1.5));
        for (Map.Entry entry : initialVars.entrySet()) {
            String varName = (String)entry.getKey();
            String varValue = ((TBPResolvedVardef)entry.getValue()).getInitialValue();
            assert (varValue != null);
            this.var2value.put(varName, varValue);
            this.xorValuesHash ^= varValue.hashCode();
        }
    }

    protected VariablesEvaluation(VariablesEvaluation source) {
        assert (source != null);
        this.comp = source.comp;
        this.stateMapper = source.stateMapper;
        this.DEBUG_variableEvaluationID = source.DEBUG_variableEvaluationID;
        this.var2value = new HashMap<String, String>(source.var2value);
        this.xorValuesHash = source.xorValuesHash;
    }

    public String getVariableValue(String name) {
        assert (name != null);
        return this.var2value.get(name);
    }

    public ConstantRef getVariableValueReference(String name) {
        assert (name != null);
        String variableValue = this.getVariableValue(name);
        if (variableValue == null) {
            return null;
        }
        Typedef variableType = this.getVariableType(name);
        assert (variableType != null);
        return new ConstantRef(variableValue, variableType);
    }

    public Typedef getVariableType(String name) {
        assert (name != null);
        TBPResolvedVardef variableDef = (TBPResolvedVardef)this.comp.getVardefs().get(name);
        if (variableDef == null) {
            return null;
        }
        return variableDef.getType();
    }

    public VariablesEvaluation setVariableValue(String name, String value) {
        assert (name != null);
        assert (value != null);
        VariablesEvaluation result = new VariablesEvaluation(this);
        result.DEBUG_variableEvaluationID = DEBUG_variablesEvaluationIDCounter++;
        String oldValue = this.var2value.get(name);
        if (oldValue == null) {
            return null;
        }
        result.var2value.put(name, value);
        result.xorValuesHash ^= oldValue.hashCode();
        result.xorValuesHash ^= value.hashCode();
        this.stateMapper.cloneMappings(this, result);
        return result;
    }

    public boolean equalsValues(VariablesEvaluation other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.xorValuesHash != this.xorValuesHash) {
            return false;
        }
        if (other.comp != this.comp) {
            return false;
        }
        for (String name : this.var2value.keySet()) {
            String otherValue;
            String myValue = this.var2value.get(name);
            if (myValue.equals(otherValue = other.var2value.get(name))) continue;
            return false;
        }
        return true;
    }

    public int getChecherHashCode() {
        return this.xorValuesHash;
    }

    public final boolean equals(Object other) {
        return other == this;
    }

    public final int hashCode() {
        return this.javaHashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("ID=" + this.DEBUG_variableEvaluationID);
        sb.append(", hash=" + this.xorValuesHash);
        for (String name : this.var2value.keySet()) {
            sb.append(", ");
            sb.append(name);
            sb.append('=');
            sb.append(this.var2value.get(name));
        }
        sb.append("]");
        return sb.toString();
    }

    public int DEBUG_get_variableEvaluationID() {
        return this.DEBUG_variableEvaluationID;
    }
}

