/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.ow2.dsrg.fm.tbplib.util.Typedef;

public class TypeDef {
    Typedef sourceType;
    private final int entriesCount;
    private final Map<String, TypeEntryRecord> name2valueMapping;
    private final Map<Integer, String> xorValue2Name;
    private final List<String> value2Name;
    private final List<Integer> value2XorValue;

    TypeDef(Typedef sourceType) {
        assert (sourceType != null);
        this.sourceType = sourceType;
        List sourceTypeEnums = sourceType.getEnums();
        this.entriesCount = sourceTypeEnums.size();
        this.name2valueMapping = new HashMap<String, TypeEntryRecord>(this.entriesCount + this.entriesCount / 2);
        this.xorValue2Name = new HashMap<Integer, String>(this.entriesCount + this.entriesCount / 2);
        this.value2Name = new ArrayList<String>(this.entriesCount);
        this.value2XorValue = new ArrayList<Integer>(this.entriesCount);
        int firstEmptyValueIndex = 0;
        Random rnd = new Random();
        for (String name : sourceTypeEnums) {
            TypeEntryRecord ter = new TypeEntryRecord();
            ter.value = firstEmptyValueIndex++;
            ter.xorValue = rnd.nextInt();
            this.name2valueMapping.put(name, ter);
            this.xorValue2Name.put(ter.xorValue, name);
            this.value2Name.add(ter.value, name);
            this.value2XorValue.add(ter.value, ter.xorValue);
        }
    }

    public Typedef getSourceType() {
        return this.sourceType;
    }

    public TypeEntryRecord getValueRecord(String value) {
        return this.name2valueMapping.get(value);
    }

    public int getXorValue(int value) {
        assert (value >= 0 && value < this.entriesCount);
        return this.value2XorValue.get(value);
    }

    public String getEnumName(int value) {
        assert (value >= 0 && value < this.entriesCount);
        return this.value2Name.get(value);
    }

    public class TypeEntryRecord {
        int value;
        int xorValue;
    }
}

