/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ow2.dsrg.fm.tbpjava.checker.AutomatonState;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapper;
import org.ow2.dsrg.fm.tbpjava.checker.ThreadAutomatons;
import org.ow2.dsrg.fm.tbpjava.checker.ThreadStateStack;
import org.ow2.dsrg.fm.tbpjava.checker.VariablesEvaluation;
import org.ow2.dsrg.fm.tbpjava.utils.HashMapWithHashCode;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAComponentSpecification;
import org.ow2.dsrg.fm.tbplib.ltsa.State;

public final class StatesMapperLayer {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_INFO = false;
    private static final boolean INTERNAL_CHECKS = false;
    private static final double CONST_HASHMAP_GROWING = 1.5;
    private Set<HashMapWithHashCode<Integer, ThreadStateStack>> mappedState;
    private Map<AutomatonState, Set<VariablesEvaluation>> automatons2evaluations;
    private Map<VariablesEvaluation, HashMapWithHashCode<Integer, ThreadStateStack>> evaluations2automatons;
    private Map<VariablesEvaluation, HashMapWithHashCode<Integer, ThreadStateStack>> processingState;
    private boolean errorFlag;
    private String errorString;
    private String errorStringDetails;
    public static final String ERROR_MESSAGE_NO_ERROR = "no error";
    public static final String ERROR_MESSAGE_ILLEGAL_RETURN = "return without associated call";
    public static final String ERROR_MESSAGE_NOT_IN_PROCESSING_STATE = "variables evaluation not in PROCESSING state";
    public static final String ERROR_MESSAGE_NOT_IN_MAPPED_STATE = "variables evaluation not in MAPPED state";
    public static final String ERROR_MESSAGE_NOT_MAPPED_FOR_GIVEN_THREAD = "variables evaluation not mapped for given thread";
    public static final String DEBUG_OK = "OK";

    public StatesMapperLayer(LTSAComponentSpecification comp, StatesMapper statesMapper) {
        assert (comp != null);
        this.automatons2evaluations = new HashMap<AutomatonState, Set<VariablesEvaluation>>();
        this.evaluations2automatons = new HashMap<VariablesEvaluation, HashMapWithHashCode<Integer, ThreadStateStack>>();
        this.processingState = new HashMap<VariablesEvaluation, HashMapWithHashCode<Integer, ThreadStateStack>>();
        this.mappedState = new HashSet<HashMapWithHashCode<Integer, ThreadStateStack>>();
        this.errorFlag = false;
        this.errorString = ERROR_MESSAGE_NO_ERROR;
        this.errorStringDetails = null;
        this.setInitialContent(comp, statesMapper);
    }

    public StatesMapperLayer(StatesMapperLayer source) {
        assert (source != null);
        this.automatons2evaluations = new HashMap<AutomatonState, Set<VariablesEvaluation>>((int)((double)source.automatons2evaluations.size() * 1.5));
        this.mappedState = new HashSet<HashMapWithHashCode<Integer, ThreadStateStack>>((int)((double)source.mappedState.size() * 1.5));
        this.evaluations2automatons = new HashMap<VariablesEvaluation, HashMapWithHashCode<Integer, ThreadStateStack>>((int)((double)source.evaluations2automatons.size() * 1.5));
        this.processingState = new HashMap<VariablesEvaluation, HashMapWithHashCode<Integer, ThreadStateStack>>();
        this.errorFlag = source.errorFlag;
        this.errorString = source.errorString;
        this.errorStringDetails = source.errorStringDetails;
        for (VariablesEvaluation values : source.evaluations2automatons.keySet()) {
            HashMapWithHashCode<Integer, ThreadStateStack> valuesAssignedAutomatonStates = new HashMapWithHashCode<Integer, ThreadStateStack>(source.evaluations2automatons.get(values));
            this.evaluations2automatons.put(values, valuesAssignedAutomatonStates);
            this.mappedState.add(valuesAssignedAutomatonStates);
            for (ThreadStateStack tss : valuesAssignedAutomatonStates.values()) {
                AutomatonState as = tss.getAutomatonState();
                Set<VariablesEvaluation> asSet = this.automatons2evaluations.get(as);
                if (asSet == null) {
                    asSet = new HashSet<VariablesEvaluation>();
                }
                asSet.add(values);
                this.automatons2evaluations.put(as, asSet);
            }
        }
    }

    private void setInitialContent(LTSAComponentSpecification comp, StatesMapper statesMapper) {
        VariablesEvaluation initialValues = new VariablesEvaluation(comp, statesMapper);
        AutomatonState initialAS = new AutomatonState(null, new State(), -1);
        ThreadStateStack initialTss = new ThreadStateStack(initialAS, null);
        HashMapWithHashCode<Integer, ThreadStateStack> tssMap = new HashMapWithHashCode<Integer, ThreadStateStack>(initialValues);
        tssMap.put(-1, initialTss);
        this.evaluations2automatons.put(initialValues, tssMap);
        this.mappedState.add(tssMap);
        HashSet<VariablesEvaluation> varSet = new HashSet<VariablesEvaluation>();
        varSet.add(initialValues);
        this.automatons2evaluations.put(initialAS, varSet);
    }

    public void setMappingsAllStatesAsCall(AutomatonState as) {
        assert (as != null);
        this.mappedState.clear();
        this.automatons2evaluations.put(as, new HashSet<VariablesEvaluation>(this.evaluations2automatons.keySet()));
        for (Map.Entry<VariablesEvaluation, HashMapWithHashCode<Integer, ThreadStateStack>> entry : this.evaluations2automatons.entrySet()) {
            HashMapWithHashCode<Integer, ThreadStateStack> mappings = entry.getValue();
            ThreadStateStack tss = mappings.remove(as.getThreadNum());
            ThreadStateStack newTss = new ThreadStateStack(as, tss);
            mappings.put(as.getThreadNum(), newTss);
            this.mappedState.add(mappings);
            if (tss == null) continue;
            this.removeEvaluationFromForwardMapping(tss.getAutomatonState(), entry.getKey());
        }
    }

    public void setMappingsAllStatesAsReturn(int threadNum) {
        this.mappedState.clear();
        for (Map.Entry<VariablesEvaluation, HashMapWithHashCode<Integer, ThreadStateStack>> entry : this.evaluations2automatons.entrySet()) {
            HashMapWithHashCode<Integer, ThreadStateStack> mappings = entry.getValue();
            ThreadStateStack tss = mappings.remove(threadNum);
            assert (tss != null);
            if (tss == null) {
                this.processError(ERROR_MESSAGE_NOT_MAPPED_FOR_GIVEN_THREAD, StatesMapperLayer.class.getSimpleName() + ".setMappingsAllStatesAsReturn(threadNum= " + threadNum + ") values=" + entry.getKey() + " - Non existing mapping for give thread");
                continue;
            }
            ThreadStateStack prevTss = tss.getPrevious();
            if (prevTss != null) {
                prevTss = prevTss.processReturnEvent(tss);
                mappings.put(threadNum, prevTss);
            }
            if (!this.mappedState.contains(mappings)) {
                this.removeEvaluationFromForwardMapping(tss.getAutomatonState(), entry.getKey());
                if (prevTss != null) {
                    this.addEvaluationToForwardMapping(prevTss.getAutomatonState(), entry.getKey());
                }
                this.mappedState.add(mappings);
                continue;
            }
            this.removeEvaluationFromForwardMappings(entry.getKey());
            this.evaluations2automatons.remove(entry.getKey());
        }
    }

    public Set<VariablesEvaluation> getMappedStates(AutomatonState as) {
        HashSet<VariablesEvaluation> result = new HashSet<VariablesEvaluation>((Collection)this.automatons2evaluations.get(as));
        if (result != null) {
            for (VariablesEvaluation values : result) {
                this.changeEvaluationStateMapped2Processing(values);
            }
        }
        return result;
    }

    public void setMapping(AutomatonState as, VariablesEvaluation values) {
        assert (as != null);
        assert (values != null);
        VariablesEvaluation valuesCopy = new VariablesEvaluation(values);
        this.cloneMappings(values, valuesCopy);
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.getProcessingVariableEvaluationMapping(valuesCopy);
        ThreadStateStack oldASrepresentant = (ThreadStateStack)mappings.get(as.getThreadNum());
        ThreadStateStack newASrepresentant = null;
        if (oldASrepresentant != null) {
            newASrepresentant = oldASrepresentant.changeAutomatonState(as);
        } else {
            this.processError(ERROR_MESSAGE_ILLEGAL_RETURN, StatesMapperLayer.class.getSimpleName() + ".setMapping - Given VariablesEvaluation not found previous state in current thread");
            newASrepresentant = new ThreadStateStack(as, null);
        }
        mappings.put(as.getThreadNum(), newASrepresentant);
        this.changeEvaluationStateProcessing2Mapped(valuesCopy);
    }

    public void setMappingAsCall(AutomatonState as, VariablesEvaluation values) {
        assert (as != null);
        assert (values != null);
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.getProcessingVariableEvaluationMapping(values);
        ThreadStateStack oldASrepresentant = (ThreadStateStack)mappings.get(as.getThreadNum());
        ThreadStateStack newASrepresentant = new ThreadStateStack(as, oldASrepresentant);
        mappings.put(as.getThreadNum(), newASrepresentant);
        this.changeEvaluationStateProcessing2Mapped(values);
    }

    public AutomatonState setMappingAsReturn(int threadNum, VariablesEvaluation values) {
        assert (values != null);
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.getProcessingVariableEvaluationMapping(values);
        ThreadStateStack oldRepresentant = (ThreadStateStack)mappings.get(threadNum);
        ThreadStateStack newRepresentant = null;
        assert (oldRepresentant != null);
        if (oldRepresentant != null) {
            ThreadStateStack prevRepresentant = oldRepresentant.getPrevious();
            newRepresentant = prevRepresentant.processReturnEvent(oldRepresentant);
            mappings.put(threadNum, newRepresentant);
            this.changeEvaluationStateProcessing2Mapped(values);
        } else {
            this.processError(ERROR_MESSAGE_ILLEGAL_RETURN, StatesMapperLayer.class.getSimpleName() + ".setMappingAsReturn - Given VariablesEvaluation not found previous state in current thread");
        }
        if (newRepresentant != null) {
            return newRepresentant.getAutomatonState();
        }
        return null;
    }

    public void moveMappingToProcessing(VariablesEvaluation values) {
        assert (values != null);
        this.changeEvaluationStateMapped2Processing(values);
    }

    public void cloneMappings(VariablesEvaluation source, VariablesEvaluation target) {
        assert (source != null);
        assert (target != null);
        if (source == null || target == null) {
            return;
        }
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.processingState.get(source);
        HashMapWithHashCode<Integer, ThreadStateStack> newMappings = new HashMapWithHashCode<Integer, ThreadStateStack>(target, mappings);
        this.processingState.put(target, newMappings);
    }

    public void setReturnValue(int threadNum, VariablesEvaluation values, String retVal) {
        assert (values != null);
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.getProcessingVariableEvaluationMapping(values);
        if (mappings != null) {
            ThreadStateStack tss = (ThreadStateStack)mappings.get(threadNum);
            if (tss == null) {
                this.processError(ERROR_MESSAGE_NOT_MAPPED_FOR_GIVEN_THREAD, StatesMapperLayer.class.getSimpleName() + ".setReturnValue(threadNum= " + threadNum + ", values=" + values + ", retVal=" + retVal + ") - Non existing mapping for give thread");
                return;
            }
            ThreadStateStack newTss = new ThreadStateStack(tss, retVal);
            mappings.put(threadNum, newTss);
        }
    }

    public String getReturnValue(int threadNum, VariablesEvaluation values) {
        assert (values != null);
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.getProcessingVariableEvaluationMapping(values);
        if (mappings != null) {
            ThreadStateStack tss = (ThreadStateStack)mappings.get(threadNum);
            assert (tss != null);
            if (tss == null) {
                this.processError(ERROR_MESSAGE_NOT_MAPPED_FOR_GIVEN_THREAD, StatesMapperLayer.class.getSimpleName() + ".getReturnValue(threadNum= " + threadNum + ", values=" + values + ") - Non existing mapping for give thread");
                return null;
            }
            return tss.getReturnValue();
        }
        throw new RuntimeException("Unknown variables evaluation ... not in processing state " + values);
    }

    public String getLastCallReturnValue(int threadNum, VariablesEvaluation values) {
        assert (values != null);
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.getProcessingVariableEvaluationMapping(values);
        if (mappings != null) {
            ThreadStateStack tss = (ThreadStateStack)mappings.get(threadNum);
            assert (tss != null);
            if (tss == null) {
                this.processError(ERROR_MESSAGE_NOT_MAPPED_FOR_GIVEN_THREAD, StatesMapperLayer.class.getSimpleName() + ".getLastCallReturnValue(threadNum= " + threadNum + ", values=" + values + ") - Non existing mapping for the given thread");
                return null;
            }
            return tss.getLastCallReturnValue();
        }
        throw new RuntimeException("Unknown variables evaluation ... not in processing state " + values);
    }

    public ThreadStateStack.ReturnValues getLastCallReturnValueType(int threadNum, VariablesEvaluation values) {
        assert (values != null);
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.getProcessingVariableEvaluationMapping(values);
        if (mappings != null) {
            ThreadStateStack tss = (ThreadStateStack)mappings.get(threadNum);
            assert (tss != null);
            if (tss == null) {
                this.processError(ERROR_MESSAGE_NOT_MAPPED_FOR_GIVEN_THREAD, StatesMapperLayer.class.getSimpleName() + ".getLastCallReturnValueType(threadNum= " + threadNum + ", values=" + values + ") - Non existing mapping for the given thread");
                return null;
            }
            return tss.getLastCallReturnValueType();
        }
        throw new RuntimeException("Unknown variables evaluation ... not in processing state " + values);
    }

    public void setLastCallReturnValueTypeUndefinedEmit(int threadNum, VariablesEvaluation values) {
        assert (values != null);
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.getProcessingVariableEvaluationMapping(values);
        if (mappings != null) {
            ThreadStateStack tss = (ThreadStateStack)mappings.get(threadNum);
            assert (tss != null);
            if (tss == null) {
                this.processError(ERROR_MESSAGE_NOT_MAPPED_FOR_GIVEN_THREAD, StatesMapperLayer.class.getSimpleName() + ".setLastCallReturnValueTypeUndefinedEmit(threadNum= " + threadNum + ", values=" + values + ") - Non existing mapping for the given thread");
                return;
            }
            ThreadStateStack newTSS = tss.changeLastCallRetValTypeUndefEmit();
            mappings.put(threadNum, newTSS);
            return;
        }
        throw new RuntimeException("Unknown variables evaluation ... not in processing state " + values);
    }

    private void changeEvaluationStateProcessing2Mapped(VariablesEvaluation values) {
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.getProcessingVariableEvaluationMapping(values);
        this.processingState.remove(values);
        if (this.mappedState.contains(mappings)) {
            return;
        }
        this.mappedState.add(mappings);
        this.evaluations2automatons.put(values, mappings);
        for (ThreadStateStack tss : mappings.values()) {
            AutomatonState updatedAS = tss.getAutomatonState();
            this.addEvaluationToForwardMapping(updatedAS, values);
        }
    }

    private void changeEvaluationStateMapped2Processing(VariablesEvaluation values) {
        assert (values != null);
        HashMapWithHashCode<Integer, ThreadStateStack> mappings = this.evaluations2automatons.remove(values);
        this.mappedState.remove(mappings);
        if (mappings == null) {
            this.processError(ERROR_MESSAGE_NOT_IN_MAPPED_STATE, StatesMapperLayer.class.getSimpleName() + ".changeEvaluationStateMapped2Processing(values=" + values + ") - Given VariablesEvaluation not found in MAPPED state");
            return;
        }
        this.processingState.put(values, mappings);
        for (Map.Entry entry : mappings.entrySet()) {
            AutomatonState as = ((ThreadStateStack)entry.getValue()).getAutomatonState();
            this.removeEvaluationFromForwardMapping(as, values);
        }
    }

    private HashMapWithHashCode<Integer, ThreadStateStack> getProcessingVariableEvaluationMapping(VariablesEvaluation values) {
        HashMapWithHashCode<Integer, ThreadStateStack> result = this.processingState.get(values);
        if (result == null) {
            this.processError(ERROR_MESSAGE_NOT_IN_PROCESSING_STATE, StatesMapperLayer.class.getSimpleName() + ".getProcessingVariableEvaluationMapping(values=" + values + ") - Given VariablesEvaluation not found in PROCESSING state");
        }
        return result;
    }

    private HashMapWithHashCode<Integer, ThreadStateStack> getMappedVariableEvaluationMapping(VariablesEvaluation values) {
        HashMapWithHashCode<Integer, ThreadStateStack> result = this.evaluations2automatons.get(values);
        if (result == null) {
            this.processError(ERROR_MESSAGE_NOT_IN_MAPPED_STATE, StatesMapperLayer.class.getSimpleName() + ".getMappedVariableEvaluationMapping(values=" + values + ") - Given VariablesEvaluation not found in MAPPED state");
        }
        return result;
    }

    private void addEvaluationToForwardMapping(AutomatonState as, VariablesEvaluation values) {
        assert (as != null);
        assert (values != null);
        Set<VariablesEvaluation> newMapping = this.automatons2evaluations.get(as);
        if (newMapping == null) {
            newMapping = new HashSet<VariablesEvaluation>();
            this.automatons2evaluations.put(as, newMapping);
        }
        newMapping.add(values);
    }

    private void removeEvaluationFromForwardMapping(AutomatonState as, VariablesEvaluation values) {
        Set<VariablesEvaluation> asMapping = this.automatons2evaluations.get(as);
        assert (asMapping != null);
        asMapping.remove(values);
        if (asMapping.isEmpty()) {
            this.automatons2evaluations.remove(as);
        }
    }

    private void removeEvaluationFromForwardMappings(VariablesEvaluation values) {
        HashMapWithHashCode<Integer, ThreadStateStack> backwardMapping = this.evaluations2automatons.get(values);
        assert (backwardMapping != null);
        for (ThreadStateStack tss : backwardMapping.values()) {
            AutomatonState as = tss.getAutomatonState();
            Set<VariablesEvaluation> asMapping = this.automatons2evaluations.get(as);
            assert (asMapping != null);
            asMapping.remove(backwardMapping.getAssociatedVariablesEvaluation());
            if (!asMapping.isEmpty()) continue;
            this.automatons2evaluations.remove(as);
        }
    }

    private void processError(String errorString, String errorStringDetails) {
        if (!this.errorFlag) {
            this.errorFlag = true;
            this.errorString = errorString;
            this.errorStringDetails = errorStringDetails;
        }
        System.err.println("INTERNAL ERROR - " + errorStringDetails);
        throw new RuntimeException(errorStringDetails);
    }

    public int getHashCode() {
        return this.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatesMapperLayer other = (StatesMapperLayer)obj;
        if (this.getHashCode() != other.getHashCode()) {
            return false;
        }
        if (this.mappedState.size() != other.mappedState.size()) {
            return false;
        }
        for (HashMapWithHashCode<Integer, ThreadStateStack> val : this.mappedState) {
            if (other.mappedState.contains(val)) continue;
            return false;
        }
        return true;
    }

    public MappedStateHashableMemento getTBPPosition() {
        return new MappedStateHashableMemento(this.mappedState);
    }

    public void DEBUG_toString(int indent) {
        StringBuffer sb = new StringBuffer();
        ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
        sb.append(StatesMapper.class.getSimpleName());
        sb.append(".. Debugging all mappings");
        sb.append(", hash=" + this.hashCode());
        sb.append("\n");
        ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
        sb.append("MappedStates\n");
        sb.append(this.DEBUG_printMappedStates(indent + 2));
        ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
        sb.append("Automatons-->Variables\n");
        sb.append(this.DEBUG_printAutomatons2evaluationd(indent + 2));
        ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
        sb.append("Variables-->Automatons\n");
        sb.append(this.DEBUG_printEvaluations2automatons(indent + 2));
        ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
        sb.append("ProcessingStates\n");
        sb.append(this.DEBUG_printProcessingStates(indent + 2));
        System.out.println(sb);
    }

    public StringBuffer DEBUG_printAutomatons2evaluationd(int indent) {
        StringBuffer sb = new StringBuffer();
        for (AutomatonState as : this.automatons2evaluations.keySet()) {
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
            sb.append(as);
            sb.append('\n');
            Set<VariablesEvaluation> vars = this.automatons2evaluations.get(as);
            if (vars == null) {
                ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent + 2);
                sb.append("[null]\n");
                continue;
            }
            for (VariablesEvaluation var : vars) {
                ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent + 2);
                sb.append(var.toString());
                sb.append('\n');
            }
        }
        return sb;
    }

    public StringBuffer DEBUG_printEvaluations2automatons(int indent) {
        StringBuffer sb = new StringBuffer();
        for (VariablesEvaluation var : this.evaluations2automatons.keySet()) {
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
            sb.append(var.toString());
            sb.append('\n');
            HashMapWithHashCode<Integer, ThreadStateStack> automatonStatesMap = this.evaluations2automatons.get(var);
            if (automatonStatesMap == null) {
                ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent + 2);
                sb.append("[null]\n");
                continue;
            }
            for (Map.Entry entry : automatonStatesMap.entrySet()) {
                ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent + 2);
                sb.append(entry.getKey());
                sb.append("-->");
                sb.append(entry.getValue());
                sb.append('\n');
            }
        }
        return sb;
    }

    public StringBuffer DEBUG_printMappedStates(int indent) {
        StringBuffer sb = new StringBuffer();
        for (HashMapWithHashCode<Integer, ThreadStateStack> mappings : this.mappedState) {
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
            sb.append("ValEval ID=" + mappings.getAssociatedVariablesEvaluation().DEBUG_get_variableEvaluationID() + " " + mappings.getAssociatedVariablesEvaluation());
            sb.append('\n');
            for (Map.Entry entry : mappings.entrySet()) {
                ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent + 2);
                sb.append(entry.getKey());
                sb.append("-->");
                sb.append(entry.getValue());
                sb.append('\n');
            }
        }
        return sb;
    }

    public StringBuffer DEBUG_printProcessingStates(int indent) {
        StringBuffer sb = new StringBuffer();
        for (VariablesEvaluation values : this.processingState.keySet()) {
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
            sb.append("ValEval ID=" + values.DEBUG_get_variableEvaluationID() + " " + values);
            sb.append('\n');
            HashMapWithHashCode<Integer, ThreadStateStack> automatonStatesMap = this.processingState.get(values);
            if (automatonStatesMap == null) {
                ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent + 2);
                sb.append("[null]\n");
                continue;
            }
            for (Map.Entry entry : automatonStatesMap.entrySet()) {
                ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent + 2);
                sb.append(entry.getKey());
                sb.append("-->");
                sb.append(entry.getValue());
                sb.append('\n');
            }
        }
        return sb;
    }

    public Set<VariablesEvaluation> DEBUG_getAssociatedMappedVariables(AutomatonState as) {
        Set<VariablesEvaluation> result = this.automatons2evaluations.get(as);
        if (result != null) {
            return Collections.unmodifiableSet(result);
        }
        return null;
    }

    public boolean DEBUG_checkConsistency() {
        String checkResult = this.DEBUG_checkConsistency1();
        if (checkResult != DEBUG_OK) {
            System.err.println("CHECK consistency fail !!!!");
            throw new RuntimeException("CHECK consistency fail !!!! \n" + checkResult);
        }
        return checkResult == DEBUG_OK;
    }

    public String DEBUG_checkConsistency1() {
        String result = this.DEBUG_checkConsistencty_mappedStates();
        if (result != DEBUG_OK) {
            return result;
        }
        result = this.DEBUG_checkConsistencty_automatons2evaluations();
        if (result != DEBUG_OK) {
            return result;
        }
        result = this.DEBUG_checkConsistencty_evaluations2automatons();
        if (result != DEBUG_OK) {
            return result;
        }
        result = this.DEBUG_checkConsistencty_processingStates();
        if (result != DEBUG_OK) {
            return result;
        }
        return result;
    }

    private String DEBUG_checkConsistencty_mappedStates() {
        if (this.mappedState == null) {
            return "property mappedState is null";
        }
        for (HashMapWithHashCode<Integer, ThreadStateStack> mappings : this.mappedState) {
            if (mappings == null) {
                return "property mappings contains null entry";
            }
            VariablesEvaluation var = mappings.getAssociatedVariablesEvaluation();
            if (var == null) {
                return "property mappings, entry=" + mappings + " contains null as associted VariablesEvaluation";
            }
            HashMapWithHashCode<Integer, ThreadStateStack> other = this.evaluations2automatons.get(var);
            if (other == null) {
                return "property mappings, entry=" + mappings + " associated varEval=" + var + " has no asociated mappings in the evaluations2automatons";
            }
            if (!mappings.equals(other)) {
                return "property mappings, entry=" + mappings + " associated varEval=" + var + ". Evaluations2automatons has associated different mappings=" + other;
            }
            mappings.DEBUG_checkConsistency();
        }
        return DEBUG_OK;
    }

    private String DEBUG_checkConsistencty_automatons2evaluations() {
        if (this.automatons2evaluations == null) {
            return "property automatons2evaluations is null";
        }
        for (AutomatonState as : this.automatons2evaluations.keySet()) {
            if (as == null) {
                return "property automatons2evaluations contains null entry";
            }
            Set<VariablesEvaluation> vars = this.automatons2evaluations.get(as);
            if (vars == null) {
                return "property automatons2evaluations, entry=" + as + " has null value as associated states";
            }
            for (VariablesEvaluation var : vars) {
                if (var == null) {
                    return "property automatons2evaluations, entry=" + as + " has null as one from associated variable evaluation";
                }
                if (!this.evaluations2automatons.containsKey(var)) {
                    return "property automatons2evaluations, entry=" + as + ", var=" + var + " " + var.toString() + " has not any counterpart variable mappings";
                }
                if (this.processingState.containsKey(var)) {
                    return "property automatons2evaluations, entry=" + as + ", var=" + var + " " + var.toString() + " is in PROCESSING state";
                }
                HashMapWithHashCode<Integer, ThreadStateStack> asMap = this.evaluations2automatons.get(var);
                if (asMap == null) {
                    return "property automatons2evaluations, entry=" + as + ", var=" + var + " " + var.toString() + " has null value set in reverse states2automaton map";
                }
                ThreadStateStack tss = (ThreadStateStack)asMap.get(as.getThreadNum());
                if (tss == null) {
                    return "property automatons2evaluations, entry=" + as + ", var=" + var + " " + var.toString() + " has not thread specific counterpart in reverse evaluations2automaton map";
                }
                if (tss.getAutomatonState().equals(as)) continue;
                return "property automatons2evaluations, entry=" + as + ", var=" + var + " " + var.toString() + " has set invalid counterpart state (tss.as=" + tss.getAutomatonState() + ")in reverse states2automaton map";
            }
        }
        return DEBUG_OK;
    }

    private String DEBUG_checkConsistencty_evaluations2automatons() {
        if (this.evaluations2automatons == null) {
            return "property evaluations2automatons is null";
        }
        for (VariablesEvaluation var : this.evaluations2automatons.keySet()) {
            if (var == null) {
                return "property evaluations2automatons contains null entry";
            }
            if (this.processingState.containsKey(var)) {
                return "property evaluations2automatons, contains var=" + var + ", but processingStates contains this var too. Evaluation is in both MAPPED and PROCESSING states";
            }
            HashMapWithHashCode<Integer, ThreadStateStack> varAsocMap = this.evaluations2automatons.get(var);
            if (varAsocMap == null) {
                return "property evaluations2automatons, var=" + var + " has null as mapped value";
            }
            if (varAsocMap.getAssociatedVariablesEvaluation() != var) {
                return "property evaluations2automatons, var=" + var + " mapped HashMap is internaly associted with different evaluation (" + varAsocMap.getAssociatedVariablesEvaluation() + ").";
            }
            if (!this.mappedState.contains(varAsocMap)) {
                return "property evaluations2automatons, var=" + var + " no counterpart stored in the mappedState set";
            }
            for (Map.Entry entry : varAsocMap.entrySet()) {
                Integer threadNum = (Integer)entry.getKey();
                if (threadNum == null) {
                    return "property evaluations2automatons, var=" + var + " has null as one mapped thread number";
                }
                ThreadStateStack tss = (ThreadStateStack)entry.getValue();
                if (tss == null) {
                    return "property evaluations2automatons, var=" + var + " has under thread=" + threadNum + " associated null as thread state stack value";
                }
                AutomatonState as = tss.getAutomatonState();
                if (as == null) {
                    return "property evaluations2automatons, var=" + var + " has under thread=" + threadNum + " associated tss=" + tss + " with null automaton state";
                }
                if (!this.automatons2evaluations.containsKey(as)) {
                    return "property evaluations2automatons, var=" + var + " has under thread=" + threadNum + " associated tss=" + tss + " with as=" + as + " that isn't mapped in forward automatons2evaluations mapping";
                }
                Set<VariablesEvaluation> asVars = this.automatons2evaluations.get(as);
                if (asVars == null) {
                    return "property evaluations2automatons, var=" + var + " has under thread=" + threadNum + " associated tss=" + tss + " with as=" + as + " that has in forward automatons2evaluations mapping null as set with variables";
                }
                if (asVars.contains(var)) continue;
                return "property evaluations2automatons, var=" + var + " has under thread=" + threadNum + " associated tss=" + tss + " with as=" + as + " that hasn't in forward automatons2evaluations mapping variables this variables mapped";
            }
        }
        return DEBUG_OK;
    }

    private String DEBUG_checkConsistencty_processingStates() {
        if (this.processingState == null) {
            return "property processingState is null";
        }
        for (VariablesEvaluation var : this.processingState.keySet()) {
            if (var == null) {
                return "property processingState contains null entry";
            }
            if (this.evaluations2automatons.containsKey(var)) {
                return "property processingState, contains var=" + var + ", but evaluations2automatons contains this var too. Evaluation is in both MAPPED and PROCESSING states";
            }
            HashMapWithHashCode<Integer, ThreadStateStack> varAsocMap = this.processingState.get(var);
            if (varAsocMap == null) {
                return "property processingState, var=" + var + " has null as mapped value";
            }
            if (varAsocMap.getAssociatedVariablesEvaluation() != var) {
                return "property processingState, var=" + var + " mapped HashMap is internaly associted with different evaluation (" + varAsocMap.getAssociatedVariablesEvaluation() + ").";
            }
            varAsocMap.DEBUG_checkConsistency();
            for (Map.Entry entry : varAsocMap.entrySet()) {
                Integer threadNum = (Integer)entry.getKey();
                if (threadNum == null) {
                    return "property processingState, var=" + var + " has null as one mapped thread number";
                }
                ThreadStateStack tss = (ThreadStateStack)entry.getValue();
                if (tss == null) {
                    return "property processingState, var=" + var + " has under thread=" + threadNum + " associated null as thread state stack value";
                }
                AutomatonState as = tss.getAutomatonState();
                if (as == null) {
                    return "property processingState, var=" + var + " " + var.toString() + " has under thread=" + threadNum + " associated tss=" + tss + " with null automaton state";
                }
                if (!this.automatons2evaluations.containsKey(as)) continue;
                Set<VariablesEvaluation> asVars = this.automatons2evaluations.get(as);
                if (asVars == null) {
                    return "property processingState, var=" + var + " " + var.toString() + " has under thread=" + threadNum + " associated tss=" + tss + " with as=" + as + " that has in forward automatons2evaluations mapping null as set with variables";
                }
                if (!asVars.contains(var)) continue;
                return "property processingState, var=" + var + " " + var.toString() + " has under thread=" + threadNum + " associated tss=" + tss + " with as=" + as + " that has mapping in forward automatons2evaluations variables this variables mapped";
            }
        }
        return DEBUG_OK;
    }

    public static class MappedStateHashableMemento {
        private final Set<HashMapWithHashCode<Integer, ThreadStateStack>> mappedState;
        private final int hashCode;
        private static final int HASH_CODE_PRIME = 43;
        public static final int INVALID_MEMENTO_INDEX = -1;
        private int mementoIndex = -1;

        public MappedStateHashableMemento(Set<HashMapWithHashCode<Integer, ThreadStateStack>> source) {
            assert (source != null);
            TreeSet<HashMapWithHashCode<Integer, ThreadStateStack>> sortedSource = new TreeSet<HashMapWithHashCode<Integer, ThreadStateStack>>(source);
            this.mappedState = new HashSet<HashMapWithHashCode<Integer, ThreadStateStack>>((int)((double)source.size() * 1.5));
            int tmpHashCode = 0;
            for (HashMapWithHashCode hashMapWithHashCode : sortedSource) {
                HashMapWithHashCode mappingsCopy = new HashMapWithHashCode(hashMapWithHashCode);
                this.mappedState.add(mappingsCopy);
                tmpHashCode = tmpHashCode * 43 + mappingsCopy.getHashCode();
            }
            this.hashCode = tmpHashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MappedStateHashableMemento)) {
                return false;
            }
            MappedStateHashableMemento other = (MappedStateHashableMemento)obj;
            if (this.hashCode() != other.hashCode()) {
                return false;
            }
            if (this.mappedState.size() != other.mappedState.size()) {
                return false;
            }
            for (HashMapWithHashCode<Integer, ThreadStateStack> mappings : this.mappedState) {
                if (other.mappedState.contains(mappings)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.toString(2);
        }

        public String toString(int indent) {
            StringBuffer sb = new StringBuffer();
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
            sb.append("Debugging " + MappedStateHashableMemento.class.getSimpleName() + "\n");
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent += 2);
            sb.append("hashCode=");
            sb.append(this.hashCode);
            sb.append('\n');
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
            sb.append("mementoIndex=");
            sb.append(this.mementoIndex);
            sb.append('\n');
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
            sb.append("MappedStates=Set:\n");
            this.DEBUG_printMappedStates(sb, indent + 2);
            return sb.toString();
        }

        public void DEBUG_printMappedStates(StringBuffer sb, int indent) {
            for (HashMapWithHashCode<Integer, ThreadStateStack> mappings : this.mappedState) {
                ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
                sb.append("ValEval ID=" + mappings.getAssociatedVariablesEvaluation().DEBUG_get_variableEvaluationID() + " " + mappings.getAssociatedVariablesEvaluation());
                sb.append('\n');
                for (Map.Entry entry : mappings.entrySet()) {
                    ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent + 2);
                    sb.append(entry.getKey());
                    sb.append("-->");
                    sb.append(entry.getValue());
                    sb.append('\n');
                }
            }
        }

        public int getMementoIndex() {
            return this.mementoIndex;
        }

        public void setMementoIndex(int newIndex) {
            if (this.mementoIndex != -1) {
                throw new RuntimeException("Multiple setMementoIndex calls");
            }
            this.mementoIndex = newIndex;
        }
    }
}

