/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.util.Set;
import java.util.Stack;
import org.ow2.dsrg.fm.tbpjava.checker.AutomatonState;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapperLayer;
import org.ow2.dsrg.fm.tbpjava.checker.ThreadStateStack;
import org.ow2.dsrg.fm.tbpjava.checker.VariablesEvaluation;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAComponentSpecification;

public final class StatesMapper {
    private Stack<StatesMapperLayer> stateLayerStack;

    public StatesMapper(LTSAComponentSpecification comp) {
        assert (comp != null);
        this.stateLayerStack = new Stack();
        StatesMapperLayer initialLayer = new StatesMapperLayer(comp, this);
        this.stateLayerStack.add(initialLayer);
    }

    public void newLayer() {
        StatesMapperLayer newTopLayerStackCopy = new StatesMapperLayer(this.stateLayerStack.peek());
        this.stateLayerStack.push(newTopLayerStackCopy);
    }

    public boolean removeStackLayer() {
        if (this.stateLayerStack.isEmpty()) {
            return false;
        }
        this.stateLayerStack.pop();
        return true;
    }

    public void setReturnValue(int threadNum, VariablesEvaluation values, String retVal) {
        this.stateLayerStack.peek().setReturnValue(threadNum, values, retVal);
    }

    public String getReturnValue(int threadNum, VariablesEvaluation values) {
        return this.stateLayerStack.peek().getReturnValue(threadNum, values);
    }

    public String getLastCallReturnValue(int threadNum, VariablesEvaluation values) {
        return this.stateLayerStack.peek().getLastCallReturnValue(threadNum, values);
    }

    public ThreadStateStack.ReturnValues getLastCallReturnValueType(int threadNum, VariablesEvaluation values) {
        return this.stateLayerStack.peek().getLastCallReturnValueType(threadNum, values);
    }

    public void setLastCallReturnValueTypeUndefinedEmit(int threadNum, VariablesEvaluation values) {
        this.stateLayerStack.peek().setLastCallReturnValueTypeUndefinedEmit(threadNum, values);
    }

    public void setMappingsAllStatesAsCall(AutomatonState as) {
        this.stateLayerStack.peek().setMappingsAllStatesAsCall(as);
    }

    public void setMappingsAllStatesAsReturn(int threadNum) {
        this.stateLayerStack.peek().setMappingsAllStatesAsReturn(threadNum);
    }

    public void setMappingsAsCall(AutomatonState as, VariablesEvaluation values) {
        this.stateLayerStack.peek().setMappingAsCall(as, values);
    }

    public AutomatonState setMappingsAsReturn(int threadNum, VariablesEvaluation values) {
        return this.stateLayerStack.peek().setMappingAsReturn(threadNum, values);
    }

    public Set<VariablesEvaluation> getMappings(AutomatonState as) {
        assert (as != null);
        return this.stateLayerStack.peek().getMappedStates(as);
    }

    public void setMappings(AutomatonState as, VariablesEvaluation values) {
        this.stateLayerStack.peek().setMapping(as, values);
    }

    public void moveMappingToProcessing(VariablesEvaluation values) {
        this.stateLayerStack.peek().moveMappingToProcessing(values);
    }

    public void cloneMappings(VariablesEvaluation source, VariablesEvaluation target) {
        this.stateLayerStack.peek().cloneMappings(source, target);
    }

    public StatesMapperLayer.MappedStateHashableMemento getTBPPosition() {
        return this.stateLayerStack.peek().getTBPPosition();
    }

    public Set<VariablesEvaluation> DEBUG_getAssociatedMappings(AutomatonState as) {
        assert (as != null);
        return this.stateLayerStack.peek().DEBUG_getAssociatedMappedVariables(as);
    }
}

