/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.Property;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.search.Search;
import java.util.Collections;
import java.util.List;
import org.ow2.dsrg.fm.tbpjava.checker.JPFProgramStateMapping;
import org.ow2.dsrg.fm.tbpjava.checker.JPFProgramStateMappingEventList;
import org.ow2.dsrg.fm.tbpjava.checker.JPFProgramStateMappingPrecise;
import org.ow2.dsrg.fm.tbpjava.checker.JPFProgramStateMappingTBPProtocolPositionsHash;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapper;

public class JPFSearch
extends Search {
    private static final boolean DEBUG = false;
    private static final JPFProgramStateMappers psmType = JPFProgramStateMappers.JPF_PSM_TBPProtocolPositions;
    private JPFProgramStateMapping programStateMapping = null;

    public JPFSearch(Config config, JVM vm) {
        super(config, vm);
    }

    public List<Property> getJPFProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public JPFProgramStateMapping getJPFProgramStateMapping() {
        return this.programStateMapping;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStatesMapper(StatesMapper varMapper) {
        if (this.programStateMapping != null) throw new RuntimeException("Internal error - multiple method call. We expect only the one call before the search class is used.");
        if (psmType == JPFProgramStateMappers.JPF_PSM_EventList) {
            this.programStateMapping = new JPFProgramStateMappingEventList();
            return;
        } else if (psmType == JPFProgramStateMappers.JPF_PSM_TBPProtocolPositions) {
            this.programStateMapping = new JPFProgramStateMappingPrecise(varMapper);
            return;
        } else {
            if (psmType != JPFProgramStateMappers.JPF_PSM_TBPProtocolPositionsHash) throw new RuntimeException("Unsupported enum " + (psmType != null ? ((Object)((Object)psmType)).getClass().getSimpleName() : "!null!") + " entry " + (Object)((Object)psmType));
            this.programStateMapping = new JPFProgramStateMappingTBPProtocolPositionsHash(varMapper);
        }
    }

    public boolean requestBacktrack() {
        this.doBacktrack = true;
        return true;
    }

    public void search() {
        int maxDepth = this.getMaxSearchDepth();
        boolean depthLimitReached = false;
        this.depth = 0;
        this.notifySearchStarted();
        while (!this.done) {
            int programStateID = this.vm.getSystemState().getId();
            if (!this.isNewState() && this.programStateMapping.wasProcessed(programStateID) || this.isEndState() || this.isIgnoredState() || depthLimitReached) {
                if (!this.backtrack()) break;
                depthLimitReached = false;
                --this.depth;
                this.notifyStateBacktracked();
            }
            if (this.forward()) {
                ++this.depth;
                this.notifyStateAdvanced();
                if (this.currentError != null) {
                    this.notifyPropertyViolated();
                }
                if (this.hasPropertyTermination()) break;
                if (this.depth >= maxDepth) {
                    depthLimitReached = true;
                    this.notifySearchConstraintHit("Search Depth: " + maxDepth);
                    continue;
                }
                if (this.checkStateSpaceLimit()) continue;
                this.notifySearchConstraintHit("Free Memory Limit: " + this.minFreeMemory);
                break;
            }
            this.notifyStateProcessed();
        }
        this.notifySearchFinished();
    }

    public boolean supportsBacktrack() {
        return true;
    }

    public static String getStaticConfiguration() {
        if (psmType == JPFProgramStateMappers.JPF_PSM_EventList) {
            return "Used program state mapper " + JPFProgramStateMappingEventList.class.getSimpleName();
        }
        if (psmType == JPFProgramStateMappers.JPF_PSM_TBPProtocolPositions) {
            return "Used program state mapper " + JPFProgramStateMappingPrecise.class.getSimpleName();
        }
        if (psmType == JPFProgramStateMappers.JPF_PSM_TBPProtocolPositionsHash) {
            return "Used program state mapper " + JPFProgramStateMappingTBPProtocolPositionsHash.class.getSimpleName();
        }
        throw new RuntimeException("Unsupported enum " + (psmType != null ? ((Object)((Object)psmType)).getClass().getSimpleName() : "!null!") + " entry " + (Object)((Object)psmType));
    }

    private static enum JPFProgramStateMappers {
        JPF_PSM_TBPProtocolPositions,
        JPF_PSM_TBPProtocolPositionsHash,
        JPF_PSM_EventList;

    }
}

