/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ow2.dsrg.fm.tbpjava.checker.EventItem;
import org.ow2.dsrg.fm.tbpjava.checker.JPFProgramStateMapping;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapper;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapperLayer;
import org.ow2.dsrg.fm.tbpjava.checker.ThreadAutomatons;
import org.ow2.dsrg.fm.tbpjava.utils.Pair;

final class JPFProgramStateMappingTBPProtocolPositionsHash
implements JPFProgramStateMapping {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_INFO = false;
    private static final boolean INTERNLAL_TESTS = false;
    private final PrintStream out = System.out;
    private final StatesMapper varMapper;
    private Map<Integer, Set<Integer>> mapJPFState2TBPProtocolStateHash;
    private Stack<Pair<Integer, StatesMapperLayer.MappedStateHashableMemento>> stack = new Stack();

    public JPFProgramStateMappingTBPProtocolPositionsHash(StatesMapper varMapper) {
        assert (varMapper != null);
        this.varMapper = varMapper;
        this.mapJPFState2TBPProtocolStateHash = new HashMap<Integer, Set<Integer>>();
    }

    @Override
    public void addMapping(int stateID) {
        Set<Integer> tbpPositionsSet = this.mapJPFState2TBPProtocolStateHash.get(stateID);
        if (tbpPositionsSet == null) {
            tbpPositionsSet = new HashSet<Integer>();
            this.mapJPFState2TBPProtocolStateHash.put(stateID, tbpPositionsSet);
        }
        StatesMapperLayer.MappedStateHashableMemento currentTBPPosition = this.varMapper.getTBPPosition();
        tbpPositionsSet.add(currentTBPPosition.hashCode());
    }

    @Override
    public void advancedEvents(List<EventItem> events, int jpfStateID) {
        StatesMapperLayer.MappedStateHashableMemento currentTBPPosition = this.varMapper.getTBPPosition();
        this.stack.push(new Pair<Integer, StatesMapperLayer.MappedStateHashableMemento>(jpfStateID, currentTBPPosition));
    }

    @Override
    public void undoEvents() {
        this.stack.pop();
    }

    @Override
    public boolean wasProcessed(int stateID) {
        StatesMapperLayer.MappedStateHashableMemento currentTBPPosition = this.varMapper.getTBPPosition();
        boolean findMap = this.isStoredInProcessedStateMapHash(stateID, currentTBPPosition);
        if (findMap) {
            return true;
        }
        boolean findStack = this.isStoredInTheStack(stateID, currentTBPPosition);
        return findStack;
    }

    private boolean isStoredInTheStack(int stateID, StatesMapperLayer.MappedStateHashableMemento currentTBPPosition) {
        Iterator it = this.stack.iterator();
        for (int i = 0; i < this.stack.size() - 1; ++i) {
            Pair entry = (Pair)it.next();
            if ((Integer)entry.getFirst() != stateID || !((StatesMapperLayer.MappedStateHashableMemento)entry.getSecond()).equals(currentTBPPosition)) continue;
            return true;
        }
        return false;
    }

    private boolean isStoredInProcessedStateMapHash(int stateID, StatesMapperLayer.MappedStateHashableMemento currentTBPPosition) {
        Set<Integer> tbpPositionsSet = this.mapJPFState2TBPProtocolStateHash.get(stateID);
        if (tbpPositionsSet == null) {
            return false;
        }
        return tbpPositionsSet.contains(currentTBPPosition.hashCode());
    }

    private void DEBUG_TBPPositionSet(int indent, int stateID, StringBuffer sb) {
        ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
        sb.append("stateID ->" + stateID);
        Set<Integer> tbpPostionsSet = this.mapJPFState2TBPProtocolStateHash.get(stateID);
        if (tbpPostionsSet == null) {
            sb.append("... no mappings ... null\n");
        } else {
            sb.append('\n');
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent + 2);
            boolean first = true;
            for (Integer tbpPosition : tbpPostionsSet) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(tbpPosition);
            }
        }
    }

    private StringBuffer toString_DEBUG_INFO(int indent, int highlightedJPFState) {
        StringBuffer sb = new StringBuffer();
        ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
        sb.append("Debugging Internal state of the " + this.getClass().getSimpleName() + "\n");
        ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent += 2);
        sb.append("mapJPFState2TBPProtocolState=\n");
        for (Integer jpfState : this.mapJPFState2TBPProtocolStateHash.keySet()) {
            this.DEBUG_TBPPositionSet(jpfState == highlightedJPFState ? indent + 2 : indent + 6, jpfState, sb);
        }
        ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
        sb.append("stack=\n");
        for (int i = 0; i < this.stack.size(); ++i) {
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
            sb.append(i);
            Pair pair = (Pair)this.stack.get(i);
            sb.append(" -> jpfStateID=");
            sb.append(pair.getFirst());
            sb.append(", TBPPosition=\n");
            sb.append(((StatesMapperLayer.MappedStateHashableMemento)pair.getSecond()).toString(indent + 2));
        }
        return sb;
    }

    @Override
    public String getUsageStatistics() {
        String result = "";
        int extendedStated = 0;
        for (Map.Entry<Integer, Set<Integer>> entryMappedPos : this.mapJPFState2TBPProtocolStateHash.entrySet()) {
            if (entryMappedPos.getValue() == null) continue;
            extendedStated += entryMappedPos.getValue().size();
        }
        result = result + "Extended JPF states : " + (extendedStated += this.stack.size());
        return result;
    }
}

