/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ow2.dsrg.fm.tbpjava.EnvGenerator;
import org.ow2.dsrg.fm.tbpjava.checker.EventItem;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapper;
import org.ow2.dsrg.fm.tbpjava.checker.ThreadAutomatons;
import org.ow2.dsrg.fm.tbpjava.utils.Configuration;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAComponentSpecification;

public class EventParser {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_INFO = false;
    private Configuration config;
    private LTSAComponentSpecification spec;
    private StatesMapper varStateMap;
    private Stack<Map<Integer, ThreadAutomatons>> state;
    public static final int NO_ERROR = -1;
    private int processEventsIndexErrorEvent = -1;
    private EnvGenerator.EnvironmentDescription envDesc;
    private Set<Integer> threadNums = new HashSet<Integer>();
    private int processEventsCallCount = 0;

    public EventParser(Configuration config, LTSAComponentSpecification spec, StatesMapper varStateMap, EnvGenerator.EnvironmentDescription envDesc) {
        this.config = config;
        this.spec = spec;
        this.varStateMap = varStateMap;
        this.state = new Stack();
        this.envDesc = envDesc;
    }

    public void initializeEventParser() {
        this.state.clear();
        HashMap<Integer, ThreadAutomatons.ThreadType> initialMainThread = new HashMap<Integer, ThreadAutomatons.ThreadType>(2);
        initialMainThread.put(0, ThreadAutomatons.ThreadType.ENVIRONMENT_THREAD);
        this.processEvents(initialMainThread, null, null);
    }

    public boolean processEvents(Map<Integer, ThreadAutomatons.ThreadType> startedThreads, List<EventItem> events, List<Integer> endedThreads) {
        ++this.processEventsCallCount;
        this.processEventsIndexErrorEvent = -1;
        boolean result = true;
        this.varStateMap.newLayer();
        this.threadNums.clear();
        if (events != null) {
            for (EventItem event : events) {
                this.threadNums.add(event.thread);
            }
        }
        this.createNewStateLevel(this.threadNums);
        if (startedThreads != null) {
            result &= this.processThreadStarts(startedThreads);
        }
        if (events != null) {
            result &= this.processEvents(events);
        }
        if (endedThreads != null) {
            result &= this.processThreadEnds(endedThreads);
        }
        return result;
    }

    private boolean processEvents(List<EventItem> events) {
        boolean result = true;
        Map<Integer, ThreadAutomatons> currentState = this.state.peek();
        for (int eventIndex = 0; eventIndex < events.size() && result; ++eventIndex) {
            EventItem event = events.get(eventIndex);
            ThreadAutomatons threadAutomatons = currentState.get(event.thread);
            if (threadAutomatons == null) {
                throw new RuntimeException("Internal Error - events from unknown (not started thread) (Event=" + event + ")");
            }
            if (event.type == EventItem.EventTypes.EVENT_CALL) {
                ThreadAutomatons newState;
                if (this.config.getComponentProvidedInterfaces().containsKey(event.interfaceName)) {
                    newState = threadAutomatons.processEventProvidedCall(event, this.processEventsCallCount);
                    result &= !newState.getError();
                    this.processEventsIndexErrorEvent = eventIndex;
                    currentState.put(event.thread, newState);
                    continue;
                }
                newState = threadAutomatons.processEventRequiredCall(event, this.processEventsCallCount);
                result &= !threadAutomatons.getError();
                this.processEventsIndexErrorEvent = eventIndex;
                currentState.put(event.thread, newState);
                continue;
            }
            if (event.type == EventItem.EventTypes.EVENT_RETURN) {
                ThreadAutomatons prevLevel;
                if (this.config.getComponentProvidedInterfaces().containsKey(event.interfaceName)) {
                    if (threadAutomatons == null) {
                        result = false;
                        this.processEventsIndexErrorEvent = eventIndex;
                        continue;
                    }
                    prevLevel = threadAutomatons.processEventProvidedReturn(event, this.processEventsCallCount);
                    result &= !threadAutomatons.getError();
                    this.processEventsIndexErrorEvent = eventIndex;
                    currentState.put(event.thread, prevLevel);
                    continue;
                }
                prevLevel = threadAutomatons.processEventRequiredReturn(event, this.processEventsCallCount);
                result &= !threadAutomatons.getError();
                this.processEventsIndexErrorEvent = eventIndex;
                currentState.put(event.thread, prevLevel);
                continue;
            }
            throw new RuntimeException("Unknown event type (Event=" + event + ")");
        }
        return result;
    }

    public int getProcessEventIndexErrorEvent() {
        return this.processEventsIndexErrorEvent;
    }

    private boolean processThreadStarts(Map<Integer, ThreadAutomatons.ThreadType> startedThreads) {
        assert (startedThreads != null);
        Map<Integer, ThreadAutomatons> currentState = this.state.peek();
        for (Map.Entry<Integer, ThreadAutomatons.ThreadType> threadRec : startedThreads.entrySet()) {
            if (currentState.containsKey(threadRec.getKey())) {
                throw new RuntimeException("Internal error - Existing thread newly started");
            }
            ThreadAutomatons newThreadTA = new ThreadAutomatons(this.spec, this.varStateMap, threadRec.getValue(), this.processEventsCallCount, threadRec.getKey(), this.envDesc);
            currentState.put(threadRec.getKey(), newThreadTA);
        }
        return true;
    }

    private boolean processThreadEnds(List<Integer> endedThreads) {
        boolean result = true;
        if (this.state.isEmpty()) {
            return true;
        }
        Map<Integer, ThreadAutomatons> currentState = this.state.peek();
        for (Integer endedThreadNum : endedThreads) {
            ThreadAutomatons automatons = currentState.remove(endedThreadNum);
            if (automatons == null) continue;
            result &= automatons.isEndState();
        }
        return result;
    }

    public ThreadAutomatons.ThreadType getThreadType(int threadNum) {
        Map<Integer, ThreadAutomatons> currentState = this.state.peek();
        ThreadAutomatons threadAutomatons = currentState.get(threadNum);
        if (threadAutomatons == null) {
            return null;
        }
        return threadAutomatons.getThreadType();
    }

    public boolean undoEvents() {
        if (this.state.isEmpty()) {
            return false;
        }
        this.state.pop();
        this.varStateMap.removeStackLayer();
        return true;
    }

    private void createNewStateLevel(Set<Integer> threadNumsToClone) {
        HashMap<Integer, ThreadAutomatons> newLevel = new HashMap<Integer, ThreadAutomatons>();
        if (this.state.isEmpty()) {
            this.state.add(newLevel);
            return;
        }
        Map<Integer, ThreadAutomatons> topLevel = this.state.peek();
        for (Map.Entry<Integer, ThreadAutomatons> entry : topLevel.entrySet()) {
            Integer processedThread = entry.getKey();
            ThreadAutomatons automatons = entry.getValue();
            if (threadNumsToClone.contains(processedThread) && automatons != null) {
                automatons = automatons.clone(this.processEventsCallCount);
            }
            newLevel.put(processedThread, automatons);
        }
        this.state.add(newLevel);
    }

    public void DEBUG_printState() {
        System.out.println("DEBUG - Printing " + this.getClass().getSimpleName() + " state");
        System.out.println("  Stack state - depth:" + this.state.size());
        for (Map map : this.state) {
            System.out.println("    " + map);
        }
    }

    public static void DEBUG_printEvents(List<EventItem> events, int indent) {
        if (events == null) {
            return;
        }
        String indentation = ThreadAutomatons.DEBUG_indetStringBuffer(null, indent).toString();
        for (EventItem event : events) {
            System.out.print(indentation);
            System.out.println(event);
        }
    }
}

