/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ow2.dsrg.fm.tbpjava.checker.AutomatonState;
import org.ow2.dsrg.fm.tbpjava.checker.AutomatonWalker;
import org.ow2.dsrg.fm.tbpjava.checker.EventItem;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapper;
import org.ow2.dsrg.fm.tbpjava.checker.ThreadAutomatons;
import org.ow2.dsrg.fm.tbpjava.checker.ThreadStateStack;
import org.ow2.dsrg.fm.tbpjava.checker.VariablesEvaluation;
import org.ow2.dsrg.fm.tbplib.ltsa.Edge;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAAutomaton;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAComponentSpecification;
import org.ow2.dsrg.fm.tbplib.ltsa.State;
import org.ow2.dsrg.fm.tbplib.parsed.MethodCall;
import org.ow2.dsrg.fm.tbplib.resolved.CVRef;
import org.ow2.dsrg.fm.tbplib.resolved.ConstantRef;
import org.ow2.dsrg.fm.tbplib.resolved.LastCallRef;
import org.ow2.dsrg.fm.tbplib.resolved.Reference;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedAssignment;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedCondition;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedImperativeNull;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedReturn;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedUndefinedEmit;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedValue;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedEmit;
import org.ow2.dsrg.fm.tbplib.resolved.util.Binding;
import org.ow2.dsrg.fm.tbplib.util.Typedef;

final class AutomatonsMoves {
    private static final boolean DEBUG = false;
    private static final boolean FINAL_AUTOMATON_STATE_GO_THROUGHT = false;
    private StatesMapper varStatesMap;
    private AutomatonWalker walker;
    private LTSAComponentSpecification specification;
    private Map<Edge, String> reverseEdgeMap;
    private static Map<LTSAComponentSpecification, Map<Edge, String>> reverseEdgeMapCache = new HashMap<LTSAComponentSpecification, Map<Edge, String>>(1);

    public AutomatonsMoves(LTSAComponentSpecification specification, StatesMapper varStatesMap) {
        assert (specification != null);
        assert (varStatesMap != null);
        this.specification = specification;
        this.varStatesMap = varStatesMap;
        this.reverseEdgeMap = AutomatonsMoves.createReverseEdgeMap(specification);
        this.walker = new AutomatonWalker();
    }

    public final Map<Edge, String> getReverseEdgeMap() {
        return this.reverseEdgeMap;
    }

    private final void saveNewAutomatonState(Set<AutomatonState> newStoredAutomatonStates, AutomatonState sourceAS, VariablesEvaluation variables, Edge edge, boolean edgeActionProcessed) {
        AutomatonState newAS = new AutomatonState(sourceAS, edge, edgeActionProcessed);
        newStoredAutomatonStates.add(newAS);
        this.varStatesMap.setMappings(newAS, variables);
    }

    private final boolean planFurtherProcessing(Set<AutomatonState> newStoredAutomatonStates, AutomatonState as, VariablesEvaluation variables, Edge edge, boolean edgeActionProcessed) {
        State targetState = edge.getTarget();
        boolean isTargetStateFinal = as.getAutomaton().getFin().equals(targetState);
        if (isTargetStateFinal) {
            this.saveNewAutomatonState(newStoredAutomatonStates, as, variables, edge, true);
            return false;
        }
        if (!$assertionsDisabled) {
            if (isTargetStateFinal) {
                // empty if block
            }
            if (isTargetStateFinal) {
                throw new AssertionError();
            }
        }
        this.walker.setStateToExplore(as, variables, targetState);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processEdge(Set<AutomatonState> newStoredAutomatonStates, AutomatonWalker.EdgeToProcess edge2process, PROCESS_MODE processingMode) {
        boolean result = false;
        Edge e = edge2process.getEdge();
        State targetState = e.getTarget();
        Object edgeType = e.getData();
        AutomatonState as = edge2process.getAs();
        boolean isTargetStateFinal = as.getAutomaton().getFin().equals(targetState);
        VariablesEvaluation variables = edge2process.getVariables();
        if (edgeType instanceof TBPResolvedImperativeNull) {
            return this.planFurtherProcessing(newStoredAutomatonStates, as, variables, e, true);
        }
        if (edgeType == null) {
            return this.planFurtherProcessing(newStoredAutomatonStates, as, variables, e, true);
        }
        if (edgeType instanceof TBPResolvedAssignment) {
            TBPResolvedAssignment edgeAssigment = (TBPResolvedAssignment)edgeType;
            TBPResolvedValue tbpValue = edgeAssigment.getValue();
            if (tbpValue.isReference()) {
                Reference ref = tbpValue.getReference();
                if (ref instanceof LastCallRef) {
                    ThreadStateStack.ReturnValues retValType = this.varStatesMap.getLastCallReturnValueType(as.getThreadNum(), variables);
                    if (retValType == ThreadStateStack.ReturnValues.RET_VAL_NOT_SET) {
                        throw new RuntimeException("Internal error - No return values specified");
                    }
                    if (retValType == ThreadStateStack.ReturnValues.RET_VAL_SET) {
                        String lastCallReturnValue = this.varStatesMap.getLastCallReturnValue(as.getThreadNum(), variables);
                        variables = variables.setVariableValue(edgeAssigment.getIdf().getName(), lastCallReturnValue);
                        return this.planFurtherProcessing(newStoredAutomatonStates, as, variables, e, true);
                    }
                    if (retValType != ThreadStateStack.ReturnValues.RET_VAL_UNDEFINED_EMIT) throw new RuntimeException("Unknown enum value " + (Object)((Object)retValType) + " in the " + ThreadStateStack.ReturnValues.class.getName());
                    Typedef assignedType = edgeAssigment.getIdf().getType();
                    Iterator i$ = assignedType.getEnums().iterator();
                    while (i$.hasNext()) {
                        String assignedValue = (String)i$.next();
                        variables = variables.setVariableValue(edgeAssigment.getIdf().getName(), assignedValue);
                        result = this.planFurtherProcessing(newStoredAutomatonStates, as, variables, e, true);
                    }
                    return result;
                }
                if (!(ref instanceof ConstantRef)) throw new RuntimeException("Unknown assignment reference value type " + ref.getClass().toString());
                variables = variables.setVariableValue(edgeAssigment.getIdf().getName(), tbpValue.getReference().getName());
                return this.planFurtherProcessing(newStoredAutomatonStates, as, variables, e, true);
            }
            this.saveNewAutomatonState(newStoredAutomatonStates, as, variables, e, false);
            return false;
        }
        if (edgeType instanceof TBPResolvedEmit) {
            this.saveNewAutomatonState(newStoredAutomatonStates, as, variables, e, false);
            return false;
        }
        if (edgeType instanceof TBPResolvedUndefinedEmit) {
            this.saveNewAutomatonState(newStoredAutomatonStates, as, variables, e, false);
            this.varStatesMap.setLastCallReturnValueTypeUndefinedEmit(as.getThreadNum(), variables);
            return false;
        }
        if (edgeType instanceof TBPResolvedReturn) {
            TBPResolvedReturn edgeReturn = (TBPResolvedReturn)edgeType;
            ConstantRef retValRef = edgeReturn.getReturnValue();
            String retVal = null;
            if (retValRef != null) {
                retVal = retValRef.getName();
                this.varStatesMap.setReturnValue(as.getThreadNum(), variables, retVal);
            }
            this.saveNewAutomatonState(newStoredAutomatonStates, as, variables, e, true);
            return false;
        }
        if (edgeType instanceof TBPResolvedCondition) {
            TBPResolvedCondition edgeCond = (TBPResolvedCondition)edgeType;
            TBPResolvedCondition.ConditionType cond_type = edgeCond.getConditionType();
            if (cond_type == TBPResolvedCondition.ConditionType.CONDITION_ANY) {
                return this.planFurtherProcessing(newStoredAutomatonStates, as, variables, e, true);
            }
            if (cond_type == TBPResolvedCondition.ConditionType.CONDITION_VARIABLE_CONSTANT) {
                String variableName = edgeCond.getLeft().getName();
                String variableValue = variables.getVariableValue(variableName);
                String constantValue = edgeCond.getRight().getName();
                if (!edgeCond.isNegated()) {
                    if (variableValue.equals(constantValue)) return this.planFurtherProcessing(newStoredAutomatonStates, as, variables, e, true);
                }
                if (!edgeCond.isNegated()) return false;
                if (variableValue.equals(constantValue)) return false;
                return this.planFurtherProcessing(newStoredAutomatonStates, as, variables, e, true);
            }
            if (cond_type == TBPResolvedCondition.ConditionType.CONDITION_VARIABLE_IN_CONSTANTS) {
                String variableName = edgeCond.getLeft().getName();
                String variableValue = variables.getVariableValue(variableName);
                Iterator i$ = edgeCond.getRightList().iterator();
                while (i$.hasNext()) {
                    ConstantRef constReference = (ConstantRef)i$.next();
                    String constantValue = constReference.getName();
                    if (edgeCond.isNegated() || !variableValue.equals(constantValue)) {
                        if (!edgeCond.isNegated()) return false;
                        if (variableValue.equals(constantValue)) return false;
                    }
                    result = this.planFurtherProcessing(newStoredAutomatonStates, as, variables, e, true);
                }
                return result;
            }
            if (cond_type != TBPResolvedCondition.ConditionType.CONDITION_MULTIPLE_VARIABLES_TO_CONSTANT_ONE_BY_ONE) throw new RuntimeException("Unknown condition type - " + cond_type.toString());
            throw new RuntimeException("This condition exists only in inlined automatons that we are not using.");
        }
        if (!(edgeType instanceof CVRef)) throw new RuntimeException(AutomatonsMoves.class.getSimpleName() + ":automatonProcessEdge - unknown edge type - e" + edgeType.getClass().toString());
        CVRef edgeCVRef = (CVRef)edgeType;
        if (!Typedef.MUTEX_TYPE.equals((Object)edgeCVRef.getType())) {
            throw new RuntimeException("Unknown CVRef (not representing mutex) referenced type - " + edgeCVRef.getType());
        }
        if (processingMode == PROCESS_MODE.PROCESS_MODE_MUTEXES_STOP) {
            if (isTargetStateFinal) {
                throw new RuntimeException("Internal error - unexpected automaton - final state directly after mutex enter");
            }
            this.saveNewAutomatonState(newStoredAutomatonStates, as, variables, e, false);
            return false;
        }
        if (processingMode != PROCESS_MODE.PROCESS_MODE_EXECUTE_MUTEXES) throw new RuntimeException("New unknown enum " + PROCESS_MODE.class.getSimpleName() + " entry called " + (Object)((Object)processingMode) + ". Update checker code please.");
        String mutexVariableName = edgeCVRef.getName();
        assert (mutexVariableName != null);
        String mutexState = variables.getVariableValue(mutexVariableName);
        assert (mutexState != null);
        if (Typedef.UNLOCKED.equals(mutexState)) {
            variables = variables.setVariableValue(mutexVariableName, Typedef.LOCKED);
            if (isTargetStateFinal) {
                throw new RuntimeException("Internal error - unexpected automaton - final state directly after mutex enter");
            }
            if (isTargetStateFinal) {
                // empty if block
            }
            if (isTargetStateFinal) return result;
            this.walker.setStateToExplore(as, variables, targetState);
            return true;
        }
        if (!Typedef.LOCKED.equals(mutexState)) throw new RuntimeException("Unknown mutex (" + mutexVariableName + ") state (neither " + Typedef.LOCKED + " nor " + Typedef.UNLOCKED + " - actual value is " + mutexState + ")");
        return false;
    }

    public Set<AutomatonState> moveAutomatons(Set<AutomatonState> currentAutomatonStates) {
        assert (currentAutomatonStates != null);
        AutomatonWalker.EdgeToProcess edge2Process = new AutomatonWalker.EdgeToProcess();
        HashSet<AutomatonState> newStoredAutomatonStates = new HashSet<AutomatonState>(currentAutomatonStates.size());
        Set<AutomatonState> statesToProcess = this.filterProcessedStates(currentAutomatonStates);
        Map<AutomatonState, Set<VariablesEvaluation>> mappingsToProcess = this.getStatesMappings(statesToProcess);
        for (Map.Entry<AutomatonState, Set<VariablesEvaluation>> entry : mappingsToProcess.entrySet()) {
            AutomatonState as = entry.getKey();
            Set<VariablesEvaluation> variableStates = entry.getValue();
            assert (variableStates != null);
            if (as.getAutomaton().getFin().equals(as.getState())) {
                for (VariablesEvaluation variables : variableStates) {
                    this.saveNewAutomatonState(newStoredAutomatonStates, as, variables, as.getEdge(), true);
                }
                continue;
            }
            for (VariablesEvaluation variables : variableStates) {
                this.walker.clean();
                this.walker.setStateToExplore(as, variables, as.getState());
                while ((edge2Process = this.walker.getNextStateToExplore(edge2Process)) != null) {
                    this.processEdge(newStoredAutomatonStates, edge2Process, PROCESS_MODE.PROCESS_MODE_MUTEXES_STOP);
                }
            }
        }
        return newStoredAutomatonStates;
    }

    public Set<AutomatonState> moveAutomatonsEnterMutexes(Set<AutomatonState> currentAutomatonStates) {
        assert (currentAutomatonStates != null);
        AutomatonWalker.EdgeToProcess edge2Process = new AutomatonWalker.EdgeToProcess();
        HashSet<AutomatonState> newStoredAutomatonStates = new HashSet<AutomatonState>(currentAutomatonStates.size());
        Set<AutomatonState> statesToProcess = this.filterUnprocessedMutexes(currentAutomatonStates);
        newStoredAutomatonStates.addAll(currentAutomatonStates);
        newStoredAutomatonStates.removeAll(statesToProcess);
        Map<AutomatonState, Set<VariablesEvaluation>> mappingsToProcess = this.getStatesMappings(statesToProcess);
        for (Map.Entry<AutomatonState, Set<VariablesEvaluation>> entry : mappingsToProcess.entrySet()) {
            AutomatonState as = entry.getKey();
            Set<VariablesEvaluation> variableStates = entry.getValue();
            assert (variableStates != null);
            for (VariablesEvaluation variables : variableStates) {
                this.walker.clean();
                this.walker.setEdgeToExplore(as, variables, as.getEdge());
                while ((edge2Process = this.walker.getNextStateToExplore(edge2Process)) != null) {
                    this.processEdge(newStoredAutomatonStates, edge2Process, PROCESS_MODE.PROCESS_MODE_EXECUTE_MUTEXES);
                }
            }
        }
        return newStoredAutomatonStates;
    }

    private Set<AutomatonState> filterProcessedStates(Set<AutomatonState> toFilter) {
        HashSet<AutomatonState> result = new HashSet<AutomatonState>();
        for (AutomatonState as : toFilter) {
            if (!as.getEdgeActionProcessed()) continue;
            result.add(as);
        }
        return result;
    }

    private Set<AutomatonState> filterUnprocessedMutexes(Set<AutomatonState> toFilter) {
        HashSet<AutomatonState> result = new HashSet<AutomatonState>();
        for (AutomatonState as : toFilter) {
            CVRef cv;
            Object eData;
            Edge e;
            if (as.getEdgeActionProcessed() || (e = as.getEdge()) == null || !((eData = e.getData()) instanceof CVRef) || !Typedef.MUTEX_TYPE.equals((Object)(cv = (CVRef)eData).getType())) continue;
            result.add(as);
        }
        return result;
    }

    private Map<AutomatonState, Set<VariablesEvaluation>> getStatesMappings(Set<AutomatonState> states) {
        HashMap<AutomatonState, Set<VariablesEvaluation>> result = new HashMap<AutomatonState, Set<VariablesEvaluation>>(states.size());
        for (AutomatonState as : states) {
            Set<VariablesEvaluation> values = this.varStatesMap.getMappings(as);
            if (values == null) continue;
            result.put(as, values);
        }
        return result;
    }

    public boolean mapCallingStatesWithCalledStartState(ThreadAutomatons callingTA, Set<AutomatonState> callingStates, Set<AutomatonState> calledStatesSet) {
        boolean wasStateAdded = false;
        for (AutomatonState as : callingStates) {
            Binding calledMethod;
            Edge e = as.getEdge();
            Object edgeType = e.getData();
            if (edgeType instanceof TBPResolvedAssignment) {
                TBPResolvedAssignment edgeAssigment = (TBPResolvedAssignment)edgeType;
                assert (edgeAssigment.getValue().isMethodCall());
                calledMethod = edgeAssigment.getValue().getMethodCall().getBinding();
                this.mapCallingStatesWithCalledStartStateProcessCallMappings(callingTA, as, calledMethod, calledStatesSet);
                wasStateAdded = true;
                continue;
            }
            if (!(edgeType instanceof TBPResolvedEmit)) continue;
            TBPResolvedEmit edgeEmit = (TBPResolvedEmit)edgeType;
            calledMethod = edgeEmit.getBinding();
            this.mapCallingStatesWithCalledStartStateProcessCallMappings(callingTA, as, calledMethod, calledStatesSet);
            wasStateAdded = true;
        }
        return wasStateAdded;
    }

    private void mapCallingStatesWithCalledStartStateProcessCallMappings(ThreadAutomatons callingTA, AutomatonState callingState, Binding calledMethod, Set<AutomatonState> calledStateSet) {
        assert (calledMethod != null);
        Set<VariablesEvaluation> variablesSet = this.varStatesMap.getMappings(callingState);
        for (VariablesEvaluation variables : variablesSet) {
            Binding calledMethodBinding = calledMethod;
            if (calledMethodBinding.getParameterNamesNotBoundToConstant().size() > 0) {
                calledMethodBinding = calledMethodBinding.extractConstantBinding();
                for (String parameterName : calledMethod.getParameterNamesNotBoundToConstant()) {
                    Reference paramRef = calledMethod.getValue(parameterName);
                    if (paramRef instanceof CVRef) {
                        CVRef paramCVRef = (CVRef)paramRef;
                        String variableName = paramCVRef.getName();
                        ConstantRef paramValue = variables.getVariableValueReference(variableName);
                        assert (paramValue != null);
                        calledMethodBinding.bindParameter(parameterName, (Reference)paramValue);
                        continue;
                    }
                    String error = "INTERNAL ERROR - Unexpected parametery type (or null) " + paramRef.getClass().getName() + " Method name " + calledMethod.getFullname() + ". Parameter name " + parameterName;
                    callingTA.setError(error);
                    throw new RuntimeException(error);
                }
            }
            assert (calledMethodBinding.isBound());
            LTSAAutomaton calledAutomaton = (LTSAAutomaton)this.specification.getReactions().get(calledMethodBinding);
            if (calledAutomaton == null) {
                String error = "INTERNAL ERROR - Calling undefined automaton " + calledMethod;
                callingTA.setError(error);
                throw new RuntimeException(error);
            }
            AutomatonState newAS = new AutomatonState(calledAutomaton, calledAutomaton.getStart(), callingState.getThreadNum());
            this.varStatesMap.setMappingsAsCall(newAS, variables);
            calledStateSet.add(newAS);
        }
    }

    public void processReturnValues(ThreadAutomatons returningTA, Set<AutomatonState> returningStates, int threadNum) {
        for (AutomatonState as : returningStates) {
            Set<VariablesEvaluation> variablesSet = this.varStatesMap.getMappings(as);
            for (VariablesEvaluation variables : variablesSet) {
                String retVal = this.varStatesMap.getReturnValue(threadNum, variables);
                AutomatonState callerAS = this.varStatesMap.setMappingsAsReturn(threadNum, variables);
                if (callerAS == null) {
                    String error = "Implementation violates specification - required return without any found";
                    returningTA.setError(error);
                    throw new RuntimeException(error);
                }
                Edge e = callerAS.getEdge();
                assert (e != null);
                Object edgeType = e.getData();
                if (edgeType instanceof TBPResolvedAssignment) {
                    TBPResolvedAssignment edgeAssigment = (TBPResolvedAssignment)edgeType;
                    assert (edgeAssigment.getValue().isMethodCall());
                    this.varStatesMap.moveMappingToProcessing(variables);
                    variables = variables.setVariableValue(edgeAssigment.getIdf().getName(), retVal);
                    this.varStatesMap.setMappings(callerAS, variables);
                    continue;
                }
                if (!(edgeType instanceof TBPResolvedUndefinedEmit)) continue;
                throw new RuntimeException("Unexpected behavior ... should not process return values of the non existing automaton");
            }
        }
    }

    public Set<AutomatonState> filterStates(Set<AutomatonState> currentAutomatonStates, EventItem event) {
        assert (event != null);
        assert (currentAutomatonStates != null);
        HashSet<AutomatonState> resultSet = new HashSet<AutomatonState>(currentAutomatonStates.size());
        for (AutomatonState as : currentAutomatonStates) {
            Edge incommingEdge = as.getEdge();
            boolean expectedEdge = this.checkEventEdgeCorrespondent(incommingEdge, event);
            if (expectedEdge) {
                resultSet.add(as);
                continue;
            }
            this.varStatesMap.getMappings(as);
        }
        return resultSet;
    }

    public Set<AutomatonState> filterStatesOnReturnValue(Set<AutomatonState> currentAutomatonStates, EventItem event, String returnValue) {
        assert (currentAutomatonStates != null);
        if (returnValue == null) {
            return currentAutomatonStates;
        }
        HashSet<AutomatonState> resultSet = new HashSet<AutomatonState>(currentAutomatonStates.size());
        Map<AutomatonState, Set<VariablesEvaluation>> mappingsToProcess = this.getStatesMappings(currentAutomatonStates);
        for (Map.Entry<AutomatonState, Set<VariablesEvaluation>> entry : mappingsToProcess.entrySet()) {
            AutomatonState as = entry.getKey();
            Set<VariablesEvaluation> variableStates = entry.getValue();
            assert (variableStates != null);
            int variablesEvaluationCnt = 0;
            for (VariablesEvaluation variables : variableStates) {
                String retVal = this.varStatesMap.getReturnValue(event.thread, variables);
                if (!returnValue.equals(retVal)) continue;
                this.varStatesMap.setMappings(as, variables);
                ++variablesEvaluationCnt;
            }
            if (variablesEvaluationCnt <= 0) continue;
            resultSet.add(as);
        }
        return resultSet;
    }

    private boolean checkEventEdgeCorrespondent(Edge edge, EventItem event) {
        Object edgeType = edge.getData();
        if (edgeType instanceof TBPResolvedImperativeNull) {
            throw new RuntimeException("Unexpected method usage " + edgeType);
        }
        if (edgeType == null) {
            throw new RuntimeException("Unexpected method usage edgeType=null");
        }
        if (edgeType instanceof CVRef) {
            throw new RuntimeException("Unexpected method usage " + edgeType);
        }
        if (edgeType instanceof TBPResolvedCondition) {
            throw new RuntimeException("Unexpected method usage " + edgeType);
        }
        if (edgeType instanceof TBPResolvedAssignment) {
            TBPResolvedAssignment edgeAssigment = (TBPResolvedAssignment)edgeType;
            TBPResolvedValue tbpValue = edgeAssigment.getValue();
            if (tbpValue.isReference()) {
                throw new RuntimeException("Unexpected method usage " + edgeType);
            }
            TBPResolvedEmit calledMethod = tbpValue.getMethodCall();
            Binding calledMethodBinding = calledMethod.getBinding();
            if (event.type == EventItem.EventTypes.EVENT_CALL) {
                return calledMethodBinding.getFullname().equals(event.fullName);
            }
            if (event.type == EventItem.EventTypes.EVENT_RETURN) {
                return false;
            }
        } else if (edgeType instanceof TBPResolvedEmit) {
            TBPResolvedEmit edgeEmit = (TBPResolvedEmit)edgeType;
            Binding calledMethodBinding = edgeEmit.getBinding();
            if (event.type == EventItem.EventTypes.EVENT_CALL) {
                return calledMethodBinding.getFullname().equals(event.fullName);
            }
            if (event.type == EventItem.EventTypes.EVENT_RETURN) {
                return false;
            }
        } else if (edgeType instanceof TBPResolvedUndefinedEmit) {
            TBPResolvedUndefinedEmit edgeUndefEmit = (TBPResolvedUndefinedEmit)edgeType;
            MethodCall calledMethod = edgeUndefEmit.getMethodCall();
            if (event.type == EventItem.EventTypes.EVENT_CALL) {
                return calledMethod.getFullname().equals(event.fullName);
            }
            if (event.type == EventItem.EventTypes.EVENT_RETURN) {
                return false;
            }
        } else if (edgeType instanceof TBPResolvedReturn) {
            if (event.type == EventItem.EventTypes.EVENT_CALL) {
                return false;
            }
            if (event.type == EventItem.EventTypes.EVENT_RETURN) {
                String fullMethodName = this.reverseEdgeMap.get(edge);
                assert (fullMethodName != null);
                return fullMethodName.equals(event.fullName);
            }
        } else {
            throw new RuntimeException(AutomatonsMoves.class.getSimpleName() + ":automatonProcessEdge - unknown edge type - e" + edgeType.getClass().toString());
        }
        return false;
    }

    public Set<AutomatonState> edgeActicionProcess(Set<AutomatonState> currentAutomatonStates) {
        HashSet<AutomatonState> result = new HashSet<AutomatonState>();
        for (AutomatonState as : currentAutomatonStates) {
            if (as.getEdgeActionProcessed()) continue;
            AutomatonState asProcessed = as.edgeActionProcessed();
            result.add(asProcessed);
            Set<VariablesEvaluation> varEvals = this.varStatesMap.getMappings(as);
            for (VariablesEvaluation values : varEvals) {
                this.varStatesMap.setMappings(asProcessed, values);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Edge, String> createReverseEdgeMap(LTSAComponentSpecification spec) {
        assert (spec != null);
        Map<LTSAComponentSpecification, Map<Edge, String>> map = reverseEdgeMapCache;
        synchronized (map) {
            if (!reverseEdgeMapCache.containsKey(spec)) {
                reverseEdgeMapCache.put(spec, AutomatonsMoves.createNewReverseEdgeMap(spec));
            }
            return reverseEdgeMapCache.get(spec);
        }
    }

    public static Map<Edge, String> createNewReverseEdgeMap(LTSAComponentSpecification spec) {
        String eventName;
        LTSAAutomaton automaton;
        assert (spec != null);
        HashMap<Edge, String> result = new HashMap<Edge, String>();
        for (Map.Entry reactionPair : spec.getReactions().entrySet()) {
            automaton = (LTSAAutomaton)reactionPair.getValue();
            eventName = ((Binding)reactionPair.getKey()).getFullname();
            AutomatonsMoves.createNewReverseEdgeMapProcessAutomaton(automaton, eventName, result);
        }
        for (Map.Entry threadPair : spec.getThreads().entrySet()) {
            automaton = (LTSAAutomaton)threadPair.getValue();
            eventName = ".";
            AutomatonsMoves.createNewReverseEdgeMapProcessAutomaton(automaton, ".", result);
        }
        return result;
    }

    private static void createNewReverseEdgeMapProcessAutomaton(LTSAAutomaton automaton, String eventName, Map<Edge, String> result) {
        assert (automaton != null);
        assert (result != null);
        Stack<State> statesToProcess = new Stack<State>();
        HashSet<State> processedStates = new HashSet<State>();
        statesToProcess.push(automaton.getStart());
        while (!statesToProcess.isEmpty()) {
            State state = (State)statesToProcess.pop();
            if (processedStates.contains(state)) continue;
            processedStates.add(state);
            for (Edge e : state.getEdges()) {
                result.put(e, eventName);
                State targetState = e.getTarget();
                if (processedStates.contains(targetState)) continue;
                statesToProcess.push(targetState);
            }
        }
    }

    public static boolean isEndStateInSet(Set<AutomatonState> states) {
        assert (states != null);
        for (AutomatonState as : states) {
            if (!as.getAutomaton().getFin().equals(as.getState())) continue;
            return true;
        }
        return false;
    }

    public static enum PROCESS_MODE {
        PROCESS_MODE_MUTEXES_STOP,
        PROCESS_MODE_EXECUTE_MUTEXES;

    }
}

