/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TransactionRollbackOrderTest
extends TestCase {
    private static final Log log = LogFactory.getLog((Class)TransactionRollbackOrderTest.class);
    private volatile String receivedText;
    private Session producerSession;
    private Session consumerSession;
    private Destination queue;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private Connection connection;
    private CountDownLatch latch = new CountDownLatch(1);
    private int NUM_MESSAGES = 5;
    private List msgSent = new ArrayList();
    private List msgCommitted = new ArrayList();
    private List msgRolledBack = new ArrayList();
    private List msgRedelivered = new ArrayList();

    public void testTransaction() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.connection = factory.createConnection();
        this.queue = new ActiveMQQueue(((Object)((Object)this)).getClass().getName() + "." + this.getName());
        this.producerSession = this.connection.createSession(false, 1);
        this.consumerSession = this.connection.createSession(true, 0);
        this.producer = this.producerSession.createProducer(this.queue);
        this.consumer = this.consumerSession.createConsumer(this.queue);
        this.consumer.setMessageListener(new MessageListener(){
            int msgCount = 0;
            int msgCommittedCount = 0;

            public void onMessage(Message m) {
                try {
                    ++this.msgCount;
                    TextMessage tm = (TextMessage)m;
                    TransactionRollbackOrderTest.this.receivedText = tm.getText();
                    if (tm.getJMSRedelivered()) {
                        TransactionRollbackOrderTest.this.msgRedelivered.add(TransactionRollbackOrderTest.this.receivedText);
                    }
                    log.info((Object)("consumer received message: " + TransactionRollbackOrderTest.this.receivedText + (tm.getJMSRedelivered() ? " ** Redelivered **" : "")));
                    if (this.msgCount == 3) {
                        TransactionRollbackOrderTest.this.msgRolledBack.add(TransactionRollbackOrderTest.this.receivedText);
                        TransactionRollbackOrderTest.this.consumerSession.rollback();
                        log.info((Object)("[msg: " + TransactionRollbackOrderTest.this.receivedText + "] ** rolled back **"));
                    } else {
                        ++this.msgCommittedCount;
                        TransactionRollbackOrderTest.this.msgCommitted.add(TransactionRollbackOrderTest.this.receivedText);
                        TransactionRollbackOrderTest.this.consumerSession.commit();
                        log.info((Object)("[msg: " + TransactionRollbackOrderTest.this.receivedText + "] committed transaction "));
                    }
                    if (this.msgCommittedCount == TransactionRollbackOrderTest.this.NUM_MESSAGES) {
                        TransactionRollbackOrderTest.this.latch.countDown();
                    }
                }
                catch (JMSException e) {
                    try {
                        TransactionRollbackOrderTest.this.consumerSession.rollback();
                        log.info((Object)"rolled back transaction");
                    }
                    catch (JMSException e1) {
                        log.info((Object)e1);
                        e1.printStackTrace();
                    }
                    log.info((Object)e);
                    e.printStackTrace();
                }
            }
        });
        this.connection.start();
        TextMessage tm = null;
        try {
            for (int i = 1; i <= this.NUM_MESSAGES; ++i) {
                tm = this.producerSession.createTextMessage();
                tm.setText("Hello " + i);
                this.msgSent.add(tm.getText());
                this.producer.send((Message)tm);
                log.info((Object)("producer sent message: " + tm.getText()));
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        log.info((Object)"Waiting for latch");
        this.latch.await();
        TransactionRollbackOrderTest.assertEquals((int)1, (int)this.msgRolledBack.size());
        TransactionRollbackOrderTest.assertEquals((int)1, (int)this.msgRedelivered.size());
        log.info((Object)("msg RolledBack = " + this.msgRolledBack.get(0)));
        log.info((Object)("msg Redelivered = " + this.msgRedelivered.get(0)));
        TransactionRollbackOrderTest.assertEquals(this.msgRolledBack.get(0), this.msgRedelivered.get(0));
        TransactionRollbackOrderTest.assertEquals((int)this.NUM_MESSAGES, (int)this.msgSent.size());
        TransactionRollbackOrderTest.assertEquals((int)this.NUM_MESSAGES, (int)this.msgCommitted.size());
        TransactionRollbackOrderTest.assertEquals((Object)this.msgSent, (Object)this.msgCommitted);
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            log.info((Object)"Closing the connection");
            this.connection.close();
        }
        super.tearDown();
    }
}

