/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.test.TestSupport;
import org.apache.activemq.util.IdGenerator;

public class TopicRedeliverTest
extends TestSupport {
    private static final int RECEIVE_TIMEOUT = 10000;
    private IdGenerator idGen = new IdGenerator();
    protected int deliveryMode = 2;

    public TopicRedeliverTest() {
    }

    public TopicRedeliverTest(String n) {
        super(n);
    }

    protected void setup() throws Exception {
        super.setUp();
        this.topic = true;
    }

    public void testClientAcknowledge() throws Exception {
        Destination destination = this.createDestination(((Object)((Object)this)).getClass().getName());
        Connection connection = this.createConnection();
        connection.setClientID(this.idGen.generateId());
        connection.start();
        Session consumerSession = connection.createSession(false, 2);
        MessageConsumer consumer = consumerSession.createConsumer(destination);
        Session producerSession = connection.createSession(false, 1);
        MessageProducer producer = producerSession.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        TextMessage sent1 = producerSession.createTextMessage();
        sent1.setText("msg1");
        producer.send((Message)sent1);
        TextMessage sent2 = producerSession.createTextMessage();
        sent1.setText("msg2");
        producer.send((Message)sent2);
        TextMessage sent3 = producerSession.createTextMessage();
        sent1.setText("msg3");
        producer.send((Message)sent3);
        Message rec1 = consumer.receive(10000L);
        Message rec2 = consumer.receive(10000L);
        Message rec3 = consumer.receive(10000L);
        rec2.acknowledge();
        TextMessage sent4 = producerSession.createTextMessage();
        sent4.setText("msg4");
        producer.send((Message)sent4);
        Message rec4 = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((boolean)rec4.equals(sent4));
        consumerSession.recover();
        rec4 = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((boolean)rec4.equals(sent4));
        TopicRedeliverTest.assertTrue((boolean)rec4.getJMSRedelivered());
        rec4.acknowledge();
        connection.close();
    }

    public void testRedilveredFlagSetOnRollback() throws Exception {
        Destination destination = this.createDestination(((Object)((Object)this)).getClass().getName());
        Connection connection = this.createConnection();
        connection.setClientID(this.idGen.generateId());
        connection.start();
        Session consumerSession = connection.createSession(true, 2);
        Object consumer = null;
        consumer = this.topic ? consumerSession.createDurableSubscriber((Topic)destination, "TESTRED") : consumerSession.createConsumer(destination);
        Session producerSession = connection.createSession(true, 1);
        MessageProducer producer = producerSession.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        TextMessage sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg1");
        producer.send((Message)sentMsg);
        producerSession.commit();
        Message recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((!recMsg.getJMSRedelivered() ? 1 : 0) != 0);
        recMsg = consumer.receive(10000L);
        consumerSession.rollback();
        recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((boolean)recMsg.getJMSRedelivered());
        consumerSession.commit();
        TopicRedeliverTest.assertTrue((boolean)recMsg.equals(sentMsg));
        TopicRedeliverTest.assertTrue((boolean)recMsg.getJMSRedelivered());
        connection.close();
    }

    public void XtestTransactionRollbackOnSessionClose() throws Exception {
        Destination destination = this.createDestination(((Object)((Object)this)).getClass().getName());
        Connection connection = this.createConnection();
        connection.setClientID(this.idGen.generateId());
        connection.start();
        Session consumerSession = connection.createSession(true, 2);
        Object consumer = null;
        consumer = this.topic ? consumerSession.createDurableSubscriber((Topic)destination, "TESTRED") : consumerSession.createConsumer(destination);
        Session producerSession = connection.createSession(true, 1);
        MessageProducer producer = producerSession.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        TextMessage sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg1");
        producer.send((Message)sentMsg);
        producerSession.commit();
        Message recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((!recMsg.getJMSRedelivered() ? 1 : 0) != 0);
        consumerSession.close();
        consumerSession = connection.createSession(true, 2);
        consumer = consumerSession.createConsumer(destination);
        recMsg = consumer.receive(10000L);
        consumerSession.commit();
        TopicRedeliverTest.assertTrue((boolean)recMsg.equals(sentMsg));
        connection.close();
    }

    public void testTransactionRollbackOnSend() throws Exception {
        Destination destination = this.createDestination(((Object)((Object)this)).getClass().getName());
        Connection connection = this.createConnection();
        connection.setClientID(this.idGen.generateId());
        connection.start();
        Session consumerSession = connection.createSession(true, 2);
        MessageConsumer consumer = consumerSession.createConsumer(destination);
        Session producerSession = connection.createSession(true, 1);
        MessageProducer producer = producerSession.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        TextMessage sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg1");
        producer.send((Message)sentMsg);
        producerSession.commit();
        Message recMsg = consumer.receive(10000L);
        consumerSession.commit();
        TopicRedeliverTest.assertTrue((boolean)recMsg.equals(sentMsg));
        sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg2");
        producer.send((Message)sentMsg);
        producerSession.rollback();
        sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg3");
        producer.send((Message)sentMsg);
        producerSession.commit();
        recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((boolean)recMsg.equals(sentMsg));
        consumerSession.commit();
        connection.close();
    }
}

