/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;

public abstract class DurableSubscriptionTestSupport
extends TestSupport {
    private Connection connection;
    private Session session;
    private TopicSubscriber consumer;
    private MessageProducer producer;
    private BrokerService broker;

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://durable-broker");
    }

    protected Connection createConnection() throws Exception {
        Connection rc = super.createConnection();
        rc.setClientID(this.getName());
        return rc;
    }

    protected void setUp() throws Exception {
        this.createBroker();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.destroyBroker();
    }

    protected void restartBroker() throws Exception {
        this.destroyBroker();
        this.createRestartedBroker();
    }

    private void createBroker() throws Exception {
        try {
            this.broker = new BrokerService();
            this.broker.setBrokerName("durable-broker");
            this.broker.setDeleteAllMessagesOnStartup(true);
            this.broker.setPersistenceAdapter(this.createPersistenceAdapter());
            this.broker.setPersistent(true);
            this.broker.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connection = this.createConnection();
    }

    private void createRestartedBroker() throws Exception {
        try {
            this.broker = new BrokerService();
            this.broker.setBrokerName("durable-broker");
            this.broker.setDeleteAllMessagesOnStartup(false);
            this.broker.setPersistenceAdapter(this.createPersistenceAdapter());
            this.broker.setPersistent(true);
            this.broker.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connection = this.createConnection();
    }

    private void destroyBroker() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected abstract PersistenceAdapter createPersistenceAdapter() throws Exception;

    public void testUnsubscribeSubscription() throws Exception {
        this.session = this.connection.createSession(false, 1);
        Topic topic = this.session.createTopic("TestTopic");
        this.consumer = this.session.createDurableSubscriber(topic, "sub1");
        this.producer = this.session.createProducer((Destination)topic);
        this.producer.setDeliveryMode(2);
        this.connection.start();
        this.producer.send((Message)this.session.createTextMessage("Msg:1"));
        this.assertTextMessageEquals("Msg:1", this.consumer.receive(5000L));
        this.consumer.close();
        this.producer.send((Message)this.session.createTextMessage("Msg:2"));
        this.session.unsubscribe("sub1");
        this.connection.close();
        this.connection = this.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.producer = this.session.createProducer((Destination)topic);
        this.connection.start();
        this.consumer = this.session.createDurableSubscriber(topic, "sub1");
        this.producer.send((Message)this.session.createTextMessage("Msg:3"));
        this.assertTextMessageEquals("Msg:3", this.consumer.receive(5000L));
    }

    public void testInactiveDurableSubscriptionTwoConnections() throws Exception {
        this.session = this.connection.createSession(false, 1);
        Topic topic = this.session.createTopic("TestTopic");
        this.consumer = this.session.createDurableSubscriber(topic, "sub1");
        this.producer = this.session.createProducer((Destination)topic);
        this.producer.setDeliveryMode(2);
        this.connection.start();
        this.producer.send((Message)this.session.createTextMessage("Msg:1"));
        this.assertTextMessageEquals("Msg:1", this.consumer.receive(5000L));
        this.consumer.close();
        this.producer.send((Message)this.session.createTextMessage("Msg:2"));
        this.connection.close();
        this.connection = this.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.connection.start();
        this.consumer = this.session.createDurableSubscriber(topic, "sub1");
        this.assertTextMessageEquals("Msg:2", this.consumer.receive(5000L));
    }

    public void testInactiveDurableSubscriptionBrokerRestart() throws Exception {
        this.session = this.connection.createSession(false, 1);
        Topic topic = this.session.createTopic("TestTopic");
        this.consumer = this.session.createDurableSubscriber(topic, "sub1");
        this.producer = this.session.createProducer((Destination)topic);
        this.producer.setDeliveryMode(2);
        this.connection.start();
        this.producer.send((Message)this.session.createTextMessage("Msg:1"));
        this.assertTextMessageEquals("Msg:1", this.consumer.receive(5000L));
        this.consumer.close();
        this.producer.send((Message)this.session.createTextMessage("Msg:2"));
        this.restartBroker();
        this.session = this.connection.createSession(false, 1);
        this.connection.start();
        this.consumer = this.session.createDurableSubscriber(topic, "sub1");
        this.assertTextMessageEquals("Msg:2", this.consumer.receive(5000L));
        DurableSubscriptionTestSupport.assertNull((Object)this.consumer.receive(5000L));
    }

    public void testDurableSubscriptionPersistsPastBrokerRestart() throws Exception {
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        Topic topic = this.session.createTopic("TestTopic?consumer.retroactive=true");
        this.consumer = this.session.createDurableSubscriber(topic, "sub1");
        this.restartBroker();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.producer = this.session.createProducer((Destination)topic);
        this.producer.setDeliveryMode(2);
        this.producer.send((Message)this.session.createTextMessage("Msg:1"));
        this.consumer = this.session.createDurableSubscriber(topic, "sub1");
        this.producer.send((Message)this.session.createTextMessage("Msg:2"));
        this.assertTextMessageEquals("Msg:1", this.consumer.receive(5000L));
        this.assertTextMessageEquals("Msg:2", this.consumer.receive(5000L));
        DurableSubscriptionTestSupport.assertNull((Object)this.consumer.receive(5000L));
    }

    public void testInactiveDurableSubscriptionOneConnection() throws Exception {
        this.session = this.connection.createSession(false, 1);
        Topic topic = this.session.createTopic("TestTopic");
        this.consumer = this.session.createDurableSubscriber(topic, "sub1");
        this.producer = this.session.createProducer((Destination)topic);
        this.producer.setDeliveryMode(2);
        this.connection.start();
        this.producer.send((Message)this.session.createTextMessage("Msg:1"));
        this.assertTextMessageEquals("Msg:1", this.consumer.receive(5000L));
        this.consumer.close();
        this.producer.send((Message)this.session.createTextMessage("Msg:2"));
        this.consumer = this.session.createDurableSubscriber(topic, "sub1");
        this.assertTextMessageEquals("Msg:2", this.consumer.receive(5000L));
    }

    public void xtestSelectorChange() throws Exception {
        this.session = this.connection.createSession(false, 1);
        Topic topic = this.session.createTopic("TestTopic");
        this.consumer = this.session.createDurableSubscriber(topic, "sub1", "color='red'", false);
        this.producer = this.session.createProducer((Destination)topic);
        this.producer.setDeliveryMode(2);
        this.connection.start();
        TextMessage msg = this.session.createTextMessage();
        msg.setText("Msg:1");
        msg.setStringProperty("color", "blue");
        this.producer.send((Message)msg);
        msg.setText("Msg:2");
        msg.setStringProperty("color", "red");
        this.producer.send((Message)msg);
        this.assertTextMessageEquals("Msg:2", this.consumer.receive(5000L));
        this.consumer.close();
        this.consumer = this.session.createDurableSubscriber(topic, "sub1", "color='blue'", false);
        msg.setText("Msg:3");
        msg.setStringProperty("color", "red");
        this.producer.send((Message)msg);
        msg.setText("Msg:4");
        msg.setStringProperty("color", "blue");
        this.producer.send((Message)msg);
        this.assertTextMessageEquals("Msg:4", this.consumer.receive(5000L));
    }

    public void testDurableSubWorksInNewSession() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub1");
        while (consumer.receive(1000L) != null) {
        }
        session.close();
        session = this.connection.createSession(false, 2);
        MessageProducer producer = this.createProducer(session, (Destination)topic);
        producer.send((Message)session.createTextMessage("Message 1"));
        consumer = session.createDurableSubscriber(topic, "sub1");
        Message msg = consumer.receive(1000L);
        DurableSubscriptionTestSupport.assertNotNull((Object)msg);
        DurableSubscriptionTestSupport.assertEquals((String)"Message 1", (String)((TextMessage)msg).getText());
    }

    public void testDurableSubWorksInNewConnection() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub1");
        while (consumer.receive(1000L) != null) {
        }
        this.connection.close();
        this.connection = this.createConnection();
        this.connection.start();
        session = this.connection.createSession(false, 2);
        MessageProducer producer = this.createProducer(session, (Destination)topic);
        producer.send((Message)session.createTextMessage("Message 1"));
        consumer = session.createDurableSubscriber(topic, "sub1");
        Message msg = consumer.receive(1000L);
        DurableSubscriptionTestSupport.assertNotNull((Object)msg);
        DurableSubscriptionTestSupport.assertEquals((String)"Message 1", (String)((TextMessage)msg).getText());
    }

    private MessageProducer createProducer(Session session, Destination queue) throws JMSException {
        MessageProducer producer = session.createProducer(queue);
        producer.setDeliveryMode(this.getDeliveryMode());
        return producer;
    }

    protected int getDeliveryMode() {
        return 2;
    }

    private void assertTextMessageEquals(String string, Message message) throws JMSException {
        DurableSubscriptionTestSupport.assertNotNull((String)"Message was null", (Object)message);
        DurableSubscriptionTestSupport.assertTrue((String)"Message is not a TextMessage", (boolean)(message instanceof TextMessage));
        DurableSubscriptionTestSupport.assertEquals((String)string, (String)((TextMessage)message).getText());
    }
}

