/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.activemq.EmbeddedBrokerTestSupport;

public class CreateLotsOfTemporaryQueuesTest
extends EmbeddedBrokerTestSupport {
    private static int numberToCreate = 500;
    private static long sleep = 20L;

    public static void main(String[] args) {
        CreateLotsOfTemporaryQueuesTest.configure(args);
        TestRunner.run((Test)CreateLotsOfTemporaryQueuesTest.suite());
    }

    public static Test suite() {
        return new TestSuite(CreateLotsOfTemporaryQueuesTest.class);
    }

    public void testCreateLotsOfTemporaryQueues() throws Exception {
        log.info((Object)("Creating " + numberToCreate + " temporary queue(s)"));
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(true, 1);
        for (int i = 0; i < numberToCreate; ++i) {
            if (i % 1000 == 0) {
                log.info((Object)("attempt " + i));
            }
            TemporaryQueue temporaryQueue = session.createTemporaryQueue();
            temporaryQueue.delete();
            Thread.sleep(sleep);
        }
        log.info((Object)("Created " + numberToCreate + " temporary queue(s)"));
        connection.close();
    }

    public static void configure(String[] args) {
        if (args.length > 0) {
            numberToCreate = Integer.parseInt(args[0]);
        }
    }
}

