/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.usecases.ProducerConsumerTestSupport;

public class ConsumeTopicPrefetchTest
extends ProducerConsumerTestSupport {
    protected int prefetchSize = 100;
    protected String[] messageTexts;
    protected long consumerTimeout = 10000L;

    public void testSendPrefetchSize() throws JMSException {
        this.testWithMessageCount(this.prefetchSize);
    }

    public void testSendDoublePrefetchSize() throws JMSException {
        this.testWithMessageCount(this.prefetchSize * 2);
    }

    public void testSendPrefetchSizePlusOne() throws JMSException {
        this.testWithMessageCount(this.prefetchSize + 1);
    }

    protected void testWithMessageCount(int messageCount) throws JMSException {
        int i;
        this.makeMessages(messageCount);
        this.log.info((Object)("About to send and receive: " + messageCount + " on destination: " + this.destination + " of type: " + this.destination.getClass().getName()));
        for (i = 0; i < messageCount; ++i) {
            TextMessage message = this.session.createTextMessage(this.messageTexts[i]);
            this.producer.send((Message)message);
        }
        for (i = 0; i < messageCount; ++i) {
            this.consumeMessge(i);
        }
    }

    protected Connection createConnection() throws Exception {
        ActiveMQConnection connection = (ActiveMQConnection)super.createConnection();
        connection.getPrefetchPolicy().setQueuePrefetch(this.prefetchSize);
        connection.getPrefetchPolicy().setTopicPrefetch(this.prefetchSize);
        return connection;
    }

    protected void consumeMessge(int i) throws JMSException {
        Message message = this.consumer.receive(this.consumerTimeout);
        ConsumeTopicPrefetchTest.assertTrue((String)("Should have received a message by now for message: " + i), (message != null ? 1 : 0) != 0);
        ConsumeTopicPrefetchTest.assertTrue((String)("Should be a TextMessage: " + message), (boolean)(message instanceof TextMessage));
        TextMessage textMessage = (TextMessage)message;
        ConsumeTopicPrefetchTest.assertEquals((String)"Message content", (String)this.messageTexts[i], (String)textMessage.getText());
    }

    protected void makeMessages(int messageCount) {
        this.messageTexts = new String[messageCount];
        for (int i = 0; i < messageCount; ++i) {
            this.messageTexts[i] = "Message for test: + " + this.getName() + " = " + i;
        }
    }
}

