/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.udp;

import java.net.URI;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.CommandJoiner;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.udp.UdpTestSupport;
import org.apache.activemq.transport.udp.UdpTransport;
import org.apache.activemq.util.IntSequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UdpTransportTest
extends UdpTestSupport {
    protected static final Log log = LogFactory.getLog((Class)UdpTransportTest.class);
    protected int consumerPort = 9123;
    protected String producerURI = "udp://localhost:" + this.consumerPort;

    protected Transport createProducer() throws Exception {
        log.info((Object)("Producer using URI: " + this.producerURI));
        OpenWireFormat wireFormat = this.createWireFormat();
        UdpTransport transport = new UdpTransport(wireFormat, new URI(this.producerURI));
        transport.setSequenceGenerator(new IntSequenceGenerator());
        return new CommandJoiner((Transport)transport, wireFormat);
    }

    protected Transport createConsumer() throws Exception {
        log.info((Object)("Consumer on port: " + this.consumerPort));
        OpenWireFormat wireFormat = this.createWireFormat();
        UdpTransport transport = new UdpTransport(wireFormat, this.consumerPort);
        transport.setSequenceGenerator(new IntSequenceGenerator());
        return new CommandJoiner((Transport)transport, wireFormat);
    }

    protected OpenWireFormat createWireFormat() {
        return new OpenWireFormat();
    }
}

