/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;

public class TransportUriTest
extends EmbeddedBrokerTestSupport {
    private String postfix = "?tcpNoDelay=true&keepAlive=true";
    private Connection connection;

    public void testUriOptionsWork() throws Exception {
        String uri = this.bindAddress + this.postfix;
        this.connection = new ActiveMQConnectionFactory(uri).createConnection();
        this.connection.start();
    }

    public void testBadVersionNumberDoesNotWork() throws Exception {
        String uri = this.bindAddress + this.postfix + "&minmumWireFormatVersion=65535";
        try {
            this.connection = new ActiveMQConnectionFactory(uri).createConnection();
            this.connection.start();
            TransportUriTest.fail((String)"Should have thrown an exception!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBadPropertyNameFails() throws Exception {
        String uri = this.bindAddress + this.postfix + "&cheese=abc";
        try {
            this.connection = new ActiveMQConnectionFactory(uri).createConnection();
            this.connection.start();
            TransportUriTest.fail((String)"Should have thrown an exception!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:6161";
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(false);
        answer.setPersistent(this.isPersistent());
        answer.addConnector(this.bindAddress);
        return answer;
    }
}

