/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.tcp.SslTransportFactory;
import org.apache.activemq.transport.tcp.SslTransportServer;
import org.apache.activemq.transport.tcp.StubSSLSocket;
import org.apache.activemq.transport.tcp.StubSslTransport;
import org.apache.activemq.wireformat.WireFormat;

public class SslTransportFactoryTest
extends TestCase {
    private SslTransportFactory factory;
    private boolean verbose;

    protected void setUp() throws Exception {
        this.factory = new SslTransportFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBindServerOptions() throws IOException {
        SslTransportServer sslTransportServer = null;
        for (int i = 0; i < 4; ++i) {
            boolean wantClientAuth = (i & 1) == 1;
            boolean needClientAuth = (i & 2) == 1;
            String options = "wantClientAuth=" + (wantClientAuth ? "true" : "false") + "&needClientAuth=" + (needClientAuth ? "true" : "false");
            try {
                sslTransportServer = (SslTransportServer)this.factory.doBind("brokerId", new URI("ssl://localhost:61616?" + options));
            }
            catch (Exception e) {
                SslTransportFactoryTest.fail((String)("Unable to bind to address: " + e.getMessage()));
            }
            SslTransportFactoryTest.assertEquals((String)"Created ServerSocket did not have correct wantClientAuth status.", (boolean)sslTransportServer.getWantClientAuth(), (boolean)wantClientAuth);
            SslTransportFactoryTest.assertEquals((String)"Created ServerSocket did not have correct needClientAuth status.", (boolean)sslTransportServer.getNeedClientAuth(), (boolean)needClientAuth);
            try {
                sslTransportServer.stop();
                continue;
            }
            catch (Exception e) {
                SslTransportFactoryTest.fail((String)("Unable to stop TransportServer: " + e.getMessage()));
            }
        }
    }

    private int getMthNaryDigit(int number, int digitIdx, int numBase) {
        return number / (int)Math.pow(numBase, digitIdx) % numBase;
    }

    public void testCompositeConfigure() throws IOException {
        int[] optionSettings = new int[5];
        String[] optionNames = new String[]{"wantClientAuth", "needClientAuth", "socket.wantClientAuth", "socket.needClientAuth", "socket.useClientMode"};
        for (int i = 0; i < 243; ++i) {
            HashMap<String, String> options = new HashMap<String, String>();
            for (int j = 0; j < 5; ++j) {
                optionSettings[j] = this.getMthNaryDigit(i, j, 3) - 1;
                if (optionSettings[j] == -1) continue;
                options.put(optionNames[j], optionSettings[j] == 1 ? "true" : "false");
            }
            StubSSLSocket socketStub = new StubSSLSocket(null);
            StubSslTransport transport = null;
            try {
                transport = new StubSslTransport(null, socketStub);
            }
            catch (Exception e) {
                SslTransportFactoryTest.fail((String)("Unable to create StubSslTransport: " + e.getMessage()));
            }
            if (this.verbose) {
                System.out.println();
                System.out.println("Iteration: " + i);
                System.out.println("Map settings: " + options);
                for (int x = 0; x < optionSettings.length; ++x) {
                    System.out.println("optionSetting[" + x + "] = " + optionSettings[x]);
                }
            }
            this.factory.compositeConfigure((Transport)transport, (WireFormat)new OpenWireFormat(), options);
            try {
                transport.start();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (socketStub.getWantClientAuthStatus() != optionSettings[2]) {
                System.out.println("sheiite");
            }
            SslTransportFactoryTest.assertEquals((String)("wantClientAuth was not properly set for iteration: " + i), (int)optionSettings[0], (int)transport.getWantClientAuthStatus());
            SslTransportFactoryTest.assertEquals((String)("needClientAuth was not properly set for iteration: " + i), (int)optionSettings[1], (int)transport.getNeedClientAuthStatus());
            SslTransportFactoryTest.assertEquals((String)("socket.wantClientAuth was not properly set for iteration: " + i), (int)optionSettings[2], (int)socketStub.getWantClientAuthStatus());
            SslTransportFactoryTest.assertEquals((String)("socket.needClientAuth was not properly set for iteration: " + i), (int)optionSettings[3], (int)socketStub.getNeedClientAuthStatus());
            SslTransportFactoryTest.assertEquals((String)("socket.useClientMode was not properly set for iteration: " + i), (int)optionSettings[4], (int)socketStub.getUseClientModeStatus());
        }
    }
}

