/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StompSubscriptionRemoveTest
extends TestCase {
    private static final Log log = LogFactory.getLog((Class)StompSubscriptionRemoveTest.class);
    private Socket stompSocket;
    private ByteArrayOutputStream inputBuffer;

    public void testRemoveSubscriber() throws Exception {
        String ackmessage;
        String messageId;
        String line;
        DataInputStream input;
        String receiveFrame;
        int count;
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.addConnector("stomp://localhost:61613").setName("Stomp");
        broker.addConnector("tcp://localhost:61616").setName("Default");
        broker.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue(this.getDestinationName()));
        TextMessage message = session.createTextMessage("Testas");
        for (int idx = 0; idx < 2000; ++idx) {
            producer.send((Message)message);
            log.debug((Object)("Sending: " + idx));
        }
        producer.close();
        session.close();
        connection.close();
        this.stompSocket = new Socket("localhost", 61613);
        this.inputBuffer = new ByteArrayOutputStream();
        String connect_frame = "CONNECT\nlogin: brianm\npasscode: wombats\n\n";
        this.sendFrame(connect_frame);
        String f = this.receiveFrame(100000L);
        String frame = "SUBSCRIBE\ndestination:/queue/" + this.getDestinationName() + "\n" + "ack:client\n\n";
        this.sendFrame(frame);
        int messagesCount = 0;
        for (count = 0; count < 2; ++count) {
            receiveFrame = this.receiveFrame(10000L);
            input = new DataInputStream(new ByteArrayInputStream(receiveFrame.getBytes()));
            do {
                if ((line = input.readLine()) != null) continue;
                throw new IOException("connection was closed");
            } while ((line = line.trim()).length() <= 0);
            line = input.readLine();
            if (line == null) {
                throw new IOException("connection was closed");
            }
            messageId = line.substring(line.indexOf(58) + 1);
            messageId = messageId.trim();
            ackmessage = "ACK\nmessage-id:" + messageId + "\n\n";
            this.sendFrame(ackmessage);
            log.debug((Object)receiveFrame);
            ++messagesCount;
        }
        this.sendFrame("DISCONNECT\n\n");
        Thread.sleep(1000L);
        this.stompSocket.close();
        this.stompSocket = new Socket("localhost", 61613);
        this.inputBuffer = new ByteArrayOutputStream();
        connect_frame = "CONNECT\nlogin: brianm\npasscode: wombats\n\n";
        this.sendFrame(connect_frame);
        f = this.receiveFrame(5000L);
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getDestinationName() + "\n" + "ack:client\n\n";
        this.sendFrame(frame);
        try {
            while (count != 2000) {
                receiveFrame = this.receiveFrame(5000L);
                input = new DataInputStream(new ByteArrayInputStream(receiveFrame.getBytes()));
                do {
                    if ((line = input.readLine()) != null) continue;
                    throw new IOException("connection was closed");
                } while ((line = line.trim()).length() <= 0);
                line = input.readLine();
                if (line == null) {
                    throw new IOException("connection was closed");
                }
                messageId = line.substring(line.indexOf(58) + 1);
                messageId = messageId.trim();
                ackmessage = "ACK\nmessage-id:" + messageId + "\n\n";
                this.sendFrame(ackmessage);
                log.debug((Object)("Received: " + receiveFrame));
                ++messagesCount;
                ++count;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.sendFrame("DISCONNECT\n\n");
        this.stompSocket.close();
        broker.stop();
        log.info((Object)("Total messages received: " + messagesCount));
        StompSubscriptionRemoveTest.assertTrue((String)("Messages received after connection loss: " + messagesCount), (messagesCount >= 2000 ? 1 : 0) != 0);
    }

    public void sendFrame(String data) throws Exception {
        byte[] bytes = data.getBytes("UTF-8");
        OutputStream outputStream = this.stompSocket.getOutputStream();
        outputStream.write(bytes);
        outputStream.write(0);
        outputStream.flush();
    }

    public String receiveFrame(long timeOut) throws Exception {
        this.stompSocket.setSoTimeout((int)timeOut);
        InputStream is = this.stompSocket.getInputStream();
        int c = 0;
        while (true) {
            if ((c = is.read()) < 0) {
                throw new IOException("socket closed.");
            }
            if (c == 0) {
                c = is.read();
                byte[] ba = this.inputBuffer.toByteArray();
                this.inputBuffer.reset();
                return new String(ba, "UTF-8");
            }
            this.inputBuffer.write(c);
        }
    }

    protected String getDestinationName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }
}

