/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test.rollback;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelegatingTransactionalMessageListener
implements MessageListener {
    private static final transient Log log = LogFactory.getLog((Class)DelegatingTransactionalMessageListener.class);
    private final MessageListener underlyingListener;
    private boolean transacted = true;
    private int ackMode = 1;
    private Session session;

    public DelegatingTransactionalMessageListener(MessageListener underlyingListener, Connection connection, Destination destination) {
        this.underlyingListener = underlyingListener;
        try {
            this.session = connection.createSession(this.transacted, this.ackMode);
            MessageConsumer consumer = this.session.createConsumer(destination);
            consumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            throw new IllegalStateException("Could not listen to " + destination, e);
        }
    }

    public void onMessage(Message message) {
        try {
            this.underlyingListener.onMessage(message);
            this.session.commit();
        }
        catch (Throwable e) {
            this.rollback();
        }
    }

    private void rollback() {
        try {
            this.session.rollback();
        }
        catch (JMSException e) {
            log.error((Object)("Failed to rollback: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public Session getSession() {
        return this.session;
    }
}

