/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test;

import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.test.JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest;

public class JmsTopicSendReceiveWithEmbeddedBrokerAndUserIDTest
extends JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest {
    protected String userName = "James";

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory answer = super.createConnectionFactory();
        answer.setUserName(this.userName);
        return answer;
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        answer.setPopulateJMSXUserID(true);
        super.configureBroker(answer);
    }

    protected void assertMessagesReceivedAreValid(List receivedMessages) throws JMSException {
        super.assertMessagesReceivedAreValid(receivedMessages);
        Iterator iter = receivedMessages.iterator();
        while (iter.hasNext()) {
            Message message = (Message)iter.next();
            String userID = message.getStringProperty("JMSXUserID");
            log.info((Object)("Received message with userID: " + userID));
            JmsTopicSendReceiveWithEmbeddedBrokerAndUserIDTest.assertEquals((String)"JMSXUserID header", (String)this.userName, (String)userID);
        }
    }
}

