/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.test.TestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JmsSendReceiveTestSupport
extends TestSupport
implements MessageListener {
    protected static final Log log = LogFactory.getLog((Class)JmsSendReceiveTestSupport.class);
    protected int messageCount = 100;
    protected String[] data;
    protected Session session;
    protected Session consumeSession;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected List messages = this.createConcurrentList();
    protected boolean topic = true;
    protected boolean durable = false;
    protected int deliveryMode = 2;
    protected final Object lock = new Object();
    protected boolean verbose = false;
    protected boolean useSeparateSession = false;
    protected boolean largeMessages = false;
    protected int largeMessageLoopSize = 4096;

    protected void setUp() throws Exception {
        int i;
        super.setUp();
        String temp = System.getProperty("messageCount");
        if (temp != null && (i = Integer.parseInt(temp)) > 0) {
            this.messageCount = i;
        }
        log.info((Object)("Message count for test case is: " + this.messageCount));
        this.data = new String[this.messageCount];
        for (i = 0; i < this.messageCount; ++i) {
            this.data[i] = this.createMessageText(i);
        }
    }

    protected String createMessageText(int i) {
        if (this.largeMessages) {
            return this.createMessageBodyText();
        }
        return "Text for message: " + i + " at " + new Date();
    }

    protected String createMessageBodyText() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.largeMessageLoopSize; ++i) {
            buffer.append("0123456789");
        }
        return buffer.toString();
    }

    public void testSendReceive() throws Exception {
        Thread.sleep(1000L);
        this.messages.clear();
        for (int i = 0; i < this.data.length; ++i) {
            Message message = this.createMessage(i);
            this.configureMessage(message);
            if (this.verbose) {
                log.info((Object)("About to send a message: " + message + " with text: " + this.data[i]));
            }
            this.producer.send(this.producerDestination, message);
        }
        this.assertMessagesAreReceived();
        log.info((Object)("" + this.data.length + " messages(s) received, closing down connections"));
    }

    protected Message createMessage(int index) throws JMSException {
        TextMessage message = this.session.createTextMessage(this.data[index]);
        return message;
    }

    protected void configureMessage(Message message) throws JMSException {
    }

    protected void assertMessagesAreReceived() throws JMSException {
        this.waitForMessagesToBeDelivered();
        this.assertMessagesReceivedAreValid(this.messages);
    }

    protected void assertMessagesReceivedAreValid(List receivedMessages) throws JMSException {
        List<Object> copyOfMessages = Arrays.asList(receivedMessages.toArray());
        int counter = 0;
        if (this.data.length != copyOfMessages.size()) {
            Iterator<Object> iter = copyOfMessages.iterator();
            while (iter.hasNext()) {
                Object message = iter.next();
                log.info((Object)("<== " + counter++ + " = " + message));
            }
        }
        JmsSendReceiveTestSupport.assertEquals((String)"Not enough messages received", (int)this.data.length, (int)receivedMessages.size());
        for (int i = 0; i < this.data.length; ++i) {
            Message received = (Message)receivedMessages.get(i);
            this.assertMessageValid(i, received);
        }
    }

    protected void assertMessageValid(int index, Message message) throws JMSException {
        TextMessage textMessage = (TextMessage)message;
        String text = textMessage.getText();
        if (this.verbose) {
            log.info((Object)("Received Text: " + text));
        }
        JmsSendReceiveTestSupport.assertEquals((String)("Message: " + index), (String)this.data[index], (String)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForMessagesToBeDelivered() {
        long maxWaitTime;
        long waitTime = maxWaitTime = 60000L;
        long start = maxWaitTime <= 0L ? 0L : System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while (this.messages.size() < this.data.length && waitTime >= 0L) {
                try {
                    this.lock.wait(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                waitTime = maxWaitTime - (System.currentTimeMillis() - start);
            }
        }
    }

    public synchronized void onMessage(Message message) {
        this.consumeMessage(message, this.messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeMessage(Message message, List messageList) {
        if (this.verbose) {
            log.info((Object)("Received message: " + message));
        }
        messageList.add(message);
        if (messageList.size() >= this.data.length) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected List createConcurrentList() {
        return Collections.synchronizedList(new ArrayList());
    }
}

