/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.perf.PerfConsumer;
import org.apache.activemq.perf.PerfProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleTopicTest
extends TestCase {
    private static final Log log = LogFactory.getLog((Class)SimpleTopicTest.class);
    protected BrokerService broker;
    protected String bindAddress = "tcp://localhost:61616?wireFormat.cacheEnabled=true&wireFormat.tightEncodingEnabled=true";
    protected PerfProducer[] producers;
    protected PerfConsumer[] consumers;
    protected String DESTINATION_NAME = ((Object)((Object)this)).getClass().toString();
    protected int NUMBER_OF_CONSUMERS = 1;
    protected int NUMBER_OF_PRODUCERS = 1;
    protected BytesMessage payload;
    protected int PAYLOAD_SIZE = 1024;
    protected int MESSAGE_COUNT = 100000;
    protected byte[] array = null;
    protected ConnectionFactory factory;
    protected Destination destination;

    protected void setUp() throws Exception {
        int i;
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        this.array = new byte[this.PAYLOAD_SIZE];
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            this.array[i2] = (byte)i2;
        }
        this.factory = this.createConnectionFactory();
        Connection con = this.factory.createConnection();
        Session session = con.createSession(false, 1);
        this.payload = session.createBytesMessage();
        this.payload.writeBytes(this.array);
        this.destination = this.createDestination(session, this.DESTINATION_NAME);
        con.close();
        this.producers = new PerfProducer[this.NUMBER_OF_PRODUCERS];
        this.consumers = new PerfConsumer[this.NUMBER_OF_CONSUMERS];
        for (i = 0; i < this.NUMBER_OF_CONSUMERS; ++i) {
            this.consumers[i] = this.createConsumer(this.factory, this.destination, i);
            this.consumers[i].start();
        }
        for (i = 0; i < this.NUMBER_OF_PRODUCERS; ++i) {
            this.producers[i] = this.createProducer(this.factory, this.destination, i);
            this.producers[i].start();
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        int i;
        super.tearDown();
        for (i = 0; i < this.NUMBER_OF_CONSUMERS; ++i) {
            this.consumers[i].shutDown();
        }
        for (i = 0; i < this.NUMBER_OF_PRODUCERS; ++i) {
            this.producers[i].shutDown();
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker = null;
        }
    }

    protected Destination createDestination(Session s, String destinationName) throws JMSException {
        return s.createTopic(destinationName);
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer);
        answer.start();
        return answer;
    }

    protected PerfProducer createProducer(ConnectionFactory fac, Destination dest, int number) throws JMSException {
        return new PerfProducer(fac, dest);
    }

    protected PerfConsumer createConsumer(ConnectionFactory fac, Destination dest, int number) throws JMSException {
        return new PerfConsumer(fac, dest);
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        answer.addConnector(this.bindAddress);
        answer.setDeleteAllMessagesOnStartup(true);
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.bindAddress);
        return cf;
    }

    public void testPerformance() throws JMSException {
        for (int i = 0; i < this.MESSAGE_COUNT; ++i) {
            if (i % 10000 == 0) {
                this.dumpProducerRate();
                this.dumpConsumerRate();
            }
            this.payload.clearBody();
            this.payload.writeBytes(this.array);
            for (int k = 0; k < this.producers.length; ++k) {
                this.producers[k].sendMessage((Message)this.payload);
            }
        }
    }

    protected void dumpProducerRate() {
        int i;
        int count = 0;
        int totalCount = 0;
        for (i = 0; i < this.producers.length; ++i) {
            count += this.producers[i].getRate().getRate();
            totalCount += this.consumers[i].getRate().getTotalCount();
        }
        log.info((Object)("Producer rate = " + (count /= this.producers.length) + " msg/sec total count = " + totalCount));
        for (i = 0; i < this.producers.length; ++i) {
            this.producers[i].getRate().start();
        }
    }

    protected void dumpConsumerRate() {
        int i;
        int count = 0;
        int totalCount = 0;
        for (i = 0; i < this.consumers.length; ++i) {
            count += this.consumers[i].getRate().getRate();
            totalCount += this.consumers[i].getRate().getTotalCount();
        }
        log.info((Object)("Consumer rate = " + (count /= this.consumers.length) + " msg/sec total count = " + totalCount));
        for (i = 0; i < this.consumers.length; ++i) {
            this.consumers[i].getRate().start();
        }
    }
}

