/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.management;

import org.apache.activemq.management.RangeStatisticImpl;
import org.apache.activemq.management.StatisticImpl;
import org.apache.activemq.management.StatisticTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RangeStatisticTest
extends StatisticTestSupport {
    private static final Log log = LogFactory.getLog((Class)RangeStatisticTest.class);

    public void testStatistic() throws Exception {
        RangeStatisticImpl stat = new RangeStatisticImpl("myRange", "millis", "myDescription");
        this.assertStatistic((StatisticImpl)stat, "myRange", "millis", "myDescription");
        this.assertRangeStatistic(stat);
    }

    protected void assertRangeStatistic(RangeStatisticImpl stat) throws InterruptedException {
        RangeStatisticTest.assertEquals((long)0L, (long)stat.getCurrent());
        RangeStatisticTest.assertEquals((long)0L, (long)stat.getLowWaterMark());
        RangeStatisticTest.assertEquals((long)0L, (long)stat.getHighWaterMark());
        stat.setCurrent(100L);
        RangeStatisticTest.assertEquals((long)100L, (long)stat.getCurrent());
        RangeStatisticTest.assertEquals((long)100L, (long)stat.getLowWaterMark());
        RangeStatisticTest.assertEquals((long)100L, (long)stat.getHighWaterMark());
        stat.setCurrent(50L);
        RangeStatisticTest.assertEquals((long)50L, (long)stat.getCurrent());
        RangeStatisticTest.assertEquals((long)50L, (long)stat.getLowWaterMark());
        RangeStatisticTest.assertEquals((long)100L, (long)stat.getHighWaterMark());
        stat.setCurrent(200L);
        RangeStatisticTest.assertEquals((long)200L, (long)stat.getCurrent());
        RangeStatisticTest.assertEquals((long)50L, (long)stat.getLowWaterMark());
        RangeStatisticTest.assertEquals((long)200L, (long)stat.getHighWaterMark());
        Thread.sleep(500L);
        stat.setCurrent(10L);
        RangeStatisticTest.assertEquals((long)10L, (long)stat.getCurrent());
        RangeStatisticTest.assertEquals((long)10L, (long)stat.getLowWaterMark());
        RangeStatisticTest.assertEquals((long)200L, (long)stat.getHighWaterMark());
        this.assertLastTimeNotStartTime((StatisticImpl)stat);
        log.info((Object)("Stat is: " + stat));
        stat.reset();
        RangeStatisticTest.assertEquals((long)0L, (long)stat.getCurrent());
        RangeStatisticTest.assertEquals((long)0L, (long)stat.getLowWaterMark());
        RangeStatisticTest.assertEquals((long)0L, (long)stat.getHighWaterMark());
        stat.setCurrent(100L);
        RangeStatisticTest.assertEquals((long)100L, (long)stat.getCurrent());
        RangeStatisticTest.assertEquals((long)100L, (long)stat.getLowWaterMark());
        RangeStatisticTest.assertEquals((long)100L, (long)stat.getHighWaterMark());
    }
}

