/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreFactory;

public class MapContainerTest
extends TestCase {
    protected String name = "test";
    protected Store store;
    protected MapContainer container;
    protected Map testMap;
    protected static final int COUNT = 10;

    public void testSize() throws Exception {
        this.container.putAll(this.testMap);
        MapContainerTest.assertTrue((this.container.size() == this.testMap.size() ? 1 : 0) != 0);
    }

    public void testIsEmpty() throws Exception {
        MapContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testClear() throws Exception {
        this.container.putAll(this.testMap);
        MapContainerTest.assertTrue((this.container.size() == this.testMap.size() ? 1 : 0) != 0);
        this.container.clear();
        MapContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testContainsKeyObject() throws Exception {
        this.container.putAll(this.testMap);
        Iterator i = this.testMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            MapContainerTest.assertTrue((boolean)this.container.containsKey(entry.getKey()));
        }
    }

    public void testGetObject() throws Exception {
        this.container.putAll(this.testMap);
        Iterator i = this.testMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object value = this.container.get(entry.getKey());
            MapContainerTest.assertNotNull((Object)value);
            MapContainerTest.assertTrue((boolean)value.equals(entry.getValue()));
        }
    }

    public void testContainsValueObject() throws Exception {
        this.container.putAll(this.testMap);
        Iterator i = this.testMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            MapContainerTest.assertTrue((boolean)this.container.containsValue(entry.getValue()));
        }
    }

    public void testPutAllMap() throws Exception {
        this.container.putAll(this.testMap);
        Iterator i = this.testMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            MapContainerTest.assertTrue((boolean)this.container.containsValue(entry.getValue()));
            MapContainerTest.assertTrue((boolean)this.container.containsKey(entry.getKey()));
        }
    }

    public void testKeySet() throws Exception {
        this.container.putAll(this.testMap);
        Set keys = this.container.keySet();
        MapContainerTest.assertTrue((keys.size() == this.testMap.size() ? 1 : 0) != 0);
        Iterator i = this.testMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            MapContainerTest.assertTrue((boolean)keys.contains(key));
            keys.remove(key);
        }
        MapContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testValues() throws Exception {
        this.container.putAll(this.testMap);
        Collection values = this.container.values();
        MapContainerTest.assertTrue((values.size() == this.testMap.size() ? 1 : 0) != 0);
        Iterator i = this.testMap.values().iterator();
        while (i.hasNext()) {
            Object value = i.next();
            MapContainerTest.assertTrue((boolean)values.contains(value));
            MapContainerTest.assertTrue((boolean)values.remove(value));
        }
        MapContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testEntrySet() throws Exception {
        this.container.putAll(this.testMap);
        Set entries = this.container.entrySet();
        MapContainerTest.assertTrue((entries.size() == this.testMap.size() ? 1 : 0) != 0);
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            MapContainerTest.assertTrue((boolean)this.testMap.containsKey(entry.getKey()));
            MapContainerTest.assertTrue((boolean)this.testMap.containsValue(entry.getValue()));
        }
    }

    public void testRemoveObject() throws Exception {
        this.container.putAll(this.testMap);
        Iterator i = this.testMap.keySet().iterator();
        while (i.hasNext()) {
            this.container.remove(i.next());
        }
        MapContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    protected Store getStore() throws IOException {
        return StoreFactory.open((String)this.name, (String)"rw");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.name = System.getProperty("basedir", ".") + "/target/activemq-data/map-container.db";
        this.store = this.getStore();
        this.store.deleteListContainer((Object)this.name);
        this.container = this.store.getMapContainer((Object)this.name);
        this.container.load();
        this.testMap = new HashMap();
        for (int i = 0; i < 10; ++i) {
            String key = "key:" + i;
            String value = "value:" + i;
            this.testMap.put(key, value);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        MapContainerTest.assertTrue((boolean)StoreFactory.delete((String)this.name));
    }
}

